/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: XPathLocationException.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/06/21 10:24:23 $
 *****************************************************************************/

package org.ten60.netkernel.xml.xda;

/**
 *
 * @author  pjr
 */
public class XPathLocationException extends Exception{
	
	private String mMessage;
	private int mType;
	public static final int NULLTARGET=1;
	public static final int AMBIGUOUSTARGET=2;
	public static final int MALFORMEDTARGET=3;
	public static final int UNKNOWN=3;
	
	private static final String NULLTARGETMESSAGE="Null Target";
	private static final String AMBIGUOUSTARGETMESSAGE="Ambiguous Target";
	private static final String MALFORMEDTARGETMESSAGE="Malformed Target";
	private static final String UNKNOWNMESSAGE="Unknown Error";
	
	/** Creates a new instance of XPathImplementationException */
	public XPathLocationException()
	{	mMessage=null;
		mType=UNKNOWN;
	}
	
	public XPathLocationException(String aMessage, int aType)
	{	mMessage=aMessage;
		mType=aType;
	}
	
	public String getMessage(){ return mMessage;}
	
	public String getMessageWithType()
	{	StringBuffer sb=new StringBuffer();
		switch(mType)
		{
			case NULLTARGET:
				sb.append(NULLTARGETMESSAGE);
				break;
			case AMBIGUOUSTARGET:
				sb.append(AMBIGUOUSTARGETMESSAGE);
				break;
			case MALFORMEDTARGET:
				sb.append(MALFORMEDTARGETMESSAGE);
				break;
			default: 
				sb.append(UNKNOWNMESSAGE);
				break;
		}
		sb.append(": ");
		sb.append(mMessage);
		return sb.toString();
	}
	
	public int getType(){ return mType;}
	
}


