/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: DOMXPathResult.java,v $
 * Version:       $Name:  $ $Revision: 1.3 $
 * Last Modified: $Date: 2004/06/21 10:24:23 $
 *****************************************************************************/
package org.ten60.netkernel.xml.xda;

import org.w3c.dom.*;
import org.w3c.dom.traversal.*;
import org.apache.xpath.*;
import org.apache.xpath.objects.*;
import javax.xml.transform.TransformerException;

/**
 * Implementation of IXPathResult
 * @author  pjr
 */
public class DOMXPathResult implements IXPathResult
{
    private XObject mXO;
    private NodeList mNodeList;
    
    /** Creates a new instance of XPathResult */
    public DOMXPathResult(XObject aXO)
    {
        mXO=aXO;
        try
        {   mNodeList = mXO.nodelist();
        } catch (TransformerException e) {;}
    }
    /** Creates a new instance of XPathResult */
    public DOMXPathResult(NodeList aNodeList)
    {
        mXO=null;
		mNodeList=aNodeList;
    }    
    /** @return the value of result cast to a string
     * @throws XPathResultTransformException if result cannot be extracted
     */
    public String getStringValue()
    {
        String result;
		int type;
		if (mXO!=null)
		{	type = mXO.getType();
		}
		else
		{	type= XObject.CLASS_NODESET;
		}
		
        switch (type)
        {   case XObject.CLASS_BOOLEAN:
                try
                {   if(mXO.bool())
                    {
                        result="1";
                    }
                    else result="0";
                }
                catch(TransformerException te)
                {   result="0";
                }
                break;
            case XObject.CLASS_NUMBER:
            case XObject.CLASS_STRING:
                result = mXO.str();
                break;
            case XObject.CLASS_NODESET:
                result="";
                try
                {   NodeList nl = mNodeList;
                    Node n;
					//Think this is a bug!
                    //result=mXO.xstr().toString();
                    for (int i=0; i<nl.getLength(); i++)
                    {   n=nl.item(i);
                        result+=n.getNodeValue();
                    }
                } catch (Exception e) {;}
                break;
				
            case XObject.CLASS_NULL:
            case XObject.CLASS_RTREEFRAG:
            default:
                result=null;
                break;
        }
        return result;
    }
    
    /** @return the type of result. It will be one of the constants
     * defined by this interface
     */
    public int getType()
    {
        int result;
		int type;
		if (mXO!=null)
		{	type = mXO.getType();
		}
		else
		{	type= XObject.CLASS_NODESET;
		}
        switch (type)
        {   case XObject.CLASS_BOOLEAN:
                result = XPR_BOOLEAN;
                break;
            case XObject.CLASS_NODESET:
            {   result = XPR_NODESET;
                NodeList ns = mNodeList;
                if (ns.getLength()==1)
                {   Node n = ns.item(0);
                    if (n instanceof Element || n instanceof Document)
                    {   result=XPR_SINGLE_ELEMENT;
                    }
                }
                break;
            }
            case XObject.CLASS_NULL:
                result = XPR_NULL;
                break;
            case XObject.CLASS_NUMBER:
                result = XPR_NUMBER;
                break;
            case XObject.CLASS_RTREEFRAG:
                result = XPR_RTREEFRAG;
                break;
            case XObject.CLASS_STRING:
                result = XPR_STRING;
                break;
            default:
                result = XPR_UNKNOWN;
                break;
        }
        return result;
    }
   
	public NodeList getNodeList()
	{	return mNodeList;
	}
	
	public boolean isTrue() throws XPathLocationException
	{	try
		{	return mXO.bool();
		} catch ( javax.xml.transform.TransformerException e)
		{	throw new XPathLocationException(e.getMessageAndLocation(), XPathLocationException.MALFORMEDTARGET);
		}
	}
}
