/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: XAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.5 $
  Last Modified: $Date: 2004/09/07 14:21:42 $
 *****************************************************************************/
package org.ten60.netkernel.xml.xahelper;

import org.ten60.netkernel.xml.representation.IXAspect;
import org.ten60.netkernel.layer1.accessor.ActiveAccessorImpl;
import org.ten60.netkernel.layer1.meta.ActiveAccessorMeta;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.representation.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.container.*;
import com.ten60.netkernel.module.*;
import com.ten60.netkernel.scheduler.*;
import com.ten60.netkernel.util.*;

import java.io.*;
import java.util.*;
/**
 * An Highlevel accessor base class written to support migration
 * of an old codebase from NetKernel v1, tailored to XML
 * accessors but supports non-XML datatypes just as well.
 * @author  tab
 */
public abstract class XAccessor extends ActiveAccessorImpl
{
	public static final String OPERAND=XAHelper.OPERAND;
	public static final String OPERATOR=XAHelper.OPERATOR;	
	public static final String PARAMETER=XAHelper.PARAMETER;
	
	public static final int SUPPORTS_SOURCE_BY_DOM=0;
	public static final int SUPPORTS_SOURCE_BY_STREAM=1;
	
	private Map mArguments = new HashMap(10);
	private boolean mKeepDependencies = true;
	
	/** default cost */
	private static final int COST=8;

	public XAccessor()
	{	this(COST);
	}
	public XAccessor(int aCost)
	{	super(aCost, false);
	}
	
	protected void addDependency(IURRepresentation aDependency)
	{	getAAMeta().addDependency(aDependency);
	}

	public void requestAsync(URRequest aRequest)
	{	try
		{	XAHelper helper = new XAHelperImpl(aRequest,this,mArguments,mKeepDependencies);
			IURRepresentation proxy = source(helper);
			if (proxy==null)
			{	throw new NullPointerException("Null returned from XAccessor.source");
			}
			URResult result = new URResult(aRequest, proxy);
			getScheduler().receiveAsyncResult(result);
		}
		catch (Exception ex)
		{	NetKernelException e = new NetKernelException("Unhandled Exception","in "+getClass().getName(), aRequest.toString());
			e.addCause(ex);
			URResult result = new URResult(aRequest, NetKernelExceptionAspect.create(e));
			getScheduler().receiveAsyncException(result);
		}
	}
	
	protected ModuleDefinition getModule()
	{	return super.getModule();
	}
	
	protected Container getContainer()
	{	return super.getContainer();
	}
	
	protected Scheduler getScheduler()
	{	return super.getScheduler();
	}
	
	protected IURRepresentation getProxy(URIdentifier aURI, Class aAspectClass, URRequest aOriginalRequest) throws NetKernelException
	{	return super.getResource(aURI,aAspectClass,aOriginalRequest);
	}

	protected IURRepresentation transrepresent(URIdentifier aSourceURI, IURRepresentation aSourceProxy, Class aAspectClass, URRequest aOriginalRequest) throws NetKernelException
	{	return super.transrepresent(aSourceURI, aSourceProxy, aAspectClass, aOriginalRequest);
	}
	
	protected IURRepresentation fragment(IURRepresentation aSourceProxy, String aFragment, Class aAspectClass, URRequest aOriginalRequest) throws NetKernelException
	{	URIdentifier uri = URIdentifier.getUnique("literal:var").withFragment(aFragment);
		URRequest request = new URRequest(uri, null, aOriginalRequest.getSession(), getModule(), URRequest.RQT_FRAGMENT, aOriginalRequest.getCWU(), aOriginalRequest, aAspectClass);
		request.addArg(URRequest.URI_SYSTEM, aSourceProxy);
		URResult result = getScheduler().requestSynch(request);
		return result.getResource();
	}
	
	/** Subclass constructor should call this method to declare which arguments are valid on
	 * requests.
	 * @param aArgument the argument name
	 * @param isRequired true if an argument is required, false if optional
	 * @param acceptsFragment true if an argument can be passed as a URI with a fragment specifier
	 */
	protected void declareArgument(String aArgument, boolean isRequired, boolean acceptsFragment)
	{	XAArgumentDeclaration argument = new XAArgumentDeclaration( isRequired, acceptsFragment);
		mArguments.put(aArgument,argument);
	}
	/** Subclass constructor may call this method to declare the accessor as threadsafe 
	 */
	protected void declareThreadSafe()
	{	setThreadSafe(true);
	}
	/** Subclass constructor should call this method to declare that argument checking should be
	 * disabled so that anything can be passed in
	 */
	protected void declareDisableArgumentChecking()
	{	mArguments=null;
	}
	/** Subclass constructor may call this method to declare the accessor not to keep dependencies
	 */
	protected void declareForgetDependencies()
	{	mKeepDependencies=false;
	}
	/** This method must be implemented in subclasses to provide the source functionality
	 * @param aHelper the XAHelper with all necessary state
	 * @return and IURRepresentation of the result
	 * @exception Throwable thrown if it fails for any reason
	 */
	abstract protected IURRepresentation source(XAHelper aHelper) throws Exception;
	
}
