/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: DOMXDAParser.java,v $
  Version:       $Name:  $ $Revision: 1.6 $
  Last Modified: $Date: 2004/10/04 09:02:46 $
 *****************************************************************************/
package org.ten60.netkernel.xml.transrepresentation;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.util.XMLUtils;

import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.transrepresentation.SimpleTransreptorImpl;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.NetKernelException;
import org.ten60.netkernel.layer1.representation.*;

import org.w3c.dom.*;
import java.io.*;

/**
 * Parses a binary stream into a DOM
 * @author  tab
 */
public class DOMXDAParser extends SimpleTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( (aFrom.hasAspect(IAspectBinaryStream.class) || aFrom.hasAspect(IAspectReader.class)) && ( aTo.isAssignableFrom(DOMXDAAspect.class)) );
	}
	
	public IURRepresentation transrepresent(IURRepresentation aFrom) throws NetKernelException
	{	try
		{	Document d;
			if (aFrom.hasAspect(IAspectReader.class))
			{	Reader r = ((IAspectReader)aFrom.getAspect(IAspectReader.class)).getReader();
				ClassLoader cl = Thread.currentThread().getContextClassLoader();
				Thread.currentThread().setContextClassLoader(getClass().getClassLoader());
				d = XMLUtils.getInstance().parse(r);
				Thread.currentThread().setContextClassLoader(cl);
			}
			else if (aFrom.hasAspect(IAspectReadableBinaryStream.class))
			{	IAspectReadableBinaryStream rbs = (IAspectReadableBinaryStream)aFrom.getAspect(IAspectReadableBinaryStream.class);
				InputStream is = rbs.getInputStream();
				try
				{	ClassLoader cl = Thread.currentThread().getContextClassLoader();
					Thread.currentThread().setContextClassLoader(getClass().getClassLoader());
					d = XMLUtils.getInstance().parse(is);
					Thread.currentThread().setContextClassLoader(cl);
				}
				finally
				{	is.close(); 
				}
			}
			else
			{	IAspectBinaryStream input = (IAspectBinaryStream)aFrom.getAspect(IAspectBinaryStream.class);
				ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
				input.write(baos);
				ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
				d = XMLUtils.getInstance().parse(bais);
			}
			DOMXDA domXDA = new DOMXDA(d,false);
			DependencyMeta meta = new DependencyMeta(aFrom,64);
			MultiRepresentationImpl mri=new MultiRepresentationImpl(meta, 2);
			mri.addAspect(new DOMXDAAspect(domXDA));
			mri.addAspectsOf(aFrom);
			return mri;
		}
		catch (Exception e)
		{	NetKernelException e2 = new NetKernelException("Failed to parse xml");
			e2.addCause(e);
			throw e2;
		}
	}	
}