/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: XXX2XmlObject.java,v $
  Version:       $Name:  $ $Revision: 1.5 $
  Last Modified: $Date: 2005/04/26 18:53:52 $
 *****************************************************************************/
package org.ten60.netkernel.xml.transrepresentation;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.util.NetKernelException;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.xml.representation.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.urii.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.representation.*;
import org.jdom.*;
import org.jdom.input.*;
import org.jdom.adapters.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import org.apache.xmlbeans.*;
import org.jdom.*;

/**
 * Converts several XML object models to XmlObjectAspect
 * @author  pjr
 */
public class XXX2XmlObject extends NKFTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return (
			/*
			( 	aFrom.hasAspect(IXAspect.class)
				|| aFrom.hasAspect(IAspectDOM.class)
				|| aFrom.hasAspect(IAspectSAX.class)
				|| aFrom.hasAspect(IAspectReadableBinaryStream.class)
				|| aFrom.hasAspect(IAspectBinaryStream.class)
				|| aFrom.hasAspect(IAspectJDOM.class)
			)
			&&
			//We now accept all comers and sort out the aspects internally - this should become the standard pattern
			*/
			 ( aTo.isAssignableFrom(IAspectXmlObject.class))
		);
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IURRepresentation old=context.getThisRequest().getArgumentValue(INKFRequestReadOnly.URI_SYSTEM);
		XmlObject result=null;
		if(old.hasAspect(IXAspect.class) || old.hasAspect(IAspectDOM.class))
		{	IAspectDOM da=(IAspectDOM)old.getAspect(IAspectDOM.class);
			result=XmlObject.Factory.parse(da.getReadOnlyDocument());
		}
		else if(old.hasAspect(IAspectSAX.class))
		{	IAspectSAX sa=(IAspectSAX)old.getAspect(IAspectSAX.class);
			XMLReader xr=XMLReaderFactory.createXMLReader();
			XmlSaxHandler xsa=XmlObject.Factory.newXmlSaxHandler();
			xr.setContentHandler(xsa.getContentHandler());
			xr.setProperty("http://xml.org/sax/properties/lexical-handler", xsa.getLexicalHandler());
			sa.handleContent(xr, null);
			result=xsa.getObject();
		}
		else if(old.hasAspect(IAspectReadableBinaryStream.class))
		{	IAspectReadableBinaryStream rbsa=(IAspectReadableBinaryStream)old.getAspect(IAspectReadableBinaryStream.class);
			result=XmlObject.Factory.parse(rbsa.getInputStream());
		}
		else if(old.hasAspect(IAspectBinaryStream.class))
		{	IAspectBinaryStream bsa=(IAspectBinaryStream)old.getAspect(IAspectBinaryStream.class);
			PipedInputStream pis=new PipedInputStream();
			PipedOutputStream pos=new PipedOutputStream(pis);
			PipeWriter pw=new PipeWriter(bsa, new BufferedOutputStream(pos));
			pw.start();
			result=XmlObject.Factory.parse(new BufferedInputStream(pis));
		}
		else if(old.hasAspect(IAspectJDOM.class))
		{	IAspectJDOM jda=(IAspectJDOM)old.getAspect(IAspectJDOM.class);
			IAspectSAX sa=(IAspectSAX)context.transrept(jda, IAspectSAX.class);
			IAspectXmlObject xoa=(IAspectXmlObject)context.transrept(sa, IAspectXmlObject.class);
			result=xoa.getImmutableXmlObject();
			
		}
		else if(old.hasAspect(IAspectNVP.class))
		{	IAspectNVP nvpa=(IAspectNVP)old.getAspect(IAspectNVP.class);
			IXAspect xa=(IXAspect)context.transrept(nvpa, IXAspect.class);
			IAspectXmlObject xoa=(IAspectXmlObject)context.transrept(xa, IAspectXmlObject.class);
			result=xoa.getImmutableXmlObject();
			
		}
		else //Fallback is to try getting a SAX stream...
		{	try
			{	IURAspect a=(IURAspect)old.getAspects().toArray()[1];
				IAspectSAX sa=(IAspectSAX)context.transrept(a, IAspectSAX.class);
				IAspectXmlObject xoa=(IAspectXmlObject)context.transrept(sa, IAspectXmlObject.class);
				result=xoa.getImmutableXmlObject();
			}
			catch(Exception e)
			{	IURAspect as=(IURAspect)old.getAspects().toArray()[1];
				NetKernelException nke= new NetKernelException("Unmappable Transreption Request", "Could not find transreptor from "+as.getClass().getName()+"to XmlObject", null);
				nke.addCause(e);
				throw nke;
			}
		}
		XmlObjectAspect xoa=new XmlObjectAspect(result);
		INKFResponse resp=context.createResponseFrom(old);
		resp.addAspect(xoa);
		if(old.getMeta().getMimeType().equals("content/unknown"))
		{	resp.setMimeType("text/xml");
		}
		context.setResponse(resp);
	}
	
	/* A thread to write a binary stream aspect to an outputstream*/
	class PipeWriter extends Thread
	{	
		private IAspectBinaryStream mBinaryStream;
		private OutputStream mOutputStream;
		
		PipeWriter(IAspectBinaryStream aBinaryStream, OutputStream aOutputStream)
		{	mBinaryStream=aBinaryStream;
			mOutputStream=aOutputStream;
		}
		
		public void run()
		{	try
			{	mBinaryStream.write(mOutputStream);	
			}
			catch(IOException e)
			{	try
				{	mOutputStream.close();				
				}
				catch(IOException e2)
				{	/*Nothing more we can do*/
				}
			}
		}
	}
	
}