/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class MultiMap {
    private Map mMap;
    private int mMultiExpectancy;
    private int mSize;

    public MultiMap(int aInitialCapacity, int aMultiExpectancy) {
        this.mMap = new HashMap(aInitialCapacity);
        this.mMultiExpectancy = aMultiExpectancy;
        this.mSize = 0;
    }

    public void put(Object aKey, Object aValue) {
        Object lookup = this.mMap.get(aKey);
        if (lookup == null) {
            this.mMap.put(aKey, aValue);
        } else if (lookup instanceof List) {
            List pendingList = (List)lookup;
            pendingList.add(aValue);
        } else {
            ArrayList<Object> pendingList = new ArrayList<Object>(this.mMultiExpectancy);
            pendingList.add(lookup);
            pendingList.add(aValue);
            this.mMap.put(aKey, pendingList);
        }
        ++this.mSize;
    }

    public List get(Object aKey) {
        Object lookup = this.mMap.get(aKey);
        List<Object> result = lookup == null ? Collections.EMPTY_LIST : (lookup instanceof List ? (List)lookup : Collections.singletonList(lookup));
        return result;
    }

    public List remove(Object aKey) {
        List list = (List)this.mMap.remove(aKey);
        this.mSize -= list.size();
        return list;
    }

    public boolean remove(Object aKey, Object aValue) {
        boolean removed = false;
        Object lookup = this.mMap.get(aKey);
        if (lookup instanceof List) {
            List l = (List)lookup;
            removed = l.remove(aValue);
        } else if (lookup == aValue) {
            this.mMap.remove(aKey);
            removed = true;
        }
        if (removed) {
            --this.mSize;
        }
        return removed;
    }

    public int size() {
        return this.mSize;
    }

    public void clear() {
        this.mSize = 0;
        this.mMap.clear();
    }

    public Iterator valueIterator() {
        return new MultiIterator();
    }

    public Iterator keyIterator() {
        return this.mMap.keySet().iterator();
    }

    private class MultiIterator
    implements Iterator {
        private Iterator mMapIterator;
        private Iterator mListIterator;
        private Object mNext;

        public MultiIterator() {
            this.mMapIterator = MultiMap.this.mMap.values().iterator();
            this.findNext();
        }

        public boolean hasNext() {
            return this.mNext != null;
        }

        public Object next() {
            Object result = this.mNext;
            this.findNext();
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            this.mNext = null;
            while (this.mNext == null) {
                if (this.mListIterator == null) {
                    if (!this.mMapIterator.hasNext()) break;
                    Object o = this.mMapIterator.next();
                    if (o instanceof List) {
                        this.mListIterator = ((List)o).iterator();
                        continue;
                    }
                    this.mNext = o;
                    continue;
                }
                if (this.mListIterator.hasNext()) {
                    this.mNext = this.mListIterator.next();
                    continue;
                }
                this.mListIterator = null;
            }
        }
    }
}

