/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.urrequest;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.urrequest.IRequestorContext;
import com.ten60.netkernel.urrequest.IRequestorSession;
import com.ten60.netkernel.urrequest.IURRequestor;
import com.ten60.netkernel.util.CheapMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class URRequest {
    private URIdentifier mURI;
    private URIdentifier mNonRewrittenURI;
    private URIdentifier mCWU;
    private IURRequestor mRequestor;
    private IRequestorSession mSession;
    private IRequestorContext mContext;
    private URRequest mParent;
    private int mType;
    private Class mAspectClass;
    private long mTime;
    private Map mArgs;
    private List mSuper;
    public static final int RQT_SOURCE = 1;
    public static final int RQT_SINK = 2;
    public static final int RQT_EXISTS = 4;
    public static final int RQT_DELETE = 8;
    public static final int RQT_NEW = 16;
    public static final int RQT_TRANSREPRESENT = 32;
    public static final int RQT_FRAGMENT = 64;
    public static final int RQT_ALL = 127;
    public static final URIdentifier URI_SYSTEM = new URIdentifier("literal:uri_system");

    public static String typeToString(int aType) {
        String result;
        switch (aType) {
            case 1: {
                result = "SOURCE";
                break;
            }
            case 2: {
                result = "SINK";
                break;
            }
            case 4: {
                result = "EXISTS";
                break;
            }
            case 8: {
                result = "DELETE";
                break;
            }
            case 16: {
                result = "NEW";
                break;
            }
            case 32: {
                result = "TRANSREPRESENT";
                break;
            }
            case 64: {
                result = "FRAGMENT";
                break;
            }
            default: {
                result = "??";
            }
        }
        return result;
    }

    public URRequest(URIdentifier aURI, IURRequestor aRequestor, IRequestorSession aSession, IRequestorContext aContext, int aType, URIdentifier aCWU, URRequest aParent, Class aAspectClass) {
        this.mURI = aURI;
        this.mNonRewrittenURI = aURI;
        this.mRequestor = aRequestor;
        this.mContext = aContext;
        this.mSession = aSession;
        this.mType = aType;
        this.mAspectClass = aAspectClass;
        this.mCWU = aCWU;
        this.mParent = aParent;
        if (this.mParent != null) {
            this.mSuper = this.mParent.mSuper;
        }
        this.mTime = System.currentTimeMillis();
    }

    public URIdentifier getURI() {
        return this.mURI;
    }

    public URIdentifier getNonRewrittenURI() {
        return this.mNonRewrittenURI;
    }

    public URIdentifier getCWU() {
        return this.mCWU;
    }

    public IURRequestor getRequestor() {
        return this.mRequestor;
    }

    public IRequestorSession getSession() {
        return this.mSession;
    }

    public IRequestorContext getContext() {
        return this.mContext;
    }

    public int getType() {
        return this.mType;
    }

    public long getTime() {
        return this.mTime;
    }

    public URRequest getParent() {
        return this.mParent;
    }

    public Class getAspectClass() {
        return this.mAspectClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append('[');
        sb.append(URRequest.typeToString(this.mType));
        sb.append(' ');
        sb.append(this.mURI.toString());
        sb.append(" in ");
        sb.append(this.mContext.toString());
        if (this.mAspectClass != null) {
            sb.append(" as ");
            sb.append(this.mAspectClass.getName());
        }
        sb.append(']');
        return new String(sb);
    }

    public URRequest rewrite(URIdentifier aRewritten) {
        URRequest result = new URRequest(aRewritten, this.mRequestor, this.mSession, this.mContext, this.mType, this.mCWU, this.mParent, this.mAspectClass);
        result.mArgs = this.mArgs;
        result.mSuper = this.mSuper;
        result.mNonRewrittenURI = this.mURI;
        return result;
    }

    public int argSize() {
        int result = this.mArgs != null ? this.mArgs.size() : 0;
        return result;
    }

    public IURRepresentation getArg(URIdentifier aURI) {
        IURRepresentation result = null;
        if (this.mArgs != null) {
            result = (IURRepresentation)this.mArgs.get(aURI);
        }
        return result;
    }

    public Collection getArgs() {
        Collection<Object> result = this.mArgs != null ? this.mArgs.keySet() : Collections.EMPTY_LIST;
        return result;
    }

    public void addArg(URIdentifier aURI, IURRepresentation aArg) {
        if (this.mArgs == null) {
            this.mArgs = new CheapMap(4);
        }
        this.mArgs.put(aURI, aArg);
    }

    public List getSuperStack() {
        List result = this.mSuper;
        if (this.mSuper == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public List getSuperStackClone() {
        ArrayList result;
        if (this.mSuper == null) {
            result = new ArrayList(4);
        } else {
            result = new ArrayList(4 + this.mSuper.size());
            result.addAll(this.mSuper);
        }
        return result;
    }

    public boolean isSubRequest(URRequest aOther) {
        boolean result = false;
        for (URRequest r = this; r != null; r = r.getParent()) {
            if (r != aOther) continue;
            result = true;
            break;
        }
        return result;
    }

    public void setCurrentContext(IRequestorContext aContext, List aSuper) {
        this.mContext = aContext;
        this.mSuper = aSuper;
    }

    public void setRequestor(IURRequestor aRequestor) {
        this.mRequestor = aRequestor;
    }

    public void setSession(IRequestorSession aSession) {
        this.mSession = aSession;
    }

    public boolean equals(Object aOther) {
        boolean result = false;
        if (aOther instanceof URRequest) {
            URRequest other = (URRequest)aOther;
            result = this.mURI.equals(other.mURI) && this.mType == other.mType && this.mContext == other.mContext && this.mSuper == other.mSuper;
        }
        return result;
    }

    public int hashCode() {
        return this.mURI.hashCode();
    }
}

