/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.urii.aspect;

import com.ten60.netkernel.urii.IURMeta;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import com.ten60.netkernel.urii.aspect.IAspectNetKernelException;
import com.ten60.netkernel.urii.meta.MetaImpl;
import com.ten60.netkernel.urii.representation.MonoRepresentationImpl;
import com.ten60.netkernel.util.IXMLException;
import com.ten60.netkernel.util.NetKernelError;
import com.ten60.netkernel.util.NetKernelException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class NetKernelExceptionAspect
implements IAspectNetKernelException,
IAspectBinaryStream {
    private static IURMeta sMeta = new MetaImpl("application/vnd.netkernel-exception", 0L, 0);
    private NetKernelException mException;
    private NetKernelError mError;

    NetKernelExceptionAspect(NetKernelException aException) {
        this.mException = aException;
    }

    NetKernelExceptionAspect(NetKernelError aError) {
        this.mError = aError;
    }

    public NetKernelException getException() {
        if (this.mException != null) {
            return this.mException;
        }
        NetKernelError e = new NetKernelError("Assumed Exception not Error");
        e.addCause(this.mError);
        throw e;
    }

    public NetKernelError getError() {
        return this.mError;
    }

    public IXMLException getXMLException() {
        Throwable result = this.mError != null ? this.mError : this.mException;
        return result;
    }

    public void write(OutputStream aStream) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(aStream, "UTF-8");
        if (this.mException != null) {
            this.mException.appendXML(osw);
        } else {
            this.mError.appendXML(osw);
        }
        osw.flush();
    }

    public static IURRepresentation create(NetKernelException aException) {
        return new MonoRepresentationImpl(sMeta, new NetKernelExceptionAspect(aException));
    }

    public static IURRepresentation create(NetKernelError aError) {
        return new MonoRepresentationImpl(sMeta, new NetKernelExceptionAspect(aError));
    }

    public String getEncoding() {
        return "UTF-8";
    }
}

