/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.module;

import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.module.rewrite.RegexRewriterRule;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class URIMapping {
    public static final int TYPE_THIS = 1;
    public static final int TYPE_SUPER = 2;
    private Matcher mMatcher;
    private Matcher[] mMatchers;
    private String mURAClass;
    private ModuleDefinition mImportModule;
    private int mType = 0;
    private RegexRewriterRule mRewrite;
    private int mSkipCount = 0;

    public URIMapping(String aMatch, int aType) {
        this.mMatcher = URIMapping.createMatcher(aMatch);
        this.mType = aType;
    }

    public URIMapping(List aMatches, ModuleDefinition aImport) {
        this.mMatchers = new Matcher[aMatches.size()];
        for (int i = 0; i < aMatches.size(); ++i) {
            String match = (String)aMatches.get(i);
            this.mMatchers[i] = URIMapping.createMatcher(match);
        }
        this.mImportModule = aImport;
    }

    public URIMapping(String aMatch, String aURAClass) {
        this.mMatcher = URIMapping.createMatcher(aMatch);
        this.mURAClass = aURAClass;
    }

    public URIMapping(RegexRewriterRule aRewrite) {
        this.mRewrite = aRewrite;
    }

    public URIMapping(int aSkipCount, String aMatch) {
        this.mMatcher = URIMapping.createMatcher(aMatch);
        this.mSkipCount = aSkipCount;
    }

    private static Matcher createMatcher(String aRegex) {
        return Pattern.compile(aRegex).matcher("");
    }

    public String getURAClass() {
        return this.mURAClass;
    }

    public RegexRewriterRule getRewriterRule() {
        return this.mRewrite;
    }

    public ModuleDefinition getImportModule() {
        return this.mImportModule;
    }

    public int getType() {
        return this.mType;
    }

    public int getSkipCount() {
        return this.mSkipCount;
    }

    public synchronized boolean matches(CharSequence aString) {
        boolean result = false;
        if (this.mMatcher != null) {
            this.mMatcher.reset(aString);
            result = this.mMatcher.matches();
        } else if (this.mMatchers != null) {
            for (int i = 0; i < this.mMatchers.length; ++i) {
                Matcher matcher = this.mMatchers[i];
                matcher.reset(aString);
                if (!matcher.matches()) continue;
                result = true;
                break;
            }
        } else if (this.mRewrite != null) {
            result = this.mRewrite.matches(aString);
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        if (this.mMatcher != null) {
            sb.append(this.mMatcher.pattern().pattern());
            sb.append(' ');
        } else {
            sb.append("(many) ");
        }
        if (this.mType == 2) {
            sb.append("SUPER");
        } else if (this.mType == 1) {
            sb.append("THIS");
        } else if (this.mURAClass != null) {
            sb.append(" to accessor ");
            sb.append(this.mURAClass);
        } else if (this.mImportModule != null) {
            sb.append("to import ");
            sb.append(this.mImportModule.getURI().toString());
        } else if (this.mRewrite != null) {
            sb.append("rewrite");
        } else if (this.mSkipCount > 0) {
            sb.append(" skipping next ");
            sb.append(this.mSkipCount);
            sb.append(" mappings");
        }
        return new String(sb);
    }
}

