/*
 * NKURIResolver.java
 *
 * Created on 03 November 2003, 14:36
 */

package org.ten60.netkernel.xforms.connector;

import org.ten60.netkernel.xforms.accessor.XFormsAccessor;
import org.chiba.xml.xforms.connector.*;
import org.ten60.netkernel.xml.xahelper.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import java.net.*;
import java.io.*;
/**
 *
 * @author  pjr
 */
public class NKURIResolver implements URIResolver
{
	private String mURI;
	
	/** Creates a new instance of NKURIResolver */
	public NKURIResolver()
	{
	}
	
	public Object resolve() throws org.chiba.xml.xforms.exception.XFormsLinkException
	{	try {
            XAHelper aHelper=XFormsAccessor.getHelper();
			IURRepresentation res=aHelper.getResource(java.net.URI.create(mURI), IAspectBinaryStream.class);
			IAspectBinaryStream bsA=(IAspectBinaryStream)res.getAspect(IAspectBinaryStream.class);
			ByteArrayOutputStream baos=new ByteArrayOutputStream();
			bsA.write(baos);
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            Document document = factory.newDocumentBuilder().parse(new ByteArrayInputStream(baos.toByteArray()));
            return document;
        }
        catch (Exception e) {
            throw new org.chiba.xml.xforms.exception.XFormsLinkException(mURI, null,null);
        }
    }
	
	public void setURI(String uri)
	{	mURI=uri;
	}
	
	public String getURI()
	{	return mURI;
	}
	
}
