
package org.ten60.netkernel.xforms.adaptor.ura;

import org.chiba.xml.xforms.ChibaContext;
import org.chiba.xml.xforms.config.Config;
import org.chiba.xml.xforms.ui.BoundElement;

import java.util.Map;
import java.util.HashMap;

/**
 * stores URA application specific properties.
 * Ideally this would be a common Chiba base class that did not use
 * the URAAdapter/ServletAdapter directly, but an interface, as it is
 * a direct copy of WebContext with the ServletAdapter specifics changed
 * to URAAdapter, but, as always there is no time :-(
 *
 * @author robert leftwich
 * @version $Id: URAContext.java,v 1.1 2004/03/05 17:45:41 joernt Exp $
 */
public class URAContext implements ChibaContext {

    public static final String REQUEST_PARAMETERS = "chiba.parameters";

    private Map properties=null;
    private URAAdaptor uraAdaptor = null;

    public URAContext(URAAdaptor aAdaptor) {
        this.uraAdaptor = aAdaptor;
        this.properties = new HashMap();
    }

    /**
     * stores a Servlet specific property in the context.
     * @param key the property key
     * @param value the property value
     */
    public void setProperty(String key, Object value) {
        this.properties.put(key,value);
    }

    /**
     * reads a Servlet specific property from the context.
     * @param key the key for the wanted object
     * @return returns object from context
     */
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    /** Return the properties Map
     * @return All context properties in a Map object
     */
    public Map getProperties() {
        return this.properties;
    }

    /**
     * Returns an external name for a given bound control. This can be either a form control or
     * another bound element like label, alert, filename, mediatype....
     *
     * Note: this solution is a bit of a hack. the method would feel better in URAAdaptor itself but
     * this would make necessary another interface to access this method from inside the processor.
     *
     * @param control the bound control.
     * @return an external name for a given bound control.
     */
    public String getExternalName(BoundElement control) {
        String name;

        if (control instanceof org.chiba.xml.xforms.ui.Trigger) {
            name = uraAdaptor.getUniqueParameterName(uraAdaptor.getTriggerPrefix());
        } else {
            name = uraAdaptor.getUniqueParameterName(uraAdaptor.getDataPrefix());
        }

        ((Map)getProperty(URAContext.REQUEST_PARAMETERS)).put(name,control.getId());

        return name;
    }

    public URAAdaptor getURAAdaptor() {
        return uraAdaptor;
    }



}
//end of class

