/*
 * URAAdaptor.java
 *
 * Created on 10 March 2004, 11:46
 */

package org.ten60.netkernel.xforms.adaptor.ura;

import org.chiba.xml.xforms.config.Config;
import org.chiba.xml.xforms.*;
import org.chiba.xml.xforms.ui.*;
import org.chiba.xml.xforms.events.*;

import java.util.*;

import org.w3c.dom.events.*;
import org.chiba.xml.xforms.exception.*;

/**
 *
 * @author  pjr and rtl
 */
public class URAAdaptor implements org.w3c.dom.events.EventListener
{	
	private static final String DATA_PREFIX_PROPERTY = "chiba.web.dataPrefix";
    private static final String TRIGGER_PREFIX_PROPERTY = "chiba.web.triggerPrefix";
    private static final String SELECTOR_PREFIX_PROPERTY = "chiba.web.selectorPrefix";
    private static final String DATA_PREFIX_DEFAULT = "d_";
    private static final String TRIGGER_PREFIX_DEFAULT = "t_";
    private static final String SELECTOR_PREFIX_DEFAULT = "s_";

    private ChibaBean chibaBean=null;
	private Map parameterNames = null;

	private String dataPrefix = null;
    private String triggerPrefix = null;
    private String selectorPrefix = null;

    private URAContext mURAContext=null;
	
	/** Creates a new instance of URAAdaptor */
	public URAAdaptor()
	{	parameterNames=new HashMap();
        mURAContext = new URAContext(this);
        mURAContext.setProperty(URAContext.REQUEST_PARAMETERS,this.parameterNames);
	}
	
	public void setChibaBean(ChibaBean aChibaBean)
	{	
        chibaBean=aChibaBean;
        chibaBean.setContext(mURAContext);
        try
		{
			addSubmitListener(chibaBean);
		}
		catch(XFormsException e)
		{	/*Do nothing*/
		}
		
	}

    /**
     * Instructs the application environment to forward the given response.
     *
     * @param response a map containing at least a response stream and optional
     *                 header information.
     */
    public void forward(Map response) {
        this.chibaBean.getContext().setProperty(ChibaContext.SUBMISSION_RESPONSE, response);
    }

    /**
     * returns a Map object containing a forward uri. this is used by the 'load' action
     *
     * @return a Map object containing a forward uri
     */
    public Map getForwardMap() {
        return (Map) chibaBean.getContext().getProperty(ChibaContext.SUBMISSION_RESPONSE);
    }


	public boolean hasForward()
	{	return getForwardMap() != null;
	}

    /**
     * Instructs the application environment to setRedirect to the given URI.
     *
     * @param uri an absolute URI.
     */
    public void setRedirect(String uri) {
        chibaBean.getContext().setProperty(ChibaContext.REDIRECT_URI, uri);
    }

    /**
     * returns the redirect Uri
     *
     * @return the redirect Uri
     */
    public String getRedirectUri() {
        return (String) chibaBean.getContext().getProperty(ChibaContext.REDIRECT_URI);
    }


	public boolean hasRedirect()
	{	return getRedirectUri()!=null;
	}
	
	/*Handle a Map of Name -> String[] pairs*/
	public void handleRequest(Map aRequest) throws Throwable
	{	String trigger = null;
        List models = new ArrayList();

        
		// iterate request parameters
		Iterator it=aRequest.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();

            // [1] handle data
            if (name.startsWith(getDataPrefix())) {
                String id = (String) this.parameterNames.get(name);
                String[] values = (String []) aRequest.get(name);

                // assemble new control value
                String newValue = null;
                if (values.length > 1) {
                    StringBuffer buffer = new StringBuffer(values[0]);
                    for (int i = 1; i < values.length; i++) {
                        buffer.append(" ").append(values[i]);
                    }

                    newValue = buffer.toString().trim();
                }
                else {
                    newValue = values[0];
                }

				chibaBean.updateControlValue(id,newValue);
				/*
                // check old control value
                AbstractFormControl control = (AbstractFormControl) this.chibaBean.getContainer().lookup(id);
				if(control!=null)
				{	String oldValue = control.getValue();
					if (newValue.equals(oldValue)) {
						// NOP

					}
					else {
						
						control.setValue(newValue);
						String modelId = control.getModel().getId();
						if (!models.contains(modelId)) {
							models.add(modelId);
						}
						 
						
					}
				}
				 */
				
            }

            // [2] handle trigger
            if (trigger == null && name.startsWith(getTriggerPrefix())) {
                String parameter = name;
                int x = parameter.lastIndexOf(".x");
                int y = parameter.lastIndexOf(".y");

                if (x > -1) {
                    parameter = parameter.substring(0, x);
                }
                if (y > -1) {
                    parameter = parameter.substring(0, y);
                }

                // keep trigger id
                trigger = (String) this.parameterNames.get(parameter);
            }

            // [3] handle selector
            if (name.startsWith(getSelectorPrefix())) {
                String id = name.substring(getSelectorPrefix().length());
				String[] values = (String []) aRequest.get(name);
				int index = Integer.parseInt(values[0]);
                Repeat repeat = (Repeat) this.chibaBean.getContainer().lookup(id);

                repeat.setIndex(index);
            }
        }

        // update models
		/*
        for (int index = 0; index < models.size(); index++) {
            String modelId = (String) models.get(index);
            this.chibaBean.dispatch(modelId, EventFactory.RECALCULATE);
            this.chibaBean.dispatch(modelId, EventFactory.REVALIDATE);
            this.chibaBean.dispatch(modelId, EventFactory.REFRESH);
        }
		*/
		
        // finally activate trigger if any
        if (trigger != null) {
            this.chibaBean.dispatch(trigger, EventFactory.DOM_ACTIVATE);
        }
		
		
	}
	
	
	public String getDataPrefix () {
        if (this.dataPrefix == null) {
            try {
                this.dataPrefix = Config.getInstance().getProperty(DATA_PREFIX_PROPERTY, DATA_PREFIX_DEFAULT);
            }
            catch (Exception e) {
                this.dataPrefix = DATA_PREFIX_DEFAULT;
            }
        }

        return this.dataPrefix;
    }

    public String getTriggerPrefix () {
        if (this.triggerPrefix == null) {
            try {
                this.triggerPrefix = Config.getInstance().getProperty(TRIGGER_PREFIX_PROPERTY, TRIGGER_PREFIX_DEFAULT);
            }
            catch (Exception e) {
                this.triggerPrefix = TRIGGER_PREFIX_DEFAULT;
            }
        }

        return this.triggerPrefix;
    }

    public String getSelectorPrefix () {
        if (this.selectorPrefix == null) {
            try {
                this.selectorPrefix = Config.getInstance().getProperty(SELECTOR_PREFIX_PROPERTY, SELECTOR_PREFIX_DEFAULT);
            }
            catch (Exception e) {
                this.selectorPrefix = SELECTOR_PREFIX_DEFAULT;
            }
        }

        return this.selectorPrefix;
    }

	
	// helper methods

    public String getUniqueParameterName (String prefix) {
        String id = prefix + Integer.toHexString((int) (Math.random() * 10000));
        while (this.parameterNames.get(id) != null) {
            id = prefix + Integer.toHexString((int) (Math.random() * 10000));
        }

        return id;
    }
	
	//this is a quick hack to provide phase information e.g. signal that you're currently in submit-phase.
	//this is convenient to steer the rendering of validation error messages
	public void addSubmitListener(ChibaBean chibaBean)
		throws XFormsException {
		EventTarget eventTarget =
			(EventTarget) chibaBean.getXMLContainer().getDocumentElement();
		eventTarget.addEventListener(EventFactory.SUBMIT, this, true);
	}
	
	/**
	 *  This method is called whenever an event occurs of the type for which
	 * the <code> EventListener</code> interface was registered.
	 * @param evt The <code>Event</code> contains contextual information
	 *   about the event. It also contains the <code>stopPropagation</code>
	 *   and <code>preventDefault</code> methods which are used in
	 *   determining the event's flow and default action.
	 */
	public void handleEvent(Event evt) {
		if (evt instanceof XFormsEvent
			&& evt.getType().equals(EventFactory.SUBMIT)) {
			System.err.println("Entering submit phase");

		}
	}
	
}
