/*
 *
 *    Artistic License
 *
 *    Preamble
 *
 *    The intent of this document is to state the conditions under which a Package may be copied, such that
 *    the Copyright Holder maintains some semblance of artistic control over the development of the
 *    package, while giving the users of the package the right to use and distribute the Package in a
 *    more-or-less customary fashion, plus the right to make reasonable modifications.
 *
 *    Definitions:
 *
 *    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives
 *    of that collection of files created through textual modification.
 *
 *    "Standard Version" refers to such a Package if it has not been modified, or has been modified
 *    in accordance with the wishes of the Copyright Holder.
 *
 *    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
 *
 *    "You" is you, if you're thinking about copying or distributing this Package.
 *
 *    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication
 *    charges, time of people involved, and so on. (You will not be required to justify it to the
 *    Copyright Holder, but only to the computing community at large as a market that must bear the
 *    fee.)
 *
 *    "Freely Available" means that no fee is charged for the item itself, though there may be fees
 *    involved in handling the item. It also means that recipients of the item may redistribute it under
 *    the same conditions they received it.
 *
 *    1. You may make and give away verbatim copies of the source form of the Standard Version of this
 *    Package without restriction, provided that you duplicate all of the original copyright notices and
 *    associated disclaimers.
 *
 *    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain
 *    or from the Copyright Holder. A Package modified in such a way shall still be considered the
 *    Standard Version.
 *
 *    3. You may otherwise modify your copy of this Package in any way, provided that you insert a
 *    prominent notice in each changed file stating how and when you changed that file, and provided that
 *    you do at least ONE of the following:
 *
 *        a) place your modifications in the Public Domain or otherwise make them Freely
 *        Available, such as by posting said modifications to Usenet or an equivalent medium, or
 *        placing the modifications on a major archive site such as ftp.uu.net, or by allowing the
 *        Copyright Holder to include your modifications in the Standard Version of the Package.
 *
 *        b) use the modified Package only within your corporation or organization.
 *
 *        c) rename any non-standard executables so the names do not conflict with standard
 *        executables, which must also be provided, and provide a separate manual page for each
 *        non-standard executable that clearly documents how it differs from the Standard
 *        Version.
 *
 *        d) make other distribution arrangements with the Copyright Holder.
 *
 *    4. You may distribute the programs of this Package in object code or executable form, provided that
 *    you do at least ONE of the following:
 *
 *        a) distribute a Standard Version of the executables and library files, together with
 *        instructions (in the manual page or equivalent) on where to get the Standard Version.
 *
 *        b) accompany the distribution with the machine-readable source of the Package with
 *        your modifications.
 *
 *        c) accompany any non-standard executables with their corresponding Standard Version
 *        executables, giving the non-standard executables non-standard names, and clearly
 *        documenting the differences in manual pages (or equivalent), together with instructions
 *        on where to get the Standard Version.
 *
 *        d) make other distribution arrangements with the Copyright Holder.
 *
 *    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge
 *    any fee you choose for support of this Package. You may not charge a fee for this Package itself.
 *    However, you may distribute this Package in aggregate with other (possibly commercial) programs as
 *    part of a larger (possibly commercial) software distribution provided that you do not advertise this
 *    Package as a product of your own.
 *
 *    6. The scripts and library files supplied as input to or produced as output from the programs of this
 *    Package do not automatically fall under the copyright of this Package, but belong to whomever
 *    generated them, and may be sold commercially, and may be aggregated with this Package.
 *
 *    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of
 *    this Package.
 *
 *    8. The name of the Copyright Holder may not be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 *    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 *    MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */
package org.chiba.xml.xforms.xpath;

import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.JXPathContext;
import org.chiba.xml.xforms.Container;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.connector.ModelItemCalculator;
import org.chiba.xml.xforms.connector.ModelItemValidator;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import java.util.Map;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

/**
 * Provides chiba extension functions. These functions are implemented
 * and tested for use with JXPath.
 *
 * @author Ulrich Nicolas Liss&eacute;
 * @author Terence Jacyno
 * @version $Id: ChibaExtensionFunctions.java,v 1.8 2004/02/27 01:21:53 joernt Exp $
 */
public class ChibaExtensionFunctions {

    /**
     * Prevents outside instantiation
     */
    private ChibaExtensionFunctions () {
        // NOP
    }

    /**
     * Returns the calculation result of an external calculator.
     *
     * @param expressionContext the expression context.
     * @param uri the calculator uri.
     * @return the calculation result of an external calculator.
     * @throws XFormsException if any error occurred during the calculation.
     */
    public static String calculate (ExpressionContext expressionContext, String uri) throws XFormsException {
        JXPathContext context = expressionContext.getJXPathContext();

        while (context != null) {
            Object contextBean = context.getContextBean();

            if (contextBean instanceof XFormsElement) {
                // get hook from jxpath to chiba
                XFormsElement xFormsElement = (XFormsElement) contextBean;
                Container container = xFormsElement.getModel().getContainer();
                Element contextElement = xFormsElement.getElement();
                Node instanceNode = (Node) expressionContext.getContextNodePointer().getNode();

                ModelItemCalculator calculator = container.getConnectorFactory().createModelItemCalculator(uri, contextElement);
                return calculator.calculate(instanceNode);
            }

            context = context.getParentContext();
        }

        throw new XFormsException("invalid expression context when evaluating calculate('" + uri + "')");
    }

    /**
     * Returns the validation result of an external validator.
     *
     * @param expressionContext the expression context.
     * @param uri the calculator uri.
     * @return the validation result of an external validator.
     * @throws XFormsException if any error occurred during the validation.
     */
    public static boolean validate (ExpressionContext expressionContext, String uri) throws XFormsException {
        JXPathContext context = expressionContext.getJXPathContext();

        while (context != null) {
            Object contextBean = context.getContextBean();

            if (contextBean instanceof XFormsElement) {
                // get hook from jxpath to chiba
                XFormsElement xFormsElement = (XFormsElement) contextBean;
                Container container = xFormsElement.getModel().getContainer();
                Element contextElement = xFormsElement.getElement();
                Node instanceNode = (Node) expressionContext.getContextNodePointer().getNode();

                ModelItemValidator validator = container.getConnectorFactory().createModelItemValidator(uri, contextElement);
                return validator.validate(instanceNode);
            }

            context = context.getParentContext();
        }

        throw new XFormsException("invalid expression context when evaluating validate('" + uri + "')");
    }


    private static Map m_regexPatterns = new HashMap();
    /**
     * <code>Regexp</code> is a utility class providing the functionality present
     * within the EXSLT Regular Expressions definition (<a
     * href="http://www.exslt.org/regexp"
     * target="_top">http://www.exslt.org/regexp</a>).
     * <br><br>
     * This is a contribution from Terence Jacyno.
     */
    public static boolean test(String input, String regex, String flags) {
        String regexKey = ((flags == null) || (flags.indexOf('i') == -1))
                        ? "s " + regex : "i " + regex;
        Pattern pattern = (Pattern)m_regexPatterns.get(regexKey);

        if (pattern == null) {
            pattern = (regexKey.charAt(0) == 'i')
                    ? Pattern.compile(regex, Pattern.CASE_INSENSITIVE)
                    : Pattern.compile(regex);
            m_regexPatterns.put(regexKey, pattern);
        }

        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

}
// end of class


