<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xforms="http://www.w3.org/2002/xforms"
    xmlns:chiba="http://chiba.sourceforge.net/2003/08/xforms"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    exclude-result-prefixes="chiba xforms xlink xsl">

    <!-- This stylesheet contains a collection of templates which map XForms controls to HTML controls. -->
    <xsl:output method="html" indent="yes" omit-xml-declaration="yes"/>

    <!-- ######################################################################################################## -->
    <!-- This stylesheet serves as a 'library' for HTML form controls. It contains only named templates and may   -->
    <!-- be re-used in different layout-stylesheets to create the naked controls.                                 -->
    <!-- ######################################################################################################## -->

    <!-- build input control -->
    <xsl:template name="input">
        <xsl:param name="maxlength"/>

        <xsl:if test="chiba:data/@chiba:enabled != 'false'">

            <!-- todo: apply repeat-id to all other controls -->
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>
            <xsl:if test="$debug-enabled='true'">
                <xsl:message>###repeat-id:
                    <xsl:value-of select="$repeat-id"/>
                </xsl:message>
                <xsl:message>###has repeat-id:
                    <xsl:value-of select="boolean(string-length($repeat-id) > 0)"/>
                </xsl:message>
                <xsl:message>###position:
                    <xsl:value-of select="position()"/>
                </xsl:message>
            </xsl:if>

            <xsl:element name="input">
                <xsl:attribute name="id">
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="chiba:data/@chiba:name"/>
                </xsl:attribute>
                <xsl:attribute name="type">text</xsl:attribute>
                <xsl:attribute name="value">
                    <xsl:value-of select="chiba:data/text()"/>
                </xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="normalize-space(xforms:hint)"/>
                </xsl:attribute>
                <xsl:if test="$maxlength">
                    <xsl:attribute name="maxlength">
                        <xsl:value-of select="$maxlength"/>
                    </xsl:attribute>
                </xsl:if>
                <xsl:if test="chiba:data/@chiba:readonly='true'">
                    <xsl:attribute name="readonly">true</xsl:attribute>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="boolean(string-length($repeat-id) > 0)">
                        <xsl:attribute name="class">
                            <xsl:value-of select="concat($repeat-id,'-',$pos,' input-widget')"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:when test="boolean(string-length(@class) > 0)">
                        <xsl:attribute name="class">
                            <xsl:value-of select="concat(@class, ' ','input-widget')"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="class">input-widget</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>

            <xsl:if test="chiba:data/@chiba:required='true'">
                <span class="required-symbol">*</span>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <!-- build image trigger / submit -->
    <xsl:template name="image-trigger">
        <xsl:element name="input">
            <xsl:attribute name="id">
                <xsl:value-of select="@id"/>
            </xsl:attribute>
            <xsl:attribute name="name">
                <xsl:value-of select="chiba:data/@chiba:name"/>
            </xsl:attribute>
            <xsl:attribute name="type">image</xsl:attribute>
            <xsl:attribute name="value">
                <xsl:value-of select="xforms:label"/>
            </xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="normalize-space(xforms:hint)"/>
            </xsl:attribute>
            <xsl:attribute name="src">
                <xsl:value-of select="xforms:label/@xlink:href"/>
            </xsl:attribute>
            <xsl:attribute name="class">image-trigger-widget</xsl:attribute>
            <xsl:if test="chiba:data/@chiba:readonly='true'">
                <xsl:attribute name="readonly">true</xsl:attribute>
            </xsl:if>
            <xsl:call-template name="eval-actions"/>
        </xsl:element>

        <!--        <input name="{chiba:data/@chiba:name}" type="image" class="trigger" value="{xforms:label}" title="{xforms:hint}" src="{xforms:label/@xlink:href}"/>-->
    </xsl:template>

    <!-- build output -->
    <xsl:template name="output">
        <xsl:if test="chiba:data/@chiba:enabled != 'false'">

            <span class="output">
                <xsl:value-of select="chiba:data/text()"/>
            </span>
        </xsl:if>
    </xsl:template>

    <!-- build range -->
    <xsl:template name="range">
        <xsl:if test="chiba:data/@chiba:enabled != 'false'">
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>

            <xsl:if test="$debug-enabled='true'">
                <xsl:message>WARN: range not supported yet</xsl:message>
            </xsl:if>
            <xsl:element name="input">
                <xsl:attribute name="id">
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="chiba:data/@chiba:name"/>
                </xsl:attribute>
                <xsl:attribute name="type">text</xsl:attribute>
                <xsl:attribute name="value">WARN: range not supported yet</xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="normalize-space(xforms:hint)"/>
                </xsl:attribute>
                <xsl:choose>
                    <xsl:when test="boolean(string-length($repeat-id) > 0)">
                        <xsl:attribute name="class">
                            <xsl:value-of select="concat($repeat-id,'-',$pos,' range-widget')"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:when test="boolean(string-length(@class) > 0)">
                        <xsl:attribute name="class">
                            <xsl:value-of select="concat(@class, ' ','range-widget')"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="class">range-widget</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>

            <xsl:if test="chiba:data/@chiba:required='true'">
                <font color="red">*</font>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <!-- build secret control -->
    <xsl:template name="secret">
        <xsl:param name="maxlength"/>

        <xsl:if test="chiba:data/@chiba:enabled != 'false'">
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>

            <xsl:element name="input">
                <xsl:attribute name="id">
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="chiba:data/@chiba:name"/>
                </xsl:attribute>
                <xsl:attribute name="type">password</xsl:attribute>
                <xsl:attribute name="value">
                    <xsl:value-of select="chiba:data/text()"/>
                </xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="normalize-space(./xforms:hint)"/>
                </xsl:attribute>
                <xsl:if test="$maxlength">
                    <xsl:attribute name="maxlength">
                        <xsl:value-of select="$maxlength"/>
                    </xsl:attribute>
                </xsl:if>
                <xsl:if test="chiba:data/@chiba:readonly='true'">
                    <xsl:attribute name="readonly">true</xsl:attribute>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="boolean(string-length($repeat-id) > 0)">
                        <xsl:attribute name="class">
                            <xsl:value-of select="concat($repeat-id,'-',$pos,' secret-widget')"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:when test="boolean(string-length(@class) > 0)">
                        <xsl:attribute name="class">
                            <xsl:value-of select="concat(@class, ' ','secret-widget')"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="class">secret-widget</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>

            <xsl:if test="chiba:data/@chiba:required='true'">
                <font color="red">*</font>
            </xsl:if>
        </xsl:if>
    </xsl:template>


    <xsl:template name="select1">

        <xsl:if test="chiba:data/@chiba:enabled != 'false'">
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>

            <xsl:variable name="parent" select="."/>
            <xsl:choose>
                <xsl:when test="@xforms:appearance='compact'">
                    <xsl:element name="select">
                        <xsl:attribute name="id">
                            <xsl:value-of select="@id"/>
                        </xsl:attribute>
                        <xsl:attribute name="name">
                            <xsl:value-of select="chiba:data/@chiba:name"/>
                        </xsl:attribute>
                        <xsl:attribute name="size">5</xsl:attribute>
                        <xsl:attribute name="title">
                            <xsl:value-of select="normalize-space(./xforms:hint)"/>
                        </xsl:attribute>

                        <xsl:choose>
                            <xsl:when test="boolean(string-length($repeat-id) > 0)">
                                <xsl:attribute name="class">
                                    <xsl:value-of select="concat($repeat-id,'-',$pos,' select1-widget')"/>
                                </xsl:attribute>
                            </xsl:when>
                            <xsl:when test="boolean(string-length(@class) > 0)">
                                <xsl:attribute name="class">
                                    <xsl:value-of select="concat(@class, ' ','select1-widget')"/>
                                </xsl:attribute>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:attribute name="class">select1-widget</xsl:attribute>
                            </xsl:otherwise>
                        </xsl:choose>

                        <xsl:if test="chiba:data/@chiba:readonly='true'">
                            <xsl:attribute name="readonly">true</xsl:attribute>
                        </xsl:if>
                        <xsl:call-template name="build-items">
                            <xsl:with-param name="parent" select="$parent"/>
                        </xsl:call-template>
                    </xsl:element>
                    <xsl:if test="./chiba:data/@chiba:required='true'">
                        <span style="font-color:red;">*</span>
                    </xsl:if>
                </xsl:when>
                <xsl:when test="@xforms:appearance='full'">
                    <xsl:call-template name="build-radiobuttons">
                        <xsl:with-param name="name" select="chiba:data/@chiba:name"/>
                        <xsl:with-param name="value" select="chiba:data/text()"/>
                        <xsl:with-param name="parent" select="$parent"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="select">
                        <xsl:attribute name="id">
                            <xsl:value-of select="@id"/>
                        </xsl:attribute>
                        <xsl:attribute name="name">
                            <xsl:value-of select="chiba:data/@chiba:name"/>
                        </xsl:attribute>
                        <xsl:attribute name="size">1</xsl:attribute>
                        <xsl:attribute name="title">
                            <xsl:value-of select="normalize-space(./xforms:hint)"/>
                        </xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="boolean(string-length($repeat-id) > 0)">
                                <xsl:attribute name="class">
                                    <xsl:value-of select="concat($repeat-id,'-',$pos,' select1-widget')"/>
                                </xsl:attribute>
                            </xsl:when>
                            <xsl:when test="boolean(string-length(@class) > 0)">
                                <xsl:attribute name="class">
                                    <xsl:value-of select="concat(@class, ' ','select1-widget')"/>
                                </xsl:attribute>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:attribute name="class">select1-widget</xsl:attribute>
                            </xsl:otherwise>
                        </xsl:choose>

                        <xsl:if test="chiba:data/@chiba:readonly='true'">
                            <xsl:attribute name="readonly">true</xsl:attribute>
                        </xsl:if>
                        <xsl:call-template name="build-items">
                            <xsl:with-param name="parent" select="$parent"/>
                        </xsl:call-template>
                    </xsl:element>
                    <xsl:if test="./chiba:data/@chiba:required='true'">
                        <font color="red">*</font>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>


    <xsl:template name="select">

        <xsl:if test="chiba:data/@chiba:enabled != 'false'">
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>

            <xsl:variable name="parent" select="."/>
            <xsl:choose>
                <xsl:when test="@xforms:appearance='compact'">
                    <xsl:element name="select">
                        <xsl:attribute name="id">
                            <xsl:value-of select="@id"/>
                        </xsl:attribute>
                        <xsl:attribute name="name">
                            <xsl:value-of select="chiba:data/@chiba:name"/>
                        </xsl:attribute>
                        <xsl:attribute name="title">
                            <xsl:value-of select="normalize-space(./xforms:hint)"/>
                        </xsl:attribute>
                        <xsl:attribute name="multiple">true</xsl:attribute>
                        <xsl:attribute name="size">5</xsl:attribute>
                        <xsl:if test="chiba:data/@chiba:readonly='true'">
                            <xsl:attribute name="readonly">true</xsl:attribute>
                        </xsl:if>
                        <xsl:attribute name="class">select-widget</xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="boolean(string-length($repeat-id) > 0)">
                                <xsl:attribute name="class">
                                    <xsl:value-of select="concat($repeat-id,'-',$pos,' select-widget')"/>
                                </xsl:attribute>
                            </xsl:when>
                            <xsl:when test="boolean(string-length(@class) > 0)">
                                <xsl:attribute name="class">
                                    <xsl:value-of select="concat(@class, ' ','select-widget')"/>
                                </xsl:attribute>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:attribute name="class">select-widget</xsl:attribute>
                            </xsl:otherwise>
                        </xsl:choose>

                        <xsl:call-template name="build-items">
                            <xsl:with-param name="value" select="chiba:data/text()"/>
                            <xsl:with-param name="parent" select="$parent"/>
                        </xsl:call-template>
                    </xsl:element>
                    <xsl:if test="./chiba:data/@chiba:required='true'">
                        <font color="red">*</font>
                    </xsl:if>
                </xsl:when>
                <xsl:when test="@xforms:appearance='full'">
                    <xsl:call-template name="build-checkboxes">
                        <xsl:with-param name="name" select="chiba:data/@chiba:name"/>
                        <xsl:with-param name="value" select="chiba:data/text()"/>
                        <xsl:with-param name="parent" select="$parent"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="select">
                        <xsl:attribute name="id">
                            <xsl:value-of select="@id"/>
                        </xsl:attribute>
                        <xsl:attribute name="name">
                            <xsl:value-of select="chiba:data/@chiba:name"/>
                        </xsl:attribute>
                        <xsl:attribute name="title">
                            <xsl:value-of select="normalize-space(./xforms:hint)"/>
                        </xsl:attribute>
                        <xsl:attribute name="multiple">true</xsl:attribute>
                        <xsl:attribute name="size">3</xsl:attribute>
                        <xsl:if test="chiba:data/@chiba:readonly='true'">
                            <xsl:attribute name="readonly">true</xsl:attribute>
                        </xsl:if>

                        <xsl:choose>
                            <xsl:when test="boolean(string-length($repeat-id) > 0)">
                                <xsl:attribute name="class">
                                    <xsl:value-of select="concat($repeat-id,'-',$pos,' select-widget')"/>
                                </xsl:attribute>
                            </xsl:when>
                            <xsl:when test="boolean(string-length(@class) > 0)">
                                <xsl:attribute name="class">
                                    <xsl:value-of select="concat(@class, ' ','select-widget')"/>
                                </xsl:attribute>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:attribute name="class">select-widget</xsl:attribute>
                            </xsl:otherwise>
                        </xsl:choose>

                        <xsl:call-template name="build-items">
                            <xsl:with-param name="value" select="chiba:data/text()"/>
                            <xsl:with-param name="parent" select="$parent"/>
                        </xsl:call-template>
                    </xsl:element>
                    <xsl:if test="./chiba:data/@chiba:required='true'">
                        <font color="red">*</font>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>

        </xsl:if>
    </xsl:template>

    <!-- build textarea control -->
    <xsl:template name="textarea">
        <xsl:if test="chiba:data/@chiba:enabled != 'false'">
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>

            <xsl:element name="textarea">
                <xsl:attribute name="id">
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="chiba:data/@chiba:name"/>
                </xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="normalize-space(xforms:hint)"/>
                </xsl:attribute>
                <xsl:if test="chiba:data/@chiba:readonly='true'">
                    <xsl:attribute name="readonly">true</xsl:attribute>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="boolean(string-length($repeat-id) > 0)">
                        <xsl:attribute name="class">
                            <xsl:value-of select="concat($repeat-id,'-',$pos,' textarea-widget')"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:when test="boolean(string-length(@class) > 0)">
                        <xsl:attribute name="class">
                            <xsl:value-of select="concat(@class, ' ','textarea-widget')"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="class">textarea-widget</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="chiba:data/text()"/>
            </xsl:element>

            <xsl:if test="chiba:data/@chiba:required='true'">
                <font color="red">*</font>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <!-- build submit -->
    <xsl:template name="submit">
        <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
        <xsl:variable name="pos" select="position()"/>

        <xsl:element name="input">
            <xsl:attribute name="id">
                <xsl:value-of select="@id"/>
            </xsl:attribute>
            <xsl:attribute name="type">submit</xsl:attribute>
            <xsl:attribute name="name">
                <xsl:value-of select="chiba:data/@chiba:name"/>
            </xsl:attribute>
            <xsl:attribute name="value">
                <xsl:value-of select="xforms:label"/>
            </xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="normalize-space(xforms:hint)"/>
            </xsl:attribute>
            <xsl:if test="chiba:data/@chiba:readonly='true'">
                <xsl:attribute name="readonly">true</xsl:attribute>
            </xsl:if>
            <xsl:if test="chiba:data/@chiba:enabled='false'">
                <xsl:attribute name="disabled">true</xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="boolean(string-length($repeat-id) > 0)">
                    <xsl:attribute name="class">
                        <xsl:value-of select="concat($repeat-id,'-',$pos,' submit-widget')"/>
                    </xsl:attribute>
                </xsl:when>
                <xsl:when test="boolean(string-length(@class) > 0)">
                    <xsl:attribute name="class">
                        <xsl:value-of select="concat(@class, ' ','submit-widget')"/>
                    </xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="class">submit-widget</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>

        </xsl:element>
    </xsl:template>

    <!-- build trigger -->
    <!-- ### please note that triggers are always submit buttons cause this stylesheet assumes no javascript ### -->
    <xsl:template name="trigger">
        <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
        <xsl:variable name="pos" select="position()"/>

        <xsl:element name="input">
            <xsl:attribute name="id">
                <xsl:value-of select="@id"/>
            </xsl:attribute>
            <xsl:attribute name="name">
                <xsl:value-of select="chiba:data/@chiba:name"/>
            </xsl:attribute>
            <xsl:attribute name="type">submit</xsl:attribute>
            <!--            <xsl:attribute name="type">button</xsl:attribute>-->
            <xsl:attribute name="value">
                <xsl:value-of select="xforms:label"/>
            </xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="normalize-space(xforms:hint)"/>
            </xsl:attribute>
            <xsl:choose>
                <xsl:when test="boolean(string-length($repeat-id) > 0)">
                    <xsl:attribute name="class">
                        <xsl:value-of select="concat($repeat-id,'-',$pos,' trigger-widget')"/>
                    </xsl:attribute>
                </xsl:when>
                <xsl:when test="boolean(string-length(@class) > 0)">
                    <xsl:attribute name="class">
                        <xsl:value-of select="concat(@class, ' ','trigger-widget')"/>
                    </xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="class">trigger-widget</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>

            <xsl:if test="chiba:data/@chiba:readonly='true'">
                <xsl:attribute name="readonly">true</xsl:attribute>
            </xsl:if>
            <xsl:if test="chiba:data/@chiba:enabled='false'">
                <xsl:attribute name="disabled">true</xsl:attribute>
            </xsl:if>
            <xsl:if test="@xforms:accesskey">
                <xsl:attribute name="accesskey">
                    <xsl:value-of select="@xforms:accesskey"/>
                </xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="normalize-space(xforms:hint)"/> - KEY: [ALT]+ <xsl:value-of select="@xforms:accesskey"/>
                </xsl:attribute>
            </xsl:if>

            <xsl:call-template name="eval-actions"/>
        </xsl:element>

        <!--        <input name="{chiba:data/@chiba:name}" type="submit" value="{xforms:label}" title="{xforms:hint}"/>-->
    </xsl:template>

    <!-- build upload control -->
    <!-- todo: fix upload -->
    <xsl:template name="upload">
        <!-- the stylesheet using this template has to take care, that form enctype is set to 'multipart/form-data' -->

        <xsl:if test="chiba:data/@chiba:enabled != 'false'">
            <xsl:variable name="repeat-id" select="ancestor::*[name(.)='xforms:repeat'][1]/@id"/>
            <xsl:variable name="pos" select="position()"/>

            <xsl:if test="$debug-enabled='true'">
                <xsl:message>WARN: upload partially supported</xsl:message>
            </xsl:if>
            <xsl:element name="input">
                <xsl:attribute name="id">
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="chiba:data/@chiba:name"/>
                </xsl:attribute>
                <xsl:attribute name="type">file</xsl:attribute>
                <xsl:attribute name="value"></xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="normalize-space(xforms:hint)"/>
                </xsl:attribute>
                <xsl:if test="chiba:data/@chiba:readonly='true'">
                    <xsl:attribute name="readonly">true</xsl:attribute>
                </xsl:if>

                <xsl:choose>
                    <xsl:when test="boolean(string-length($repeat-id) > 0)">
                        <xsl:attribute name="class">
                            <xsl:value-of select="concat($repeat-id,'-',$pos,' upload-widget')"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:when test="boolean(string-length(@class) > 0)">
                        <xsl:attribute name="class">
                            <xsl:value-of select="concat(@class, ' ','upload-widget')"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="class">upload-widget</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>

                <!--Content types accepted, from mediatype xforms:upload attribute
                to accept input attribute-->
                <xsl:attribute name="accept">
                    <xsl:value-of select="translate(normalize-space(@xforms:mediatype),' ',',')"/>
                </xsl:attribute>
            </xsl:element>

            <xsl:if test="chiba:data/@chiba:required='true'">
                <font color="red">*</font>
            </xsl:if>

        </xsl:if>
    </xsl:template>


    <!-- ######################################################################################################## -->
    <!-- ########################################## HELPER TEMPLATES FOR SELECT, SELECT1 ######################## -->
    <!-- ######################################################################################################## -->

    <xsl:template name="build-items">
        <xsl:param name="parent"/>

        <!-- add an empty item, cause otherwise deselection is not possible -->
        <option value=""/>

        <xsl:variable name="items" select="$parent//xforms:item"/>
        <xsl:for-each select="$items">
            <xsl:choose>
                <xsl:when test="@xforms:selected='true'">
                    <option value="{./xforms:value}" selected="selected">
                        <xsl:apply-templates select="./xforms:label"/>
                    </option>
                </xsl:when>
                <xsl:otherwise>
                    <option value="{./xforms:value}">
                        <xsl:apply-templates select="./xforms:label"/>
                    </option>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

    <!-- overwrite/change this template, if you don't like the
    way labels are rendered for checkboxes -->
    <!-- todo: consider readonly attribute -->
    <xsl:template name="build-checkboxes">
        <xsl:param name="name"/>
        <xsl:param name="parent"/>

        <xsl:variable name="items" select="$parent//xforms:item"/>
        <xsl:for-each select="$items">
            <xsl:choose>
                <xsl:when test="@xforms:selected='true'">
                    <input class="checkbox-widget" type="checkbox" name="{$name}" value="{./xforms:value}" checked="checked" title="{./xforms:label}"/>

                </xsl:when>
                <xsl:otherwise>
                    <input class="checkbox-widget" type="checkbox" name="{$name}" value="{./xforms:value}" title="{./xforms:label}"/>
                </xsl:otherwise>
            </xsl:choose>
            <!-- create hidden parameter for deselection -->
            <input type="hidden" name="{$name}" value=""/>
            <xsl:apply-templates select="./xforms:label"/>
        </xsl:for-each>
        <xsl:if test="./@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>
    </xsl:template>

    <!-- overwrite/change this template, if you don't the way labels are rendered for checkboxes -->
    <!-- todo: consider readonly attribute -->
    <xsl:template name="build-radiobuttons">
        <xsl:param name="name"/>
        <xsl:param name="parent"/>

        <xsl:variable name="items" select="$parent//xforms:item"/>
        <xsl:for-each select="$items">
            <xsl:choose>
                <xsl:when test="@xforms:selected='true'">
                    <input class="radiobutton-widget" type="radio" name="{$name}" value="{./xforms:value}" checked="checked" title="{$parent/xforms:hint}"/>
                </xsl:when>
                <xsl:otherwise>
                    <input class="radiobutton-widget" type="radio" name="{$name}" value="{./xforms:value}" title="{$parent/xforms:hint}"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:apply-templates select="./xforms:label">
                <xsl:with-param name="class"></xsl:with-param>
            </xsl:apply-templates>
        </xsl:for-each>
        <xsl:if test="./chiba:data/@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
