package org.chiba.connectors.xmlrpc;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.connector.AbstractConnector;
import org.chiba.xml.xforms.connector.URIResolver;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Document;

import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;


/**
 * This class resolves <code>xmlrpc</code> URIs. It treats the denoted
 * <code>xmlrpc</code> resource as a XML-RPC function, with parameters
 * passed as a query string to the URI.  The function is called
 * with the parameters in a Hashtable, and an xml Document is returned
 * <p>
 * If the specified URI contains a fragment part, the specified element
 * is looked up via the <code>getElementById</code>. Thus, the parsed
 * response must have an internal DTD subset specifying all ID attribute.
 * Otherwise the element would not be found.
 *
 * @author Chris Picton;
 */
public class XMLRPCURIResolver extends AbstractConnector implements URIResolver {
	private static Logger log = Logger.getLogger(XMLRPCURIResolver.class);
	
	/**
	 * Decodes the <code>xmlrpc</code> URI, runs the indicated function
	 * and returns the result as a DOM document.
	 *
	 * @return a DOM node parsed from the <code>xmlrpc</code> URI.
	 * @throws XFormsException if any error occurred.
	 */
	public Object resolve() throws XFormsException {
		try {
			log.setLevel(Level.DEBUG);
		
			URI uri = new URI(getURI());
			log.debug("getting '" + uri + "'");

			String func = uri.getHost();
			String query = uri.getQuery();
			log.debug("func  = " + func);
			log.debug("query = " + query);
			
			Hashtable params = parseQueryString(query);
			
			org.chiba.connectors.xmlrpc.RPCClient rpc = new org.chiba.connectors.xmlrpc.RPCClient();
			Document document = rpc.getDocument(func, params);
			
			if (uri.getFragment() != null) {
				return document.getElementById(uri.getFragment());
			}

			return document;
		} catch (Exception e) {
			throw new XFormsException(e);
		}
	}

	/**
	 * Parses the query string param1=val1&param2=val2 into a Hashtable
	 * The values are Vectors, as there may be multiple params with the same
	 * key in the string
	 *
	 * @return a Hashtable.
	 */
	private Hashtable parseQueryString(String query) {
		Hashtable h = new Hashtable();
		
		String[] params = query.split("&");
		
		for (int i=0; i<params.length; i++) {
			log.debug("params[" + i + "] = " + params[i]);
			
			String[] keyval = params[i].split("=");
			
			log.debug("\t" + keyval[0] + " -> " + keyval[1]);
			
			if (!h.contains(keyval[0]))
				h.put(keyval[0], new Vector());
			
			Vector v = (Vector)h.get(keyval[0]);
			v.addElement(keyval[1]);
		}
		
		return h;
	}
}
