/*
 *
 *    Artistic License
 *
 *    Preamble
 *
 *    The intent of this document is to state the conditions under which a Package may be copied, such that
 *    the Copyright Holder maintains some semblance of artistic control over the development of the
 *    package, while giving the users of the package the right to use and distribute the Package in a
 *    more-or-less customary fashion, plus the right to make reasonable modifications.
 *
 *    Definitions:
 *
 *    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives
 *    of that collection of files created through textual modification.
 *
 *    "Standard Version" refers to such a Package if it has not been modified, or has been modified
 *    in accordance with the wishes of the Copyright Holder.
 *
 *    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
 *
 *    "You" is you, if you're thinking about copying or distributing this Package.
 *
 *    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication
 *    charges, time of people involved, and so on. (You will not be required to justify it to the
 *    Copyright Holder, but only to the computing community at large as a market that must bear the
 *    fee.)
 *
 *    "Freely Available" means that no fee is charged for the item itself, though there may be fees
 *    involved in handling the item. It also means that recipients of the item may redistribute it under
 *    the same conditions they received it.
 *
 *    1. You may make and give away verbatim copies of the source form of the Standard Version of this
 *    Package without restriction, provided that you duplicate all of the original copyright notices and
 *    associated disclaimers.
 *
 *    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain
 *    or from the Copyright Holder. A Package modified in such a way shall still be considered the
 *    Standard Version.
 *
 *    3. You may otherwise modify your copy of this Package in any way, provided that you insert a
 *    prominent notice in each changed file stating how and when you changed that file, and provided that
 *    you do at least ONE of the following:
 *
 *        a) place your modifications in the Public Domain or otherwise make them Freely
 *        Available, such as by posting said modifications to Usenet or an equivalent medium, or
 *        placing the modifications on a major archive site such as ftp.uu.net, or by allowing the
 *        Copyright Holder to include your modifications in the Standard Version of the Package.
 *
 *        b) use the modified Package only within your corporation or organization.
 *
 *        c) rename any non-standard executables so the names do not conflict with standard
 *        executables, which must also be provided, and provide a separate manual page for each
 *        non-standard executable that clearly documents how it differs from the Standard
 *        Version.
 *
 *        d) make other distribution arrangements with the Copyright Holder.
 *
 *    4. You may distribute the programs of this Package in object code or executable form, provided that
 *    you do at least ONE of the following:
 *
 *        a) distribute a Standard Version of the executables and library files, together with
 *        instructions (in the manual page or equivalent) on where to get the Standard Version.
 *
 *        b) accompany the distribution with the machine-readable source of the Package with
 *        your modifications.
 *
 *        c) accompany any non-standard executables with their corresponding Standard Version
 *        executables, giving the non-standard executables non-standard names, and clearly
 *        documenting the differences in manual pages (or equivalent), together with instructions
 *        on where to get the Standard Version.
 *
 *        d) make other distribution arrangements with the Copyright Holder.
 *
 *    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge
 *    any fee you choose for support of this Package. You may not charge a fee for this Package itself.
 *    However, you may distribute this Package in aggregate with other (possibly commercial) programs as
 *    part of a larger (possibly commercial) software distribution provided that you do not advertise this
 *    Package as a product of your own.
 *
 *    6. The scripts and library files supplied as input to or produced as output from the programs of this
 *    Package do not automatically fall under the copyright of this Package, but belong to whomever
 *    generated them, and may be sold commercially, and may be aggregated with this Package.
 *
 *    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of
 *    this Package.
 *
 *    8. The name of the Copyright Holder may not be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 *    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 *    MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

package org.chiba.adapter.web;

import org.chiba.xml.xforms.ChibaContext;
import org.chiba.xml.xforms.config.Config;
import org.chiba.xml.xforms.ui.BoundElement;
import org.apache.log4j.Category;

import java.util.Map;
import java.util.HashMap;

/**
 * stores Servlet application specific properties.
 *
 * @author joern turner
 * @version $Id: WebContext.java,v 1.1 2004/03/05 17:45:41 joernt Exp $
 */
public class WebContext implements ChibaContext {
    private static final Category LOGGER = Category.getInstance(ChibaContext.class);

//    public static final String INSTANCE_URI_MAP = "chiba.instanceURIs";
//    public static final String SUBMISSION_URI_MAP = "chiba.submissionURIs";
    public static final String REQUEST_PARAMETERS = "chiba.parameters";

    private Map properties=null;
    private ServletAdapter servletAdapter = null;

    public WebContext(ServletAdapter aAdapter) {
        this.servletAdapter = aAdapter;
        this.properties = new HashMap();
    }

    /**
     * stores a Servlet specific property in the context.
     * @param key the property key
     * @param value the property value
     */
    public void setProperty(String key, Object value) {
        this.properties.put(key,value);
    }

    /**
     * reads a Servlet specific property from the context.
     * @param key the key for the wanted object
     * @return returns object from context
     */
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    /** Return the properties Map
     * @return All context properties in a Map object
     */
    public Map getProperties() {
        return this.properties;
    }

    /**
     * Returns an external name for a given bound control. This can be either a form control or
     * another bound element like label, alert, filename, mediatype....
     *
     * Note: this solution is a bit of a hack. the method would feel better in ServletAdapter itself but
     * this would make necessary another interface to access this method from inside the processor.
     *
     * @param control the bound control.
     * @return an external name for a given bound control.
     */
    public String getExternalName(BoundElement control) {
        String name;

        if (control instanceof org.chiba.xml.xforms.ui.Trigger) {
            name = servletAdapter.getUniqueParameterName(servletAdapter.getTriggerPrefix());
        } else {
            name = servletAdapter.getUniqueParameterName(servletAdapter.getDataPrefix());
        }

        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("mapped " + control + " to '" + name + "' ...");
        }

        ((Map)getProperty(WebContext.REQUEST_PARAMETERS)).put(name,control.getId());

        return name;
    }



}
//end of class

