<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : appfilter.xsl
    Created on : 06 March 2003, 19:42
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:param name="param"/>
	<xsl:variable name="threshold" select="$param/nvp/age * substring-after($param/nvp/time, ',') * 1000"/>
	
    <xsl:template match="/mls">
		<mls>
			<xsl:apply-templates/>
		</mls>
    </xsl:template>
	
	<xsl:template match="dir">
		<xsl:choose>
				<xsl:when test="$threshold=0">
					<xsl:call-template name="directory"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="descendant::res[age &lt; 3*$threshold]">
						<xsl:call-template name="directory"/>
					</xsl:if>
				</xsl:otherwise>
		</xsl:choose>
    </xsl:template>

	<xsl:template name="directory">
		<dir>
			<xsl:apply-templates />
		</dir>
	</xsl:template>
	
	<xsl:template match="res">
		<xsl:choose>
			<xsl:when test="$threshold=0">
				<xsl:copy-of select="."/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="age &lt;3*$threshold">
					<xsl:copy-of select="."/>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
    </xsl:template>

</xsl:stylesheet> 
