<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes"/>

<xsl:param name="param"/>
<xsl:param name="selected"/>
<xsl:variable name="hour">3600</xsl:variable>
<xsl:variable name="modselected"><xsl:value-of select="substring-before ( $selected/nvp/mod, ',' )"/></xsl:variable>


<xsl:template match="/mls">
<html>
	<head>
		<STYLE TYPE="text/css" MEDIA="screen">
		table	{ background-color: #ffffff; border-width: 0;}
		td		{ padding: 0pt 5pt; 0pt 5pt ; }
		body	{ font-family: "Lucida Sans", Arial, Helvetica, sans-serif; font-size: 95%; }
		</STYLE>
	</head>
	<body bgcolor="white">
		<b>DPML Tutorial - Resource Browser (b)</b>
		<form method="post" action="app7.idoc">
			Module <select name="mod">
					<option value="1,*">
						<xsl:if test="$modselected=1">
							<xsl:attribute name="selected">true</xsl:attribute>
						</xsl:if>
					*</option>
					<xsl:for-each select="$param/modules/module">
						<xsl:sort select="."/>
						<option>
							<xsl:attribute name="value">
								<xsl:value-of select="position()+1"/>,<xsl:value-of select="identity/uri"/>
							</xsl:attribute>
							<xsl:if test="$modselected=position()+1">
								<xsl:attribute name="selected">true</xsl:attribute>
							</xsl:if>
							<xsl:value-of select="identity/uri"/>
						</option>
					</xsl:for-each>
			</select>
			<input type="submit" value="Submit" name="submit"/>
		</form>
		<table>
			<xsl:apply-templates select="dir"/>
			<xsl:apply-templates select="res"/>
		</table>
	</body>
</html>
</xsl:template>

<xsl:template match="dir">
	<tr>
		<td bgcolor="#A5FF99" align="center">
			<xsl:attribute name="rowspan">
				<xsl:value-of select="count(.//res)+(count(.//dir)*2)+2"/>
			</xsl:attribute>	
			<xsl:value-of select="./text()"/>
		</td>
	</tr>
	<tr>
		<td>
			<xsl:apply-templates select="dir"/>
		</td>
		<xsl:for-each select="parent::dir"><td/></xsl:for-each>
	</tr>
	<xsl:for-each select="res">
		<tr >		
			<xsl:call-template name="res"/>
			<xsl:for-each select="parent::dir"><td/></xsl:for-each>
		</tr>
	</xsl:for-each>
</xsl:template>

<xsl:template match="res">
	<tr>
		<xsl:call-template name="res"/>
	</tr>
</xsl:template>

<xsl:template name="res">
	<td colspan="100">
		<xsl:attribute name="bgcolor">
			<xsl:if test="@age&lt;$hour">
				<xsl:text>#ffccff</xsl:text>
			</xsl:if>
			<xsl:if test="( @age&gt;$hour ) and ( @age&lt;2*$hour )">
				<xsl:text>#ffccaa</xsl:text>
			</xsl:if>
			<xsl:if test="@age&gt;=(2*$hour)">
				<xsl:text>#ffff99</xsl:text>
			</xsl:if>
		</xsl:attribute>
		<font size="-1">
			<!--
				<xsl:call-template name="trimuri">
					<xsl:with-param name="uri" select="@uri"/>
				</xsl:call-template>
			-->
			<xsl:value-of select="./text()"/>
		</font>
	</td>
</xsl:template>

<xsl:template name="trimuri">
	<xsl:param name="uri"/>
	<xsl:choose>
		<xsl:when test="contains($uri, '/')">
			<xsl:call-template name="trimuri">
				<xsl:with-param name="uri" select="substring-after($uri, '/')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>	
			<xsl:value-of select="$uri"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>
