<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : appfilter.xsl
    Created on : 06 March 2003, 19:42
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="threshold">3600</xsl:variable>
	
    <xsl:template match="root">
		<root>
			<xsl:apply-templates/>
		</root>
    </xsl:template>
	
	<xsl:template match="dir">
		<xsl:if test="descendant::resource[@age&lt;3*$threshold]">
		<dir>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:apply-templates />
		</dir>
		</xsl:if>
    </xsl:template>

	<xsl:template match="resource">
		<xsl:if test="@age&lt;3*$threshold">
			<xsl:copy-of select="."/>
		</xsl:if>
    </xsl:template>
	
	<xsl:template match="application">
			<xsl:copy-of select="."/>
    </xsl:template>
	
</xsl:stylesheet> 
