import com.ten60.netkernel.urii.IURRepresentation;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.representation.StringAspect;
import org.ten60.netkernel.xml.representation.IAspectXDA;
import java.awt.Point;

void main()
{   
    int iterations=4;
    try
    {   iterations = Integer.parseInt(context.sourceAspect("this:param:param",IAspectXDA.class).getXDA().getText("/nvp/iterations",true));
    } catch (Exception e)
    {   // ignore and use default
    }
    if (iterations<1) iterations=1;
    if (iterations>7) iterations=7;

    StringBuffer sb=new StringBuffer(1024);
    sb.append("<html><body>");
    sb.append("<h2>Hilbert Curve Beanshell Example</h2>");
    sb.append("<table><tr><td>");
	sb.append("<img width='256' height='256' style='padding: 4px;' src='/ep+name@img_hilbert?iterations="+iterations+"'/>");
    sb.append("<center><form action='doc_map_script_hilbert'>");
    sb.append("Iterations:<input align='right' size='2' type='text' name='iterations' value='"+iterations+"'/>");
    sb.append("<input type='submit' value='generate'/>");
    sb.append("</form></center>");
    sb.append("</td><td>");
    sb.append("<p>This example uses beanshell to algorithmically create an SVG rendering of the hilbert curve. ");
    sb.append("The SVG is then pipelined through the SVG2PNG accessor to generate the image you see. ");
    sb.append("It is a good example of combining processing with sub-requests inside a script.</p>");

    sb.append("<p>This demonstrates a scenario where a procedural script is more efficient than a declarative runtime.</p>");
	sb.append("<p><b>Note:</b> With a high iteration count, the Hilbert curve algorithm and rendering of the generated SVG becomes performance intensive.</p>");

    sb.append("<p>View the script <a href='/ep+name@doc_map_script_hilbert_src'>here</a>.</p>");
    sb.append("<p>Play in the <a href='/ep+name@app_script_playpen?example=Hilbert%20Space%20in%20SVG.bsh'>playpen</a>.</p>");
    sb.append("</td></tr></table>");
    sb.append("</body></html>");
    StringAspect aspect = new StringAspect(sb.toString());
    INKFResponse response = context.createResponseFrom(aspect);
    context.setResponse(response);

}

