<?xml version="1.0" encoding="UTF-8" ?>


<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

	<xsl:param name="param"/>
	
    <xsl:template match="/ps">
        <html>
            <head>
                <title>PS</title>
				<link href="/book/static/style.css" rel="stylesheet" type="text/css"  />
				<link href="/favicon.ico" rel="SHORTCUT ICON"  />
            </head>
            <body>
				<h2>Native Operating System Process Table</h2>
				<table cellspacing="0" cellpadding="2">
					<tr bgcolor="#aaaaff">
						<td>Name <a href="?name=true">[^]</a></td>
						<td>PID <a href="?pid=true">[^]</a></td>
						<td>Owner <a href="?owner=true">[^]</a></td>
						<td>CPU% <a href="?cpu=true">[^]</a></td>
						<td>Memory% <a href="?memory=true">[^]</a></td>
						<td>Time <a href="?time=true">[^]</a></td>
					</tr>
					
					<xsl:choose>
						<xsl:when test="$param/nvp/memory = 'true'">
							<xsl:apply-templates select="process">
								<xsl:sort select="memory" data-type="number" order="descending"/>
							</xsl:apply-templates>
						</xsl:when>
						<xsl:when test="$param/nvp/cpu = 'true'">
							<xsl:apply-templates select="process">
								<xsl:sort select="cpu" data-type="number" order="descending"/>
							</xsl:apply-templates>
						</xsl:when>
						<xsl:when test="$param/nvp/pid = 'true'">
							<xsl:apply-templates select="process">
								<xsl:sort select="pid" data-type="number" order="ascending"/>
							</xsl:apply-templates>
						</xsl:when>
						<xsl:when test="$param/nvp/owner = 'true'">
							<xsl:apply-templates select="process">
								<xsl:sort select="owner"/>
							</xsl:apply-templates>
						</xsl:when>
						<xsl:when test="$param/nvp/name = 'true'">
							<xsl:apply-templates select="process">
								<xsl:sort select="name"/>
							</xsl:apply-templates>
						</xsl:when>
						<xsl:when test="$param/nvp/time = 'true'">
							<xsl:apply-templates select="process">
								<xsl:sort select="time" order="descending"/>
							</xsl:apply-templates>
						</xsl:when>
						<xsl:otherwise>
							<xsl:apply-templates select="process"/>
						</xsl:otherwise>
						
					</xsl:choose>
						
				</table>
				
				<img style="margin: 10px;" src="/book/static/poweredby.png"/>
            </body>
        </html>
    </xsl:template>
	
	<xsl:template match="process">
		<tr>
			<xsl:choose>
				<xsl:when test="position() mod 2 = 1">
					<xsl:attribute name="bgcolor">#eeeeff</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="bgcolor">#ccccff</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="name"/></td>
			<td><xsl:value-of select="pid"/></td>
			<td><xsl:value-of select="owner"/></td>
			<td><xsl:value-of select="cpu"/></td>
			<td><xsl:value-of select="memory"/></td>
			<td><xsl:value-of select="time"/></td>
		</tr>
	</xsl:template>
	

</xsl:stylesheet>
