/*
 * CaseAccessor.java
 *
 */

package org.ten60.netkernel.util;

import com.ten60.netkernel.urii.*;
import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;

import org.ten60.netkernel.xml.util.XMLUtils;
import org.ten60.netkernel.layer1.meta.DependencyMeta;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import java.util.regex.*;

/**
 * Case Accessor changes case of all text entries an XML document
 */
public class DocLinkMapperAccessor extends XAccessor
{
	private Matcher mMatcher;
	
	/** Creates a new instance of CaseAccessor */
	public DocLinkMapperAccessor()
	{	declareArgument(XAccessor.OPERAND, true, false);
		declareArgument(XAccessor.PARAMETER,true,false);
		mMatcher = Pattern.compile("/ep\\+name@(doc.*)").matcher("");
	}
	
	/**source request**/
	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{	DOMXDA opd=new DOMXDA(aHelper.getOperand().getReadOnlyDocument(),true);
		String baseURI = aHelper.getURI(XAHelper.PARAMETER).getPath();
		IXDAIterator i=opd.iterator("/descendant::a/@href");
		while(i!=null && i.hasNext())
		{	i.next();
			String s=i.getText(".", false);
			mMatcher.reset(s);
			if(mMatcher.matches())
			{	String uri=baseURI+mMatcher.group(1);
				i.setText(".", uri);
			}
		}
		return DOMXDAAspect.create(aHelper.getDependencyMeta("text/xml", 8), opd);
		
		
	}
}
