/*
 * CaseAccessor.java
 *
 */

package doc.staticdoc;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;

import org.ten60.netkernel.xml.util.XMLUtils;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.representation.VoidAspect;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import java.net.*;
import java.util.*;

/**
 * Case Accessor changes case of all text entries an XML document
 */
public class StaticDocAccessor extends XAccessor
{
	
	/** Creates a new instance of CaseAccessor */
	public StaticDocAccessor()
	{	declareArgument(OPERAND, true, false);
		declareArgument(OPERATOR, true, false); // destination path
		declareForgetDependencies();
	}
	
	/**source request**/
	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{	IXDAReadOnly opd=aHelper.getOperand().getXDA();
		Map resources = new HashMap();
		Set	menuPages = new HashSet();
		Set	extraPages = new HashSet();
		IXDAReadOnlyIterator i=opd.readOnlyIterator("//*");
		while(i!=null && i.hasNext())
		{	i.next();
			String name;
			try
			{	name=i.getText("@index", false);
			} catch (XPathLocationException e)
			{	name=i.getText(".", false);
			}
			menuPages.add(name);
		}
		
		int count=0;
		i=opd.readOnlyIterator("//*");
		while(i!=null && i.hasNext())
		{	i.next();
			String name;
			try
			{	name=i.getText("@index", false);
			} catch (XPathLocationException e)
			{	name=i.getText(".", false);
			}
			process(name, resources, menuPages, extraPages, aHelper);
			count++;
			//if (count>20) break;
		}
		
		//extra pages not in menu but referenced (recursively)
		extraPages.add("notavailable");
		while (extraPages.size()>0)
		{	Set newPages = new HashSet();
			menuPages.addAll(extraPages);
			for (Iterator j = extraPages.iterator(); j.hasNext(); )
			{	String name = (String)j.next();
				process(name, resources, menuPages, newPages, aHelper);
			}
			extraPages=newPages;
		}
		
		return VoidAspect.create();
	}
	
	private void process(String aName, Map aResources, Set aMenuPages, Set aExtraPages, XAHelper aHelper) throws Exception
	{	// get document
		try
		{
			String uri="active:mapper+operator@ffcpl:/doc/links.xml+operand@ffcpl:/doc/+doc@ep:"+aName;
			System.out.println("requesting entrypoint "+aName);
			IXAspect resource = (IXAspect)aHelper.getResource(URI.create(uri),IXAspect.class).getAspect(IXAspect.class);
			DOMXDA doc = new DOMXDA(resource.getReadOnlyDocument(),true);

			// delete header links
			doc.delete("/html/body/table[1]/tr/td/table/tr[1]/td/table/tr[2]");
			
			//fix all links
			IXDAIterator i=doc.iterator("//a[@href]");
			while (i.hasNext())
			{	i.next();
				String href = i.getText("@href",true);
				if (href.startsWith("/docengine/"))
				{	// link to another doc
					String name = href.substring(11);
					String fragment=null;
					int i2=name.indexOf('#');
					if (i2>0)
					{	fragment=name.substring(i2);
						name=name.substring(0,i2);
					}
					if (!aMenuPages.contains(name))
					{	aExtraPages.add(name);
					}
					href=name+".html";
					if (fragment!=null)
					{	href=href+=fragment;
					}
					i.setText("@href",href);
				}
				else if (!href.startsWith("http://"))
				{	// links to non-included content
					href="notavailable.html";
					i.setText("@href",href);
				}
			}
			//find all images
			i=doc.iterator("//form[@action]");
			while (i.hasNext())
			{	i.next();
				i.setText("@action","");
			}

			//find all links (css/favicon)
			i=doc.iterator("//link[@href]");
			while (i.hasNext())
			{	i.next();
				String href = i.getText("@href",true);
				href = processResource(href,aResources,aHelper);
				i.setText("@href",href);
			}
			//find all images
			i=doc.iterator("//img[@src]");
			while (i.hasNext())
			{	i.next();
				String href = i.getText("@src",true);
				href = processResource(href,aResources,aHelper);
				i.setText("@src",href);
			}
			//find all images
			i=doc.iterator("//tr[@style and starts-with(@style,'background')]");
			while (i.hasNext())
			{	i.next();
				String href = "/introspect/pub/cross2.png";
				href = processResource(href,aResources,aHelper);
				i.setText("@style","background: url('"+href+"');");
			}

			URI dest = aHelper.getURI(XAHelper.OPERATOR);
			URI name=URI.create(CompoundURIdentifier.encode(aName)+".html");
			IURMeta meta = new AlwaysExpiredMeta("text/html", 0);
			IURRepresentation result = DOMXDAAspect.create(meta, doc);
			aHelper.setResource(dest.resolve(name), result);
		}
		catch (Exception e)
		{	System.out.println("failed");
		}
	}
	
	private String processResource(String aHref, Map aResources, XAHelper aHelper) throws Exception
	{	String result = (String)aResources.get(aHref);
		if (result==null)
		{	System.out.println("requesting resource "+aHref);
			try
			{
				IURRepresentation resource = aHelper.getResource(URI.create("ffcpl:"+aHref),IAspectBinaryStream.class);
				URI dest = aHelper.getURI(XAHelper.OPERATOR);
				int i1=aHref.lastIndexOf('.');
				String extension=null;
				if (i1>0) extension=aHref.substring(i1);
				if (extension==null)
				{
					String mime=resource.getMeta().getMimeType();
					//System.out.println("mime="+mime);
					if (mime.equals("text/css"))
					{	extension=".css";
					} else if (mime.equals("img/png"))
					{	extension=".png";
					} else if (mime.equals("img/gif"))
					{	extension=".gif";
					} else
					{	extension=".txt";
					}
				}
				URI name=URI.create("resources/resource"+aResources.size()+extension);
				IURMeta meta = new AlwaysExpiredMeta("text/xml", 0);
				aHelper.setResource(dest.resolve(name), resource);
				result = name.toString();
				aResources.put(aHref, result);
			} catch (Exception e)
			{	result="";
				aResources.put(aHref, result);
			}
		}
		return result;
	}
}
