// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2010 Konrad Twardowski

#include "test.h"

#include "../config.h"
#include "../udialog.h"
#include "../utils.h"

#include <QFormLayout>

#ifdef KS_KF5
	#include <KMessageBox>
#endif // KS_KF5

// TestAction

// public

TestAction::TestAction() :
	Action(i18n("Show Message (no shutdown)"), "dialog-ok", "test")
{
	setCanBookmark(true);
	setCommandLineOption({ "test" });
	setVisibleInMainMenu(false);
	setVisibleInSystemTrayMenu(false);

	// TEST: setEnabled(false, "Test", InfoWidget::Type::Info);
}

void TestAction::initContainerWidget() {
	m_textEdit = new QPlainTextEdit(m_defaultText);
	m_textEdit->setFixedHeight(70_px);
	m_textEdit->setPlaceholderText(i18n("Enter a message"));

	m_beepCheckBox = new QCheckBox(i18n("Beep Sound"));
	m_beepCheckBox->setChecked(m_defaultBeep);
	connect(m_beepCheckBox, &QCheckBox::toggled, [this](bool checked) {
		if (checked)
			doBeep();
	});

	auto *layout = makeFormLayout();
	layout->addRow(i18n("Text:"), m_textEdit);
	layout->addRow(m_beepCheckBox);
}

bool TestAction::onAction() {
	if ((m_beepCheckBox != nullptr) && m_beepCheckBox->isChecked())
		doBeep();

	QString text = (m_textEdit != nullptr) ? m_textEdit->toPlainText() : "";
	text = text.trimmed();

	if (text.isEmpty())
		text = Utils::makeHTML("<h1 style=\"background-color: red; color: white\">" + i18n("Test") + "</h1>");

	#ifdef KS_KF5
	KMessageBox::information(nullptr, text); // with sound!
	#else
	UDialog::info(nullptr, text);
	#endif // KS_KF5
	
	return true;
}

void TestAction::readConfig() {
	m_defaultBeep = Config::readBool(configGroup(), "Beep", false);
	m_defaultText = Config::readString(configGroup(), "Text", "");
}

void TestAction::writeConfig() {
	if (m_beepCheckBox != nullptr)
		Config::writeBool(configGroup(), "Beep", m_beepCheckBox->isChecked());

	if (m_textEdit != nullptr)
		Config::writeString(configGroup(), "Text", m_textEdit->toPlainText());
}

// private:

void TestAction::doBeep() {
	QApplication::beep();
}
