/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.osgi.service.event.Event;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.ui.internal.MindMapMessages;

public class SaveCommandLabelUpdater
implements IPartListener,
IPropertyListener,
ICoreEventListener {
    private static final String DATA_ORIGINAL_TEXT = "SaveCommandLabelUpdater:OriginalText";
    private static final String DATA_ORIGINAL_TOOLTIP = "SaveCommandLabelUpdater:OriginalTooltip";
    @Inject
    private EModelService modelService;
    @Inject
    private Display display;
    private MWindow activeWindow = null;
    private IEditorPart activeEditor = null;
    private IWorkbook editingWorkbook = null;
    private ICoreEventRegistration metadataEventRegistration = null;

    private void updateSaveCommandLabel() {
        String tooltip;
        String text;
        if (this.activeWindow == null) {
            return;
        }
        if (this.editingWorkbook != null && SaveCommandLabelUpdater.isAutoGeneratingRevision(this.editingWorkbook)) {
            text = MindMapMessages.SaveNewRevision_text;
            tooltip = MindMapMessages.SaveNewRevision_tooltip;
        } else {
            text = null;
            tooltip = null;
        }
        MItem item = this.findItem((MUIElement)this.activeWindow.getMainMenu(), "save");
        if (item != null) {
            if (text == null) {
                if (item.getTransientData().containsKey(DATA_ORIGINAL_TEXT)) {
                    item.setLabel((String)item.getTransientData().get(DATA_ORIGINAL_TEXT));
                }
            } else {
                if (!item.getTransientData().containsKey(DATA_ORIGINAL_TEXT)) {
                    item.getTransientData().put(DATA_ORIGINAL_TEXT, item.getLabel());
                }
                item.setLabel(text);
            }
        }
        if ((item = this.findItem((MUIElement)this.activeWindow, "org.xmind.ui.toolbar.edit.save")) != null) {
            if (tooltip == null) {
                if (item.getTransientData().containsKey(DATA_ORIGINAL_TOOLTIP)) {
                    item.setTooltip((String)item.getTransientData().get(DATA_ORIGINAL_TOOLTIP));
                }
            } else {
                if (!item.getTransientData().containsKey(DATA_ORIGINAL_TOOLTIP)) {
                    item.getTransientData().put(DATA_ORIGINAL_TOOLTIP, item.getTooltip());
                }
                item.setTooltip(tooltip);
            }
        }
    }

    @Inject
    @Optional
    public void applicationStarted(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event, final @Optional MApplication app) {
        if (app == null) {
            return;
        }
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                MWindow window = (MWindow)app.getSelectedElement();
                SaveCommandLabelUpdater.this.setActiveWindow(window);
                SaveCommandLabelUpdater.this.updateSaveCommandLabel();
            }
        });
    }

    @Inject
    @Optional
    public void windowChanged(@EventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*") Event event) {
        Object selectedElement = event.getProperty("selectedElement");
        if (!(selectedElement instanceof MWindow)) {
            return;
        }
        this.setActiveWindow((MWindow)selectedElement);
        this.updateSaveCommandLabel();
    }

    public void partActivated(IWorkbenchPart part) {
        this.setActiveEditor(this.findActiveEditorFrom(part));
        this.updateSaveCommandLabel();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.setActiveEditor(this.findActiveEditorFrom(part));
        this.updateSaveCommandLabel();
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 258) {
            this.setEditingWorkbook(this.findWorkbookIn(this.activeEditor));
            this.updateSaveCommandLabel();
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        if ("Configurations/AutoRevisionGeneration".equals(event.getTarget()) && this.display != null) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    SaveCommandLabelUpdater.this.updateSaveCommandLabel();
                }
            });
        }
    }

    private void setActiveWindow(MWindow window) {
        if (window != this.activeWindow) {
            IWorkbenchWindow wbWindow;
            if (this.activeWindow != null && (wbWindow = (IWorkbenchWindow)this.activeWindow.getContext().get(IWorkbenchWindow.class)) != null) {
                wbWindow.getPartService().removePartListener((IPartListener)this);
            }
            this.activeWindow = window;
            if (this.activeWindow != null && (wbWindow = (IWorkbenchWindow)this.activeWindow.getContext().get(IWorkbenchWindow.class)) != null) {
                wbWindow.getPartService().addPartListener((IPartListener)this);
            }
        }
        this.setActiveEditor(this.findActiveEditorIn(this.activeWindow));
    }

    private void setActiveEditor(IEditorPart editor) {
        if (editor != this.activeEditor) {
            if (this.activeEditor != null) {
                this.activeEditor.removePropertyListener((IPropertyListener)this);
            }
            this.activeEditor = editor;
            if (this.activeEditor != null) {
                this.activeEditor.addPropertyListener((IPropertyListener)this);
            }
        }
        this.setEditingWorkbook(this.findWorkbookIn(editor));
    }

    private void setEditingWorkbook(IWorkbook workbook) {
        if (workbook != this.editingWorkbook) {
            if (this.metadataEventRegistration != null) {
                this.metadataEventRegistration.unregister();
                this.metadataEventRegistration = null;
            }
            this.editingWorkbook = workbook;
            if (this.editingWorkbook != null && this.editingWorkbook.getMeta() instanceof ICoreEventSource) {
                this.metadataEventRegistration = ((ICoreEventSource)this.editingWorkbook.getMeta()).registerCoreEventListener("metadata", (ICoreEventListener)this);
            }
        }
    }

    private IEditorPart findActiveEditorFrom(IWorkbenchPart referencePart) {
        if (referencePart == null) {
            return null;
        }
        IWorkbenchWindow window = referencePart.getSite().getWorkbenchWindow();
        return this.findActiveEditorIn(window);
    }

    private IEditorPart findActiveEditorIn(MWindow window) {
        if (window == null) {
            return null;
        }
        IWorkbenchWindow wbWindow = (IWorkbenchWindow)window.getContext().get(IWorkbenchWindow.class);
        return this.findActiveEditorIn(wbWindow);
    }

    private IEditorPart findActiveEditorIn(IWorkbenchWindow window) {
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return page.getActiveEditor();
    }

    private IWorkbook findWorkbookIn(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        return (IWorkbook)editor.getAdapter(IWorkbook.class);
    }

    private MItem findItem(MUIElement rootElement, String id) {
        if (this.modelService == null || rootElement == null) {
            return null;
        }
        MUIElement element = this.modelService.find(id, rootElement);
        if (!(element instanceof MItem)) {
            return null;
        }
        return (MItem)element;
    }

    private static final boolean isAutoGeneratingRevision(IWorkbook workbook) {
        String value = workbook.getMeta().getValue("Configurations/AutoRevisionGeneration");
        return value == null || "Yes".equalsIgnoreCase(value);
    }
}

