/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.mindmap;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ICacheManager;
import org.xmind.ui.mindmap.IInfoItemContributor;
import org.xmind.ui.mindmap.IInfoItemPart;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

public abstract class AbstractInfoItemContributor
implements IInfoItemContributor {
    private static final String CACHE_INFORITEM_EVENT_REG = "org.xmind.ui.cache.inforItem.eventReg";
    private static int NUMBER = 0;
    private final String regCacheKey = "org.xmind.ui.cache.inforItem.eventReg" + NUMBER;

    public AbstractInfoItemContributor() {
        ++NUMBER;
    }

    @Override
    public boolean isModified(ITopicPart topicPart, ITopic topic, IAction action) {
        return true;
    }

    @Override
    public void fillContextMenu(IInfoItemPart part) {
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public String getDefaultMode() {
        return null;
    }

    @Override
    public String getAvailableModes() {
        return null;
    }

    @Override
    public String getCardLabel() {
        return null;
    }

    @Override
    public String getContent(ITopic topic) {
        return null;
    }

    @Override
    public boolean isCardModeAvailable(ITopic topic, ITopicPart topicPart) {
        return false;
    }

    protected boolean isIconTipOnly(ITopicPart part) {
        IBranchPart branch = MindMapUtils.findBranch((IPart)part);
        if (branch != null) {
            IStyleSelector ss = StyleUtils.getStyleSelector(branch);
            String value = ss.getStyleValue((IGraphicalPart)branch, "iconTip-only");
            return Boolean.TRUE.toString().equals(value);
        }
        return false;
    }

    @Override
    public void topicActivated(final IInfoPart infoPart) {
        ICacheManager cacheManager = (ICacheManager)infoPart.getAdapter(ICacheManager.class);
        if (cacheManager != null) {
            ITopic topic = infoPart.getTopic();
            CoreEventRegister register = new CoreEventRegister((Object)topic, new ICoreEventListener(){

                public void handleCoreEvent(final CoreEvent event) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractInfoItemContributor.this.handleTopicEvent(infoPart, event);
                        }
                    });
                }
            });
            this.registerTopicEvent(infoPart.getTopicPart(), topic, (ICoreEventRegister)register);
            if (register.hasRegistration()) {
                cacheManager.setCache(this.regCacheKey, register);
            }
        }
    }

    @Override
    public void topicDeactivated(IInfoPart infoPart) {
        Object cache = MindMapUtils.flushCache((IPart)infoPart, this.regCacheKey);
        if (cache instanceof ICoreEventRegister) {
            ((ICoreEventRegister)cache).unregisterAll();
        }
    }

    @Override
    public void topicActivated(final ITopicPart topicPart) {
        ICacheManager cacheManager = (ICacheManager)topicPart.getAdapter(ICacheManager.class);
        if (cacheManager != null) {
            ITopic topic = topicPart.getTopic();
            CoreEventRegister register = new CoreEventRegister((Object)topic, new ICoreEventListener(){

                public void handleCoreEvent(final CoreEvent event) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractInfoItemContributor.this.handleTopicEvent(topicPart, event);
                        }
                    });
                }
            });
            this.registerTopicEvent(topicPart, topic, (ICoreEventRegister)register);
            if (register.hasRegistration()) {
                cacheManager.setCache(this.regCacheKey, register);
            }
        }
    }

    @Override
    public void topicDeactivated(ITopicPart topicPart) {
        Object cache = MindMapUtils.flushCache((IPart)topicPart, this.regCacheKey);
        if (cache instanceof ICoreEventRegister) {
            ((ICoreEventRegister)cache).unregisterAll();
        }
    }

    protected abstract void registerTopicEvent(ITopicPart var1, ITopic var2, ICoreEventRegister var3);

    protected abstract void handleTopicEvent(IInfoPart var1, CoreEvent var2);

    protected abstract void handleTopicEvent(ITopicPart var1, CoreEvent var2);

    @Override
    public List<IAction> getPopupMenuActions(ITopicPart topicPart, ITopic topic) {
        return Collections.emptyList();
    }
}

