/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.structures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.xmind.ui.internal.spreadsheet.structures.Cell2;
import org.xmind.ui.internal.spreadsheet.structures.Chart2;
import org.xmind.ui.internal.spreadsheet.structures.RowHead;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Row2
implements Comparable<Row2> {
    private Chart2 ownedChart;
    private RowHead head;
    private List<Cell2> cells = new ArrayList<Cell2>();
    private int prefCellHeight = -1;
    private Integer y = null;
    private Integer height = null;

    public Row2(Chart2 ownedChart, RowHead head) {
        Assert.isNotNull((Object)((Object)ownedChart));
        Assert.isNotNull((Object)head);
        this.ownedChart = ownedChart;
        this.head = head;
    }

    public Chart2 getOwnedChart() {
        return this.ownedChart;
    }

    public RowHead getHead() {
        return this.head;
    }

    void addCell(Cell2 cell) {
        this.cells.add(cell);
    }

    void removeCell(Cell2 cell) {
        this.cells.remove((Object)cell);
    }

    public List<Cell2> getCells() {
        return this.cells;
    }

    @Override
    public int compareTo(Row2 o) {
        return this.getOwnedChart().getPrefRowOrder().compareRows(this.getHead(), o.getHead());
    }

    public int getPrefCellHeight() {
        if (this.prefCellHeight < 0) {
            this.prefCellHeight = this.calcPrefCellHeight();
        }
        return this.prefCellHeight;
    }

    private int calcPrefCellHeight() {
        int h = this.head.getPrefSize().height;
        for (Cell2 cell : this.cells) {
            h = Math.max(h, cell.getPrefContentSize().height);
        }
        return h;
    }

    public int getPrefHeight() {
        return Math.max(this.head.getPrefSize().height, this.getPrefCellHeight());
    }

    public Cell2 getPreviousCell(Cell2 cell) {
        int index = this.getCellIndex(cell);
        if (index > 0) {
            return this.cells.get(index - 1);
        }
        return null;
    }

    public Cell2 getNextCell(Cell2 cell) {
        int index = this.getCellIndex(cell);
        if (index < this.cells.size() - 1) {
            return this.cells.get(index + 1);
        }
        return null;
    }

    public int getCellIndex(Cell2 cell) {
        return this.cells.indexOf((Object)cell);
    }

    public int getTop() {
        this.ensurePosition();
        return this.y;
    }

    public int getHeight() {
        this.ensurePosition();
        return this.height;
    }

    private void ensurePosition() {
        if (this.y != null && this.height != null) {
            return;
        }
        int lineWidth = this.getOwnedChart().getLineWidth();
        Row2 prev = this.getOwnedChart().getPreviousRow(this);
        if (prev != null) {
            this.y = prev.getTop() + prev.getHeight() + lineWidth;
        } else {
            int intY = this.getOwnedChart().getTitle().getTopicPart().getFigure().getBounds().bottom() + lineWidth;
            if (this.getOwnedChart().getTitle().getInfoPart() != null) {
                intY += this.getOwnedChart().getTitle().getInfoPart().getFigure().getBounds().height;
            }
            if (this.getOwnedChart().hasColumns()) {
                intY += this.getOwnedChart().getColHeadHeight() + lineWidth + this.getOwnedChart().getMinorSpacing();
            }
            this.y = intY;
        }
        int headHeight = this.getHead().getPrefSize().height;
        int cellHeight = 0;
        for (Cell2 cell : this.cells) {
            cellHeight = Math.max(cellHeight, cell.getContentHeight());
        }
        int h = Math.max(headHeight, cellHeight);
        this.height = h + this.getOwnedChart().getMinorSpacing();
    }

    public String toString() {
        return this.getHead().toString();
    }
}

