/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.image;

import java.util.List;
import java.util.Stack;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.xmind.gef.draw2d.graphics.ScaledGraphics;
import org.xmind.gef.image.IExportAreaProvider;
import org.xmind.gef.image.IExportSourceProvider;
import org.xmind.gef.image.IRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigureRenderer
implements IRenderer {
    private IFigure[] figures = null;
    private Rectangle bounds = null;
    private double scale = -1.0;

    public void init(IExportSourceProvider source, IExportAreaProvider area) {
        this.setFigures(source.getContents());
        this.setBounds(area.getExportArea());
        this.setScale(area.getScale());
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setFigures(IFigure[] figures) {
        this.figures = figures;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public double getScale() {
        return this.scale;
    }

    public IFigure[] getFigures() {
        return this.figures;
    }

    @Override
    public void render(GC gc) {
        this.render(gc, (Image)null);
    }

    /*
     * Unable to fully structure code
     */
    public void render(GC gc, Image watermark) {
        if (this.figures == null) {
            return;
        }
        graphicsStack = new Stack<Graphics>();
        baseGraphics = new SWTGraphics(gc);
        graphicsStack.push((Graphics)baseGraphics);
        this.createGraphics((Graphics)baseGraphics, graphicsStack);
        graphics = graphicsStack.peek();
        try {
            graphics.pushState();
            try {
                i = 0;
                while (i < this.figures.length) {
                    figure = this.figures[i];
                    figure.paint(graphics);
                    graphics.restoreState();
                    ++i;
                }
                this.drawWatermarkImage(graphics, watermark);
                if (true) ** GOTO lbl31
            }
            finally {
                graphics.popState();
            }
        }
        catch (Throwable var9_9) {
            ** while (!graphicsStack.isEmpty())
        }
lbl-1000:
        // 1 sources

        {
            graphicsStack.pop().dispose();
            continue;
        }
lbl28:
        // 1 sources

        throw var9_9;
        do {
            graphicsStack.pop().dispose();
lbl31:
            // 2 sources

        } while (!graphicsStack.isEmpty());
    }

    private void drawWatermarkImage(Graphics graphics, Image watermark) {
        if (watermark == null || watermark.isDisposed()) {
            return;
        }
        graphics.setAlpha(25);
        double scale = this.getScale() > 0.0 ? this.getScale() : 1.0;
        int x = this.bounds.x + this.bounds.width - (int)((double)watermark.getBounds().width * scale);
        int y = this.bounds.y + this.bounds.height - (int)((double)watermark.getBounds().height * scale);
        graphics.drawImage(watermark, x, y);
    }

    /*
     * Unable to fully structure code
     */
    public void render(GC gc, Point origin) {
        if (this.figures == null) {
            return;
        }
        graphicsStack = new Stack<Graphics>();
        baseGraphics = new SWTGraphics(gc);
        graphicsStack.push((Graphics)baseGraphics);
        this.createGraphics((Graphics)baseGraphics, graphicsStack);
        graphics = graphicsStack.peek();
        try {
            graphics.pushState();
            try {
                if (origin != null) {
                    graphics.translate(origin.x, origin.y);
                }
                i = 0;
                while (i < this.figures.length) {
                    figure = this.figures[i];
                    figure.paint(graphics);
                    ++i;
                }
                if (true) ** GOTO lbl31
            }
            finally {
                graphics.popState();
            }
        }
        catch (Throwable var9_9) {
            ** while (!graphicsStack.isEmpty())
        }
lbl-1000:
        // 1 sources

        {
            graphicsStack.pop().dispose();
            continue;
        }
lbl28:
        // 1 sources

        throw var9_9;
        do {
            graphicsStack.pop().dispose();
lbl31:
            // 2 sources

        } while (!graphicsStack.isEmpty());
    }

    protected void createGraphics(Graphics graphics, Stack<Graphics> stack) {
        if (this.bounds != null) {
            graphics.translate(-this.bounds.x, -this.bounds.y);
        }
        if (this.scale > 0.0) {
            if (ScaledGraphics.SCALED_GRAPHICS_ENABLED) {
                ScaledGraphics scaledGraphics = new ScaledGraphics(graphics);
                scaledGraphics.scale(this.scale);
                stack.push(scaledGraphics);
                graphics = scaledGraphics;
            } else {
                graphics.scale(this.scale);
            }
        }
    }

    protected Graphics addScaledGraphics(Graphics graphics, List<Graphics> additionalGraphics) {
        return graphics;
    }
}

