/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.internal.svgsupport.SVGShape;

public final class SVGCircleShape
extends SVGShape {
    private PrecisionPoint origin;
    private float r;

    SVGCircleShape() {
    }

    public SVGCircleShape(double x, double y, float r) {
        this.origin = new PrecisionPoint(x, y);
        this.r = r;
    }

    @Override
    public void parse(Element implemention, SVGShape parent) {
        super.parse(implemention, parent);
        this.parseCircle(implemention, parent);
    }

    private void parseCircle(Element implemention, SVGShape parent) {
        float x = this.getFloatAttribute(implemention, "cx");
        float y = this.getFloatAttribute(implemention, "cy");
        this.r = this.getFloatAttribute(implemention, "r");
        this.origin = new PrecisionPoint((double)(x - this.r), (double)(y - this.r));
    }

    @Override
    Path generatePath(Display device) {
        Path path = new Path((Device)device);
        path.addArc(new PrecisionRectangle(this.origin.x, this.origin.y, (double)(2.0f * this.r), (double)(2.0f * this.r)), 0.0f, 360.0f);
        return path;
    }

    @Override
    PrecisionRectangle generateRectangle() {
        return new PrecisionRectangle(this.origin.x, this.origin.y, (double)(2.0f * this.r), (double)(2.0f * this.r));
    }

    @Override
    protected SVGShape clone() {
        SVGCircleShape circle = new SVGCircleShape();
        circle.setInfo(this.getInfo().clone());
        circle.origin = this.origin;
        circle.r = this.r;
        return circle;
    }

    public boolean equals(Object obj) {
        SVGCircleShape circle;
        if (this == obj) {
            return true;
        }
        return obj instanceof SVGCircleShape && (circle = (SVGCircleShape)obj).getInfo().equals(this.getInfo()) && this.origin.equals((Object)circle.origin) && this.r == circle.r;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.getInfo().hashCode();
        result = result * 31 + (int)Double.doubleToLongBits(this.origin.x);
        result = result * 31 + (int)Double.doubleToLongBits(this.origin.y);
        result = result * 31 + (int)Double.doubleToLongBits(this.r);
        return result;
    }

    public String toString() {
        return "SVGCircle( origin:" + this.origin.toString() + "  " + this.getInfo().toString() + " )";
    }
}

