/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.de.erichseifert.vectorgraphics2d.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class DataUtils {
    protected DataUtils() {
        throw new UnsupportedOperationException();
    }

    public static <K, V> Map<K, V> map(K[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Cannot create a Map: The number of keys and values differs.");
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        int i = 0;
        while (i < keys.length) {
            K key = keys[i];
            V value = values[i];
            map.put(key, value);
            ++i;
        }
        return map;
    }

    public static String join(String separator, List<?> elements) {
        if (elements == null || elements.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(elements.size() * 3);
        int i = 0;
        for (Object elem : elements) {
            if (i++ > 0) {
                sb.append(separator);
            }
            sb.append(DataUtils.format(elem));
        }
        return sb.toString();
    }

    public static String join(String separator, Object ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        return DataUtils.join(separator, Arrays.asList(elements));
    }

    public static String join(String separator, float ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        ArrayList<Float> list = new ArrayList<Float>(elements.length);
        float[] fArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Float elem = Float.valueOf(fArray[n2]);
            list.add(elem);
            ++n2;
        }
        return DataUtils.join(separator, list);
    }

    public static String join(String separator, double ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        ArrayList<Double> list = new ArrayList<Double>(elements.length);
        double[] dArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Double elem = dArray[n2];
            list.add(elem);
            ++n2;
        }
        return DataUtils.join(separator, list);
    }

    public static int max(int ... values) {
        int max = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        return max;
    }

    public static void transfer(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static String format(Number number) {
        String formatted = Double.toString(number.doubleValue()).replaceAll("\\.0+$", "").replaceAll("(\\.[0-9]*[1-9])0+$", "$1");
        return formatted;
    }

    public static String format(Object obj) {
        if (obj instanceof Number) {
            return DataUtils.format((Number)obj);
        }
        return obj.toString();
    }
}

