/* wptHotkey.cpp - Systemwide hotkeys
 *	Copyright (C) 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#include <windows.h>

#include "wptHotkey.h"
#include "wptGPG.h"
#include "wptRegistry.h"
#include "wptErrors.h"
#include "wptNLS.h"
#include "wptTypes.h"

static int err_hotkey = 0;

const char *
hotkeys_strerror (void)
{
    switch (err_hotkey) {
    case  0: return NULL;
    case  1: return _("Clipboard Encrypt (ALT+CTRL+E)");
    case  2: return _("Clipboard Decrypt/Verify (ALT+CTRL+D)");
    case  3: return _("Clipboard Sign (ALT+CTRL+S)");
    case  4: return _("Clipboard Sign Encrypt (ALT+CTRL+B)");
    case  5: return _("Current Window Encrypt (ALT+SHIFT+E)");
    case  6: return _("Current Window Decrypt/Verify (ALT+SHIFT+D)");
    case  7: return _("Current Window Sign (ALT+SHIFT+S)");
    case  8: return _("Current Window Sign Encrypt (ALT+SHIFT+B");
    default: return _("Unknown Hotkey");
    }
    return NULL;
}


int 
hotkeys_register (HWND wnd)
{
    int j = 0, rc = 0;
	
    err_hotkey = 0; /* reset */
    for (j=0; wpt_hotkeys[j].id != 0; j++) {
	if (wpt_hotkeys[j].enabled) {
	    rc = hotkey_register_single (wnd, &wpt_hotkeys[j]);
	    if (rc) {
		err_hotkey = j+1;
		break;	
	    }
	}	
    }

    return rc;
} /* hotkeys_register */


int 
hotkeys_unregister (HWND wnd)
{
    int j = 0, rc = 0;	

    for (j=0; wpt_hotkeys[j].id != 0; j++) {
	if (wpt_hotkeys[j].enabled) {
	    rc = hotkey_unregister_single (wnd, &wpt_hotkeys[j]);
	    if (rc)
		break;
	}
    }

    return rc;
} /* hotkeys_unregister */


int
hotkey_register_single (HWND wnd, hotkey_t hk)
{
    int rc, keymod;

    if (!hk->enabled)
	return 0;
	
    if (hk->alt_ctrl)
	keymod = MOD_CONTROL | MOD_ALT;
    else if (hk->alt_shift)
	keymod = MOD_ALT | MOD_SHIFT;

    rc = RegisterHotKey (wnd, hk->id, keymod, hk->key);
    if (!rc)
	return WPTERR_HOTKEY;
    return 0;
} /* hotkey_register_single */

int
hotkey_unregister_single (HWND wnd, hotkey_t hk)
{
    int rc = UnregisterHotKey (wnd, hk->id);
    return rc==0? WPTERR_HOTKEY: 0;
} /* hotkey_unregister_single */


void
hotkeys_modify (void)
{
    int i;

    for (i = 0; wpt_hotkeys[i].id; i++) {
	if( reg_hotkeys[i].enabled ) {
	    wpt_hotkeys[i].key = reg_hotkeys[i].key[0];
	    wpt_hotkeys[i].enabled = 1;
	}	
    }
} /* hotkeys_modify */


void
hotkey_disable (reg_hotkey_t rhk)
{
    strcpy (rhk->key, " ");
    rhk->enabled = 0;
} /* hotkey_disable */


void
hotkey_enable (reg_hotkey_t rhk, const char * key)
{
    if (strlen (key) > 2)
	BUG (0);
    strcpy (rhk->key, key);
    rhk->enabled = 1;
} /* hotkey_enable */