/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.presentation;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IDetailPaneFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.lsp4e.debug.breakpoints.DSPLineBreakpoint;
import org.eclipse.lsp4e.debug.presentation.DSPBreakpointDetailPane;

public class DSPBreakpointDetailPaneFactory
implements IDetailPaneFactory {
    static final String PANE_ID = "org.eclipse.lsp4e.debug.detailPane.breakpoint";
    static final String PANE_NAME = "LSP4E Breakpoint";
    static final String PANE_DESCRIPTION = "Edit condition and column for LSP4E breakpoints";

    public Set<String> getDetailPaneTypes(IStructuredSelection selection) {
        return this.isDSPBreakpointSelection(selection) ? Set.of(PANE_ID) : Collections.emptySet();
    }

    public @Nullable String getDefaultDetailPane(IStructuredSelection selection) {
        return this.isDSPBreakpointSelection(selection) ? PANE_ID : null;
    }

    public @Nullable IDetailPane createDetailPane(String paneID) {
        return PANE_ID.equals(paneID) ? new DSPBreakpointDetailPane() : null;
    }

    public @Nullable String getDetailPaneName(String id) {
        return PANE_ID.equals(id) ? PANE_NAME : null;
    }

    public @Nullable String getDetailPaneDescription(String id) {
        return PANE_ID.equals(id) ? PANE_DESCRIPTION : null;
    }

    private boolean isDSPBreakpointSelection(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object element = selection.getFirstElement();
        if (element == null) {
            return false;
        }
        return element instanceof DSPLineBreakpoint || Adapters.adapt((Object)element, IBreakpoint.class) instanceof DSPLineBreakpoint;
    }
}

