/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.coap.server.templates;

import com.google.common.base.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.examples.coap.CoAPUtils;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.functionblock.Event;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CoAPServerTemplate
implements ITemplate<InformationModel> {
    private String className;
    private String interfaceName;
    private String packageName;
    private String imports;

    public CoAPServerTemplate(String className, String classPackage, String interfaceName, String imports) {
        this.className = className;
        this.packageName = classPackage;
        this.interfaceName = interfaceName;
        this.imports = imports;
    }

    public String getContent(InformationModel im, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)"*****************************************************************************************");
        _builder.newLine();
        _builder.append((Object)"* The present code has been generated by the Eclipse Vorto CoAP Code Generator.");
        _builder.newLine();
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"* The basis for the generation was the Information Model which is uniquely identified by:");
        _builder.newLine();
        _builder.append((Object)"* Name:\t\t\t\t");
        String _name = im.getName();
        _builder.append((Object)_name, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"* Namespace:\t");
        String _namespace = im.getNamespace();
        _builder.append((Object)_namespace, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"* Version:\t\t");
        String _version = im.getVersion();
        _builder.append((Object)_version, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*****************************************************************************************");
        _builder.newLine();
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"package ");
        _builder.append((Object)this.packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import ");
        _builder.append((Object)this.imports, "");
        _builder.append((Object)".*;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import org.eclipse.californium.core.CoapServer;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _firstUpper = StringExtensions.toFirstUpper((String)this.className);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" extends CoapServer {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* Constructor for a new CoAP server providing resources which are specified ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* in the given Information Model.");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)this.className);
        _builder.append((Object)_firstUpper_1, "\t");
        _builder.append((Object)"(");
        _builder.append((Object)this.interfaceName, "\t");
        _builder.append((Object)" handler) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final boolean VISIBLE = true;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final boolean NOT_VISIBLE = false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final boolean GET = true;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final boolean PUT = true;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final boolean POST = true;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final boolean DELETE = true;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final boolean DISCOVER = true;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final boolean OBSERVE = true;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList _properties = im.getProperties();
        EMap<FunctionblockModel, EList<FunctionblockProperty>> map = CoAPUtils.sortByPropertyType((EList<FunctionblockProperty>)_properties);
        _builder.newLineIfNotEmpty();
        Set _keySet = map.keySet();
        for (FunctionblockModel resource : _keySet) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"add(new Link(\"");
            String _name_1 = resource.getName();
            String _firstLower = StringExtensions.toFirstLower((String)_name_1);
            _builder.append((Object)_firstLower, "\t\t");
            _builder.append((Object)"\"){{");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"setVisible(VISIBLE);");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"getAttributes().addAttribute(\"title\", \"");
            String _description = resource.getDescription();
            _builder.append((Object)_description, "\t\t\t\t");
            _builder.append((Object)" \");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}}");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            EList instances = (EList)map.get((Object)resource);
            _builder.newLineIfNotEmpty();
            for (FunctionblockProperty instance : instances) {
                FunctionblockModel _type_4;
                FunctionBlock _functionblock_4;
                Status _status;
                boolean _notEquals_2;
                FunctionblockModel _type_2;
                FunctionBlock _functionblock_2;
                EList _events;
                boolean _notEquals_1;
                boolean _notEquals;
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)".add(new Link(\"");
                String _name_2 = instance.getName();
                String _firstLower_1 = StringExtensions.toFirstLower((String)_name_2);
                _builder.append((Object)_firstLower_1, "\t\t\t");
                _builder.append((Object)"\"){{");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"setVisible(NOT_VISIBLE);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"getAttributes().addAttribute(\"title\", \"");
                String _description_1 = instance.getDescription();
                _builder.append((Object)_description_1, "\t\t\t\t\t");
                _builder.append((Object)" \");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}}");
                _builder.newLine();
                FunctionblockModel _type = instance.getType();
                FunctionBlock _functionblock = _type.getFunctionblock();
                EList _operations = _functionblock.getOperations();
                boolean bl = _notEquals = !Objects.equal((Object)_operations, null);
                if (_notEquals) {
                    FunctionblockModel _type_1 = instance.getType();
                    FunctionBlock _functionblock_1 = _type_1.getFunctionblock();
                    EList _operations_1 = _functionblock_1.getOperations();
                    for (Operation operation : _operations_1) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)".add(new Resource(\"");
                        String _name_3 = operation.getName();
                        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_3);
                        _builder.append((Object)_firstLower_2, "\t\t\t");
                        _builder.append((Object)"\",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"new Resource.Configuration(false, false, POST, false, false, false),");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"handler){{");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"setVisible(NOT_VISIBLE);");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"getAttributes().addAttribute(\"title\", \"");
                        String _description_2 = operation.getDescription();
                        _builder.append((Object)_description_2, "\t\t\t\t\t");
                        _builder.append((Object)" \");");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"}})");
                        _builder.newLine();
                    }
                }
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)(_events = (_functionblock_2 = (_type_2 = instance.getType()).getFunctionblock()).getEvents()), null);
                if (_notEquals_1) {
                    FunctionblockModel _type_3 = instance.getType();
                    FunctionBlock _functionblock_3 = _type_3.getFunctionblock();
                    EList _events_1 = _functionblock_3.getEvents();
                    for (Event event : _events_1) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)".add(new Resource(\"");
                        String _name_4 = event.getName();
                        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_4);
                        _builder.append((Object)_firstLower_3, "\t\t\t");
                        _builder.append((Object)"\",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"new Resource.Configuration(false, false, false, false, false, OBSERVE),");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"handler){{");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"setVisible(NOT_VISIBLE);");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"getAttributes().addAttribute(\"obs\", \"\");");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t\t");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"}})");
                        _builder.newLine();
                    }
                }
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)(_status = (_functionblock_4 = (_type_4 = instance.getType()).getFunctionblock()).getStatus()), null);
                if (_notEquals_2) {
                    FunctionblockModel _type_5 = instance.getType();
                    FunctionBlock _functionblock_5 = _type_5.getFunctionblock();
                    Status _status_1 = _functionblock_5.getStatus();
                    EList _properties_1 = _status_1.getProperties();
                    for (Property status : _properties_1) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)".add(new Resource(\"");
                        String _name_5 = status.getName();
                        String _firstLower_4 = StringExtensions.toFirstLower((String)_name_5);
                        _builder.append((Object)_firstLower_4, "\t\t\t");
                        _builder.append((Object)"\",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        String _resourceConfiguration = this.getResourceConfiguration(status);
                        _builder.append((Object)_resourceConfiguration, "\t\t\t\t");
                        _builder.append((Object)",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"handler){{");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"setVisible(NOT_VISIBLE);");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"getAttributes().addAttribute(\"title\", \"");
                        String _description_3 = status.getDescription();
                        _builder.append((Object)_description_3, "\t\t\t\t\t");
                        _builder.append((Object)" \");");
                        _builder.newLineIfNotEmpty();
                        boolean _isEventable = Utils.isEventable((Property)status);
                        if (_isEventable) {
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"getAttributes().addAttribute(\"obs\", \"\");");
                            _builder.newLine();
                        }
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"}})");
                        _builder.newLine();
                    }
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)")");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)");");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private String getResourceConfiguration(Property property) {
        boolean _isEventable;
        boolean _isWritable;
        String readable = "false";
        String writeable = "false";
        String eventable = "false";
        String result = "new Resource.Configuration(";
        boolean _isReadable = Utils.isReadable((Property)property);
        if (_isReadable) {
            readable = "GET";
        }
        if (_isWritable = Utils.isWritable((Property)property)) {
            writeable = "PUT";
        }
        if (_isEventable = Utils.isEventable((Property)property)) {
            eventable = "OBSERVE";
        }
        return String.valueOf(result) + readable + ", " + writeable + ", false, false, false, " + eventable + ")";
    }
}

