/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import java.net.SocketAddress;

public final class PartialPooledByteBufAllocator
implements ByteBufAllocator {
    private static final ByteBufAllocator POOLED = new PooledByteBufAllocator(true);
    private static final ByteBufAllocator UNPOOLED = new UnpooledByteBufAllocator(false);
    public static final PartialPooledByteBufAllocator INSTANCE = new PartialPooledByteBufAllocator();

    private PartialPooledByteBufAllocator() {
    }

    public ByteBuf buffer() {
        return UNPOOLED.heapBuffer();
    }

    public ByteBuf buffer(int initialCapacity) {
        return UNPOOLED.heapBuffer(initialCapacity);
    }

    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        return UNPOOLED.heapBuffer(initialCapacity, maxCapacity);
    }

    public ByteBuf ioBuffer() {
        return POOLED.directBuffer();
    }

    public ByteBuf ioBuffer(int initialCapacity) {
        return POOLED.directBuffer(initialCapacity);
    }

    public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
        return POOLED.directBuffer(initialCapacity, maxCapacity);
    }

    public ByteBuf heapBuffer() {
        return UNPOOLED.heapBuffer();
    }

    public ByteBuf heapBuffer(int initialCapacity) {
        return UNPOOLED.heapBuffer(initialCapacity);
    }

    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        return UNPOOLED.heapBuffer(initialCapacity, maxCapacity);
    }

    public ByteBuf directBuffer() {
        return POOLED.directBuffer();
    }

    public ByteBuf directBuffer(int initialCapacity) {
        return POOLED.directBuffer(initialCapacity);
    }

    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        return POOLED.directBuffer(initialCapacity, maxCapacity);
    }

    public CompositeByteBuf compositeBuffer() {
        return UNPOOLED.compositeHeapBuffer();
    }

    public CompositeByteBuf compositeBuffer(int maxNumComponents) {
        return UNPOOLED.compositeHeapBuffer(maxNumComponents);
    }

    public CompositeByteBuf compositeHeapBuffer() {
        return UNPOOLED.compositeHeapBuffer();
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        return UNPOOLED.compositeHeapBuffer(maxNumComponents);
    }

    public CompositeByteBuf compositeDirectBuffer() {
        return POOLED.compositeDirectBuffer();
    }

    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return POOLED.compositeDirectBuffer();
    }

    public boolean isDirectBufferPooled() {
        return true;
    }

    public static ChannelHandlerContext forceDirectAllocator(ChannelHandlerContext ctx) {
        return new PooledChannelHandlerContext(ctx);
    }

    private static final class ForceDirectPoooledByteBufAllocator
    implements ByteBufAllocator {
        static ByteBufAllocator INSTANCE = new ForceDirectPoooledByteBufAllocator();

        private ForceDirectPoooledByteBufAllocator() {
        }

        public ByteBuf buffer() {
            return INSTANCE.directBuffer();
        }

        public ByteBuf buffer(int initialCapacity) {
            return INSTANCE.directBuffer(initialCapacity);
        }

        public ByteBuf buffer(int initialCapacity, int maxCapacity) {
            return INSTANCE.directBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf ioBuffer() {
            return INSTANCE.directBuffer();
        }

        public ByteBuf ioBuffer(int initialCapacity) {
            return INSTANCE.directBuffer(initialCapacity);
        }

        public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
            return INSTANCE.directBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf heapBuffer() {
            return INSTANCE.heapBuffer();
        }

        public ByteBuf heapBuffer(int initialCapacity) {
            return INSTANCE.heapBuffer(initialCapacity);
        }

        public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
            return INSTANCE.heapBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf directBuffer() {
            return INSTANCE.directBuffer();
        }

        public ByteBuf directBuffer(int initialCapacity) {
            return INSTANCE.directBuffer(initialCapacity);
        }

        public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
            return INSTANCE.directBuffer(initialCapacity, maxCapacity);
        }

        public CompositeByteBuf compositeBuffer() {
            return INSTANCE.compositeBuffer();
        }

        public CompositeByteBuf compositeBuffer(int maxNumComponents) {
            return INSTANCE.compositeBuffer(maxNumComponents);
        }

        public CompositeByteBuf compositeHeapBuffer() {
            return INSTANCE.compositeHeapBuffer();
        }

        public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
            return INSTANCE.compositeHeapBuffer(maxNumComponents);
        }

        public CompositeByteBuf compositeDirectBuffer() {
            return INSTANCE.compositeDirectBuffer();
        }

        public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
            return INSTANCE.compositeDirectBuffer(maxNumComponents);
        }

        public boolean isDirectBufferPooled() {
            return INSTANCE.isDirectBufferPooled();
        }
    }

    private static final class PooledChannelHandlerContext
    implements ChannelHandlerContext {
        private final ChannelHandlerContext ctx;

        PooledChannelHandlerContext(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public Channel channel() {
            return this.ctx.channel();
        }

        public EventExecutor executor() {
            return this.ctx.executor();
        }

        public String name() {
            return this.ctx.name();
        }

        public ChannelHandler handler() {
            return this.ctx.handler();
        }

        public boolean isRemoved() {
            return this.ctx.isRemoved();
        }

        public ChannelHandlerContext fireChannelRegistered() {
            this.ctx.fireChannelRegistered();
            return this;
        }

        @Deprecated
        public ChannelHandlerContext fireChannelUnregistered() {
            this.ctx.fireChannelUnregistered();
            return this;
        }

        public ChannelHandlerContext fireChannelActive() {
            this.ctx.fireChannelActive();
            return this;
        }

        public ChannelHandlerContext fireChannelInactive() {
            this.ctx.fireChannelInactive();
            return this;
        }

        public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
            this.ctx.fireExceptionCaught(cause);
            return this;
        }

        public ChannelHandlerContext fireUserEventTriggered(Object event) {
            this.ctx.fireUserEventTriggered(event);
            return this;
        }

        public ChannelHandlerContext fireChannelRead(Object msg) {
            this.ctx.fireChannelRead(msg);
            return this;
        }

        public ChannelHandlerContext fireChannelReadComplete() {
            this.ctx.fireChannelReadComplete();
            return this;
        }

        public ChannelHandlerContext fireChannelWritabilityChanged() {
            this.ctx.fireChannelWritabilityChanged();
            return this;
        }

        public ChannelFuture bind(SocketAddress localAddress) {
            return this.ctx.bind(localAddress);
        }

        public ChannelFuture connect(SocketAddress remoteAddress) {
            return this.ctx.connect(remoteAddress);
        }

        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
            return this.ctx.connect(remoteAddress, localAddress);
        }

        public ChannelFuture disconnect() {
            return this.ctx.disconnect();
        }

        public ChannelFuture close() {
            return this.ctx.close();
        }

        @Deprecated
        public ChannelFuture deregister() {
            return this.ctx.deregister();
        }

        public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
            return this.ctx.bind(localAddress, promise);
        }

        public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
            return this.ctx.connect(remoteAddress, promise);
        }

        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            return this.ctx.connect(remoteAddress, localAddress, promise);
        }

        public ChannelFuture disconnect(ChannelPromise promise) {
            return this.ctx.disconnect(promise);
        }

        public ChannelFuture close(ChannelPromise promise) {
            return this.ctx.close(promise);
        }

        @Deprecated
        public ChannelFuture deregister(ChannelPromise promise) {
            return this.ctx.deregister(promise);
        }

        public ChannelHandlerContext read() {
            this.ctx.read();
            return this;
        }

        public ChannelFuture write(Object msg) {
            return this.ctx.write(msg);
        }

        public ChannelFuture write(Object msg, ChannelPromise promise) {
            return this.ctx.write(msg, promise);
        }

        public ChannelHandlerContext flush() {
            this.ctx.flush();
            return this;
        }

        public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
            return this.ctx.writeAndFlush(msg, promise);
        }

        public ChannelFuture writeAndFlush(Object msg) {
            return this.ctx.writeAndFlush(msg);
        }

        public ChannelPipeline pipeline() {
            return this.ctx.pipeline();
        }

        public ByteBufAllocator alloc() {
            return ForceDirectPoooledByteBufAllocator.INSTANCE;
        }

        public ChannelPromise newPromise() {
            return this.ctx.newPromise();
        }

        public ChannelProgressivePromise newProgressivePromise() {
            return this.ctx.newProgressivePromise();
        }

        public ChannelFuture newSucceededFuture() {
            return this.ctx.newSucceededFuture();
        }

        public ChannelFuture newFailedFuture(Throwable cause) {
            return this.ctx.newFailedFuture(cause);
        }

        public ChannelPromise voidPromise() {
            return this.ctx.voidPromise();
        }

        public <T> Attribute<T> attr(AttributeKey<T> key) {
            return this.ctx.attr(key);
        }
    }
}

