/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.impl;

import java.io.File;
import java.util.Collection;
import org.eclipse.cbi.p2repo.aggregator.Aggregation;
import org.eclipse.cbi.p2repo.aggregator.AggregatorFactory;
import org.eclipse.cbi.p2repo.aggregator.AggregatorPackage;
import org.eclipse.cbi.p2repo.aggregator.AggregatorPlugin;
import org.eclipse.cbi.p2repo.aggregator.InfosProvider;
import org.eclipse.cbi.p2repo.aggregator.MappedRepository;
import org.eclipse.cbi.p2repo.aggregator.MetadataRepositoryReference;
import org.eclipse.cbi.p2repo.aggregator.Status;
import org.eclipse.cbi.p2repo.aggregator.StatusCode;
import org.eclipse.cbi.p2repo.aggregator.StatusProvider;
import org.eclipse.cbi.p2repo.aggregator.p2.util.MetadataRepositoryResourceImpl;
import org.eclipse.cbi.p2repo.aggregator.util.AggregatorResource;
import org.eclipse.cbi.p2repo.aggregator.util.GeneralUtils;
import org.eclipse.cbi.p2repo.cli.HeadlessActivator;
import org.eclipse.cbi.p2repo.p2.MetadataRepository;
import org.eclipse.cbi.p2repo.p2.P2Factory;
import org.eclipse.cbi.p2repo.util.StringUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

public class MetadataRepositoryReferenceImpl
extends MinimalEObjectImpl.Container
implements MetadataRepositoryReference {
    protected int eFlags = 0;
    protected static final boolean BRANCH_ENABLED_EDEFAULT = false;
    protected static final boolean ENABLED_EDEFAULT = true;
    protected static final int ENABLED_EFLAG = 1;
    protected EList<String> errors;
    protected EList<String> warnings;
    protected EList<String> infos;
    protected MetadataRepository metadataRepository;
    protected static final String LOCATION_EDEFAULT = null;
    protected String location = LOCATION_EDEFAULT;
    protected static final String NATURE_EDEFAULT = "p2";
    protected String nature = "p2";

    private static String getString(String key) {
        return AggregatorPlugin.INSTANCE.getString(key);
    }

    protected MetadataRepositoryReferenceImpl() {
        this.eFlags |= 1;
    }

    public MetadataRepository basicGetMetadataRepository() {
        return this.metadataRepository;
    }

    @Override
    public synchronized void cancelRepositoryLoad() {
        MetadataRepositoryResourceImpl.cancelLoadRepository(this.getNature(), this.getResolvedLocation(), this.getAggregation());
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == StatusProvider.class) {
            switch (derivedFeatureID) {
                case 2: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == InfosProvider.class) {
            switch (derivedFeatureID) {
                case 3: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == StatusProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 2;
                }
            }
            return -1;
        }
        if (baseClass == InfosProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 3;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 5;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isBranchEnabled();
            }
            case 1: {
                return this.isEnabled();
            }
            case 2: {
                return this.getStatus();
            }
            case 3: {
                return this.getErrors();
            }
            case 4: {
                return this.getWarnings();
            }
            case 5: {
                return this.getInfos();
            }
            case 6: {
                if (resolve) {
                    return this.getMetadataRepository();
                }
                return this.basicGetMetadataRepository();
            }
            case 7: {
                return this.getLocation();
            }
            case 8: {
                return this.getNature();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.isSetBranchEnabled();
            }
            case 1: {
                return (this.eFlags & 1) == 0;
            }
            case 2: {
                return this.getStatus() != null;
            }
            case 3: {
                return this.errors != null && !this.errors.isEmpty();
            }
            case 4: {
                return this.warnings != null && !this.warnings.isEmpty();
            }
            case 5: {
                return this.infos != null && !this.infos.isEmpty();
            }
            case 6: {
                return this.metadataRepository != null;
            }
            case 7: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals(this.location);
            }
            case 8: {
                return NATURE_EDEFAULT == null ? this.nature != null : !NATURE_EDEFAULT.equals(this.nature);
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setEnabled((Boolean)newValue);
                return;
            }
            case 3: {
                this.getErrors().clear();
                this.getErrors().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getWarnings().clear();
                this.getWarnings().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getInfos().clear();
                this.getInfos().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setMetadataRepository((MetadataRepository)newValue);
                return;
            }
            case 7: {
                this.setLocation((String)newValue);
                return;
            }
            case 8: {
                this.setNature((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.METADATA_REPOSITORY_REFERENCE;
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setEnabled(true);
                return;
            }
            case 3: {
                this.getErrors().clear();
                return;
            }
            case 4: {
                this.getWarnings().clear();
                return;
            }
            case 5: {
                this.getInfos().clear();
                return;
            }
            case 6: {
                this.setMetadataRepository(null);
                return;
            }
            case 7: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 8: {
                this.setNature(NATURE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public Aggregation getAggregation() {
        return GeneralUtils.getAggregation((EObject)this);
    }

    private AggregatorResource getAggregatorResource() {
        return GeneralUtils.getAggregatorResource((EObject)this);
    }

    @Override
    public EList<String> getErrors() {
        MetadataRepositoryResourceImpl res;
        this.errors = new BasicEList();
        String nature = this.getNature();
        String location = this.getResolvedLocation();
        if (nature == null || location == null) {
            this.errors.add((Object)MetadataRepositoryReferenceImpl.getString("_UI_ErrorMessage_RepositoryIsNotSet"));
            return this.errors;
        }
        if (this.eResource() != null && (res = (MetadataRepositoryResourceImpl)MetadataRepositoryResourceImpl.getResourceForNatureAndLocation(nature, location, this.getAggregation(), false)) == null) {
            this.errors.add((Object)MetadataRepositoryReferenceImpl.getString("_UI_ErrorMessage_RepositoryIsNotAvailable"));
            return this.errors;
        }
        return this.errors;
    }

    @Override
    public EList<String> getInfos() {
        if (this.infos == null) {
            this.infos = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 5);
        }
        return this.infos;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public MetadataRepository getMetadataRepository() {
        return this.getMetadataRepository(true);
    }

    @Override
    public MetadataRepository getMetadataRepository(boolean forceResolve) {
        if (!this.isBranchEnabled()) {
            return null;
        }
        if (forceResolve) {
            if (this.metadataRepository == null) {
                this.metadataRepository = P2Factory.eINSTANCE.createMetadataRepositoryProxy(this.getNature(), this.getResolvedLocation());
            }
            return this.getMetadataRepositoryGen();
        }
        return this.metadataRepository;
    }

    public MetadataRepository getMetadataRepositoryGen() {
        if (this.metadataRepository != null && ((EObject)this.metadataRepository).eIsProxy()) {
            InternalEObject oldMetadataRepository = (InternalEObject)this.metadataRepository;
            this.metadataRepository = (MetadataRepository)this.eResolveProxy(oldMetadataRepository);
            if (this.metadataRepository != oldMetadataRepository && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldMetadataRepository, (Object)this.metadataRepository));
            }
        }
        return this.metadataRepository;
    }

    @Override
    public String getNature() {
        return this.nature;
    }

    @Override
    public String getResolvedLocation() {
        URI uri;
        String location = StringUtils.trimmedOrNull((String)this.getLocation());
        if (location == null) {
            return null;
        }
        File locationFile = new File(location);
        if (locationFile.isAbsolute() || location.startsWith(File.separator) || location.startsWith("/")) {
            uri = URI.createURI((String)locationFile.toURI().toString());
        } else {
            URI base;
            uri = URI.createURI((String)location, (boolean)true);
            if (uri.isRelative() && (base = ((EObject)this.getAggregation()).eResource().getURI()) != null) {
                uri = uri.resolve(base);
            }
        }
        String[] uriSegments = uri.segments();
        int i = uriSegments.length;
        while (i > 0) {
            String segment;
            if ((segment = uriSegments[--i]).length() == 0) continue;
            uri = uri.trimSegments(uriSegments.length - i - 1);
            break;
        }
        return uri.toString();
    }

    @Override
    public synchronized Status getStatus() {
        if (this.isBranchEnabled()) {
            MetadataRepositoryResourceImpl res;
            if (this.getMetadataRepository(false) != null && !((EObject)this.getMetadataRepository(false)).eIsProxy()) {
                return AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
            }
            String nature = this.getNature();
            String location = this.getResolvedLocation();
            if (nature == null || location == null) {
                return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, MetadataRepositoryReferenceImpl.getString("_UI_ErrorMessage_RepositoryIsNotSet"));
            }
            try {
                res = (MetadataRepositoryResourceImpl)MetadataRepositoryResourceImpl.getResourceForNatureAndLocation(nature, location, this.getAggregation(), false);
            }
            catch (Exception exception) {
                res = null;
            }
            if (res != null) {
                return res.getStatus();
            }
        }
        return AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
    }

    @Override
    public EList<String> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 4);
        }
        return this.warnings;
    }

    @Override
    public boolean isBranchEnabled() {
        return GeneralUtils.isBranchEnabled(this);
    }

    @Override
    public boolean isEnabled() {
        return (this.eFlags & 1) != 0;
    }

    @Override
    public boolean isSetBranchEnabled() {
        return true;
    }

    @Override
    public void onRepositoryLoad() {
        if (this instanceof MappedRepository && this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, null, null));
        }
        if (!HeadlessActivator.getInstance().isHeadless()) {
            this.getAggregatorResource().analyzeResource();
        }
    }

    @Override
    public void setEnabled(boolean newEnabled) {
        boolean oldEnabled;
        boolean bl = oldEnabled = (this.eFlags & 1) != 0;
        this.eFlags = newEnabled ? (this.eFlags |= 1) : (this.eFlags &= 0xFFFFFFFE);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldEnabled, newEnabled));
        }
    }

    @Override
    public void setLocation(String newLocation) {
        String oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldLocation, (Object)this.location));
        }
    }

    @Override
    public synchronized void setMetadataRepository(MetadataRepository newMetadataRepository) {
        if (newMetadataRepository != this.metadataRepository) {
            this.setMetadataRepositoryGen(newMetadataRepository);
        }
    }

    public void setMetadataRepositoryGen(MetadataRepository newMetadataRepository) {
        MetadataRepository oldMetadataRepository = this.metadataRepository;
        this.metadataRepository = newMetadataRepository;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldMetadataRepository, (Object)this.metadataRepository));
        }
    }

    @Override
    public void setNature(String newNature) {
        String oldNature = this.nature;
        this.nature = newNature;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldNature, (Object)this.nature));
        }
    }

    @Override
    public synchronized void startRepositoryLoad(boolean forceReload) {
        Aggregation aggregation;
        String resolvedLocation;
        if (StringUtils.trimmedOrNull((String)this.getLocation()) == null) {
            this.setMetadataRepository(null);
            this.onRepositoryLoad();
            return;
        }
        String nature = this.getNature();
        Resource res = MetadataRepositoryResourceImpl.getResourceForNatureAndLocation(nature, resolvedLocation = this.getResolvedLocation(), aggregation = this.getAggregation());
        if (res == null) {
            this.onRepositoryLoad();
            return;
        }
        ((MetadataRepositoryResourceImpl)res).startAsynchronousLoad(forceReload);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (enabled: ");
        result.append((this.eFlags & 1) != 0);
        result.append(", errors: ");
        result.append(this.errors);
        result.append(", warnings: ");
        result.append(this.warnings);
        result.append(", infos: ");
        result.append(this.infos);
        result.append(", location: ");
        result.append(this.location);
        result.append(", nature: ");
        result.append(this.nature);
        result.append(')');
        return result.toString();
    }
}

