/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors.java_mctr;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.titan.executor.executors.LaunchConfigurationUtil;
import org.eclipse.titan.executor.executors.TitanLaunchConfigurationDelegate;
import org.eclipse.titan.executor.executors.java_mctr.NativeJavaExecutor;

public final class LaunchConfigurationDelegate
extends TitanLaunchConfigurationDelegate {
    private static final String MISSING_LINKED_LAUNCH_CONFIG = "Unable to locate the launch configuration for single mode";

    public void launch(ILaunchConfiguration arg0, String arg1, ILaunch arg2, IProgressMonitor arg3) throws CoreException {
        this.showExecutionPerspective(arg0.getType());
        boolean singleMode = arg0.getAttribute("org.eclipse.titan.executor.singleModeJavaExecutor", false);
        if (singleMode) {
            List<String> list = LaunchConfigurationUtil.getLinkedLaunchConfigurations(arg0);
            if (list == null || list.size() != 1) {
                Status status = new Status(4, "org.eclipse.titan.executor", 0, MISSING_LINKED_LAUNCH_CONFIG, null);
                throw new CoreException((IStatus)status);
            }
            ILaunchConfiguration singleConfig = LaunchConfigurationUtil.findJavaAppLaunchConfigurationByName(list.get(0));
            if (singleConfig == null) {
                Status status = new Status(4, "org.eclipse.titan.executor", 0, MISSING_LINKED_LAUNCH_CONFIG, null);
                throw new CoreException((IStatus)status);
            }
            singleConfig.launch(arg1, null);
            return;
        }
        NativeJavaExecutor executor = new NativeJavaExecutor(arg0);
        executor.startSession(arg2);
    }
}

