/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.BuildLocation;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.pages.ConfigurationManagerControl;
import org.eclipse.titan.designer.properties.pages.RemoteHostDialog;
import org.eclipse.titan.designer.wizards.projectFormat.TITANAutomaticProjectExporter;
import org.eclipse.ui.dialogs.PropertyPage;

public final class ProjectRemoteBuildPropertyPage
extends PropertyPage {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String EXECUTE_TEXT = "Execute the build commands in parallel";
    private static final String ADDBUTTON_TEXT = "New...";
    private static final String EDITBUTTON_TEXT = "Edit...";
    private static final String COPYBUTTON_TEXT = "Copy...";
    private static final String REMOVEBUTTON_TEXT = "Remove...";
    private static final String[] hostTableColumnHeaders = new String[]{"Active", "Name", "Command"};
    private IProject projectResource;
    private Composite pageComposite;
    private ConfigurationManagerControl configurationManager;
    private Composite remoteHostEditComposite;
    private Label headLabel;
    private TableViewer hostViewer;
    private Button executeInParallel;
    private Button addHostButton;
    private Button editHostButton;
    private Button copyHostButton;
    private Button removeHostButton;
    private final Image[] images = new Image[]{ImageCache.getImageDescriptor("question.gif").createImage(), ImageCache.getImageDescriptor("host.gif").createImage(), ImageCache.getImageDescriptor("command.gif").createImage()};
    private final ColumnLayoutData[] hostTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(10), new ColumnWeightData(30), new ColumnWeightData(60)};

    public void dispose() {
        this.pageComposite.dispose();
        this.headLabel.dispose();
        this.hostViewer = null;
        if (this.executeInParallel != null) {
            this.executeInParallel.dispose();
            this.executeInParallel = null;
        }
        if (this.remoteHostEditComposite != null) {
            this.remoteHostEditComposite.dispose();
            this.remoteHostEditComposite = null;
        }
        if (this.addHostButton != null) {
            this.addHostButton.dispose();
            this.addHostButton = null;
        }
        if (this.editHostButton != null) {
            this.editHostButton.dispose();
            this.editHostButton = null;
        }
        if (this.copyHostButton != null) {
            this.copyHostButton.dispose();
            this.copyHostButton = null;
        }
        if (this.removeHostButton != null) {
            this.removeHostButton.dispose();
            this.removeHostButton = null;
        }
        for (int i = 0; i < this.images.length; ++i) {
            this.images[i].dispose();
        }
        super.dispose();
    }

    public void changeConfiguration(String configuration) {
        this.configurationManager.changeActualConfiguration();
        this.loadProperties();
        PropertyNotificationManager.firePropertyChange((IResource)this.projectResource);
    }

    protected Control createContents(Composite parent) {
        this.projectResource = (IProject)this.getElement();
        this.pageComposite = new Composite(parent, 0);
        GridLayout pageCompositeLayout = new GridLayout();
        pageCompositeLayout.numColumns = 1;
        this.pageComposite.setLayout((Layout)pageCompositeLayout);
        GridData pageCompositeGridData = new GridData();
        pageCompositeGridData.horizontalAlignment = 4;
        pageCompositeGridData.verticalAlignment = 4;
        pageCompositeGridData.grabExcessHorizontalSpace = true;
        pageCompositeGridData.grabExcessVerticalSpace = true;
        this.pageComposite.setLayoutData((Object)pageCompositeGridData);
        if (TITANBuilder.isBuilderEnabled((IProject)this.getElement())) {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText("This TITAN project has the TITAN C++ builder enabled.");
        } else {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText("This TITAN project has the TITAN C++ builder disabled.");
        }
        this.configurationManager = new ConfigurationManagerControl(this.pageComposite, this.projectResource);
        this.configurationManager.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProjectRemoteBuildPropertyPage.this.configurationManager.hasConfigurationChanged()) {
                    ProjectRemoteBuildPropertyPage.this.changeConfiguration(ProjectRemoteBuildPropertyPage.this.configurationManager.getActualSelection());
                }
            }
        });
        this.executeInParallel = new Button(this.pageComposite, 32);
        this.executeInParallel.setText(EXECUTE_TEXT);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.executeInParallel.setLayoutData((Object)gd);
        this.remoteHostEditComposite = new Composite(this.pageComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.remoteHostEditComposite.setLayout((Layout)layout);
        this.remoteHostEditComposite.setLayoutData((Object)gridData);
        this.remoteHostEditComposite.setFont(parent.getFont());
        this.createHostControllersTable(this.remoteHostEditComposite);
        this.createTableButtons(this.remoteHostEditComposite);
        this.loadProperties();
        return this.pageComposite;
    }

    private void createHostControllersTable(Composite parent) {
        this.hostViewer = new TableViewer(parent, 68354);
        Table table = this.hostViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.hostViewer.getControl().setLayoutData((Object)data);
        this.hostViewer.setLabelProvider((IBaseLabelProvider)new RemoteBuildLabelProvider());
        this.hostViewer.setContentProvider((IContentProvider)new RemoteBuildContentProvider());
        for (int i = 0; i < hostTableColumnHeaders.length; ++i) {
            tableLayout.addColumnData(this.hostTableColumnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(true);
            tc.setMoveable(true);
            tc.setText(hostTableColumnHeaders[i]);
            tc.setImage(this.images[i]);
        }
    }

    private void createTableButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalAlignment = 1;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)data);
        buttonComposite.setFont(parent.getFont());
        Label label = new Label(buttonComposite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        label.setFont(buttonComposite.getFont());
        this.addHostButton = ProjectRemoteBuildPropertyPage.createPushButton(buttonComposite, ADDBUTTON_TEXT, null);
        this.addHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectRemoteBuildPropertyPage.this.handleNewButtonSelected();
            }
        });
        this.editHostButton = ProjectRemoteBuildPropertyPage.createPushButton(buttonComposite, EDITBUTTON_TEXT, null);
        this.editHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectRemoteBuildPropertyPage.this.handleEditButtonSelected();
            }
        });
        this.copyHostButton = ProjectRemoteBuildPropertyPage.createPushButton(buttonComposite, COPYBUTTON_TEXT, null);
        this.copyHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectRemoteBuildPropertyPage.this.handleCopySelected();
            }
        });
        this.removeHostButton = ProjectRemoteBuildPropertyPage.createPushButton(buttonComposite, REMOVEBUTTON_TEXT, null);
        this.removeHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectRemoteBuildPropertyPage.this.handleRemoveSelected();
            }
        });
    }

    public static Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gd);
        return button;
    }

    private void loadProperties() {
        String temp = null;
        try {
            temp = this.projectResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.parallelCommandExecution"));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        this.executeInParallel.setSelection(TRUE.equals(temp));
        try {
            temp = this.projectResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.remoteBuildHostInfo"));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        List splittedList = StringUtils.intelligentSplit((String)temp, (char)'#', (char)'\\');
        this.hostViewer.setInput((Object)splittedList.toArray(new String[splittedList.size()]));
    }

    protected void handleNewButtonSelected() {
        RemoteHostDialog dialog = new RemoteHostDialog(this.getShell());
        dialog.setActive(false);
        if (dialog.open() == 0) {
            this.hostViewer.add((Object)new BuildLocation(dialog.getActive(), dialog.getName(), dialog.getCommand()));
        }
    }

    protected void handleEditButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.hostViewer.getSelection();
        BuildLocation host = (BuildLocation)sel.getFirstElement();
        if (host == null) {
            return;
        }
        RemoteHostDialog dialog = new RemoteHostDialog(this.getShell());
        dialog.setActive(host.getActive());
        dialog.setName(host.getName());
        dialog.setCommand(host.getCommand());
        if (dialog.open() != 0) {
            return;
        }
        host.configure(dialog.getActive(), dialog.getName(), dialog.getCommand());
        this.hostViewer.refresh((Object)host, true);
    }

    protected void handleCopySelected() {
        IStructuredSelection sel = (IStructuredSelection)this.hostViewer.getSelection();
        BuildLocation host = (BuildLocation)sel.getFirstElement();
        if (host == null) {
            return;
        }
        this.hostViewer.add((Object)host.clone());
    }

    protected void handleRemoveSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.hostViewer.getSelection();
        this.hostViewer.getControl().setRedraw(false);
        Iterator i = sel.iterator();
        while (i.hasNext()) {
            this.hostViewer.remove(i.next());
        }
        this.hostViewer.getControl().setRedraw(true);
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            return;
        }
        if (this.configurationManager != null) {
            this.configurationManager.refresh();
        }
        super.setVisible(visible);
    }

    public boolean performOk() {
        try {
            this.projectResource.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.parallelCommandExecution"), this.executeInParallel.getSelection() ? TRUE : FALSE);
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        TableItem[] items = this.hostViewer.getTable().getItems();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            BuildLocation location = (BuildLocation)items[i].getData();
            if (i != 0) {
                builder.append('#');
            }
            builder.append(location.getPropertyValueRepresentation().toString().replace("#", "\\#"));
        }
        try {
            this.projectResource.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.remoteBuildHostInfo"), builder.toString());
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        this.configurationManager.saveActualConfiguration();
        ProjectDocumentHandlingUtility.saveDocument(this.projectResource);
        TITANAutomaticProjectExporter.saveAllAutomatically(this.projectResource);
        return super.performOk();
    }

    public boolean performCancel() {
        this.configurationManager.clearActualConfiguration();
        String temp = null;
        try {
            temp = this.projectResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.parallelCommandExecution"));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        this.executeInParallel.setSelection(TRUE.equals(temp));
        try {
            temp = this.projectResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.remoteBuildHostInfo"));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
            temp = null;
        }
        List splittedList = StringUtils.intelligentSplit((String)temp, (char)'#', (char)'\\');
        this.hostViewer.setInput((Object)splittedList.toArray(new String[splittedList.size()]));
        return super.performCancel();
    }

    protected void performDefaults() {
        this.executeInParallel.setSelection(false);
        try {
            this.projectResource.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.parallelCommandExecution"), FALSE);
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        this.hostViewer.setInput((Object)new BuildLocation[0]);
        try {
            this.projectResource.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.remoteBuildHostInfo"), "");
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        this.configurationManager.saveActualConfiguration();
        super.performDefaults();
    }

    private static class RemoteBuildLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private RemoteBuildLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof BuildLocation) {
                BuildLocation location = (BuildLocation)element;
                switch (columnIndex) {
                    case 0: {
                        return location.getActive() ? ProjectRemoteBuildPropertyPage.TRUE : ProjectRemoteBuildPropertyPage.FALSE;
                    }
                    case 1: {
                        return location.getName();
                    }
                    case 2: {
                        return location.getCommand();
                    }
                }
            }
            return null;
        }
    }

    private static class RemoteBuildContentProvider
    implements IStructuredContentProvider {
        private RemoteBuildContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof String[]) {
                String[] tempInput = (String[])inputElement;
                Object[] result = new BuildLocation[tempInput.length];
                for (int i = 0; i < tempInput.length; ++i) {
                    result[i] = new BuildLocation(tempInput[i]);
                }
                return result;
            }
            return new BuildLocation[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

