/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public final class LastCharAction
extends AbstractHandler
implements IEditorActionDelegate {
    private IEditorPart targetEditor = null;

    public void run(IAction action) {
        if (this.targetEditor == null || !(this.targetEditor instanceof FormEditor)) {
            return;
        }
        FormEditor tempEditor = (FormEditor)this.targetEditor;
        IEditorPart editorPart = tempEditor.getActiveEditor();
        if (!(editorPart instanceof ITextEditor)) {
            return;
        }
        ITextEditor realEditor = (ITextEditor)editorPart;
        realEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        IDocument doc = realEditor.getDocumentProvider().getDocument((Object)realEditor.getEditorInput());
        int offset = ((ITextSelection)realEditor.getSelectionProvider().getSelection()).getOffset();
        try {
            IRegion lineRegion = doc.getLineInformationOfOffset(offset);
            int lastVisibleCharLocation = this.lastVisibleCharLocation(doc, lineRegion);
            if (lastVisibleCharLocation != -1 && lastVisibleCharLocation + 1 != offset) {
                realEditor.selectAndReveal(lastVisibleCharLocation + 1, 0);
            } else {
                realEditor.selectAndReveal(lineRegion.getOffset() + lineRegion.getLength(), 0);
            }
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected int lastVisibleCharLocation(IDocument doc, IRegion lineRegion) throws BadLocationException {
        int endOffset = lineRegion.getOffset();
        for (int startOffset = Math.min(endOffset + lineRegion.getLength(), doc.getLength() - 1); startOffset >= endOffset; --startOffset) {
            char ch = doc.getChar(startOffset);
            if (Character.isWhitespace(ch)) continue;
            return startOffset;
        }
        return -1;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (this.targetEditor == null || !(this.targetEditor instanceof FormEditor)) {
            return null;
        }
        FormEditor tempEditor = (FormEditor)this.targetEditor;
        IEditorPart editorPart = tempEditor.getActiveEditor();
        if (!(editorPart instanceof ITextEditor)) {
            return null;
        }
        ITextEditor realEditor = (ITextEditor)editorPart;
        realEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        IDocument doc = realEditor.getDocumentProvider().getDocument((Object)realEditor.getEditorInput());
        int offset = ((ITextSelection)realEditor.getSelectionProvider().getSelection()).getOffset();
        try {
            IRegion lineRegion = doc.getLineInformationOfOffset(offset);
            int lastVisibleCharLocation = this.lastVisibleCharLocation(doc, lineRegion);
            if (lastVisibleCharLocation != -1 && lastVisibleCharLocation + 1 != offset) {
                realEditor.selectAndReveal(lastVisibleCharLocation + 1, 0);
            } else {
                realEditor.selectAndReveal(lineRegion.getOffset() + lineRegion.getLength(), 0);
            }
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return null;
    }
}

