/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Int2BitExpression
extends Expression_Value {
    private static final String OPERANDERROR1 = "The first operand of the `int2bit' operation should be an integer value";
    private static final String OPERANDERROR2 = "The first operand of the `int2bit' operation should not be negative";
    private static final String OPERANDERROR3 = "The second operand of the `int2bit' operation should be an integer value";
    private static final String OPERANDERROR4 = "The second operand of the `int2bit' operation should not be negative";
    private static final String OPERANDERROR5 = "Value {0} does not fit in length {1}";
    private static final String OPERANDERROR6 = "Using a large integer value ({0}) as the second operand of the `int2bit'' operation is not supported";
    private final Value value1;
    private final Value value2;

    public Int2BitExpression(Value value1, Value value2) {
        this.value1 = value1;
        this.value2 = value2;
        if (value1 != null) {
            value1.setFullNameParent(this);
        }
        if (value2 != null) {
            value2.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.INT2BIT_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.value1 != null && this.value1.checkExpressionSelfReferenceValue(timestamp, lhs)) {
            return true;
        }
        return this.value2 != null && this.value2.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("int2bit(");
        builder.append(this.value1.createStringRepresentation());
        builder.append(", ");
        builder.append(this.value2.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value1 != null) {
            this.value1.setMyScope(scope);
        }
        if (this.value2 != null) {
            this.value2.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.value1 != null) {
            this.value1.setCodeSection(codeSection);
        }
        if (this.value2 != null) {
            this.value2.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.value2 == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BITSTRING;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value1 == null || this.value2 == null) {
            return true;
        }
        return this.value1.isUnfoldable(timestamp, expectedValue, referenceChain) || this.value2.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value1 == null || this.value2 == null) {
            return;
        }
        IValue last1 = null;
        IValue last2 = null;
        this.value1.setLoweridToReference(timestamp);
        IType.Type_type tempType1 = this.value1.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType1) {
            case TYPE_INTEGER: {
                last1 = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                if (last1.isUnfoldable(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)last1.getValuetype()) || ((Integer_Value)last1).signum() >= 0) break;
                this.value1.getLocation().reportSemanticError(OPERANDERROR2);
                this.setIsErroneous(true);
                break;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                break;
            }
            default: {
                if (this.isErroneous) break;
                this.location.reportSemanticError(OPERANDERROR1);
                this.setIsErroneous(true);
            }
        }
        this.value2.setLoweridToReference(timestamp);
        IType.Type_type tempType2 = this.value2.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType2) {
            case TYPE_INTEGER: {
                last2 = this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
                if (last2.isUnfoldable(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)last2.getValuetype())) break;
                if (((Integer_Value)last2).isNative()) {
                    Integer_Value i1;
                    int i2 = ((Integer_Value)last2).intValue();
                    if (i2 < 0) {
                        this.value2.getLocation().reportSemanticError(OPERANDERROR4);
                        this.setIsErroneous(true);
                        break;
                    }
                    if (last1 == null || last1.isUnfoldable(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)last1.getValuetype()) || (i1 = (Integer_Value)last1).shiftRight(i2).compareTo(new Integer_Value(0L)) <= 0) break;
                    this.location.reportSemanticError(MessageFormat.format(OPERANDERROR5, i1.intValue(), i2));
                    this.setIsErroneous(true);
                    break;
                }
                this.value2.getLocation().reportSemanticError(MessageFormat.format(OPERANDERROR6, ((Integer_Value)last2).getValueValue()));
                this.setIsErroneous(true);
                break;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                break;
            }
            default: {
                if (this.isErroneous) break;
                this.location.reportSemanticError(OPERANDERROR3);
                this.setIsErroneous(true);
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value1 == null || this.value2 == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        IValue last1 = this.value1.getValueRefdLast(timestamp, referenceChain);
        IValue last2 = this.value2.getValueRefdLast(timestamp, referenceChain);
        if (last1.getIsErroneous(timestamp) || last2.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return this.lastValue;
        }
        int i2 = ((Integer_Value)last2).intValue();
        this.lastValue = new Bitstring_Value(Int2BitExpression.int2bit((Integer_Value)last1, i2));
        this.lastValue.copyGeneralProperties(this);
        return this.lastValue;
    }

    public static String int2bit(Integer_Value value, int length) {
        StringBuilder builder = new StringBuilder(length);
        BigInteger temp = value.getValueValue();
        for (int i = 1; i <= length; ++i) {
            if (temp.remainder(BigInteger.valueOf(2L)).equals(BigInteger.ZERO)) {
                builder.append('0');
            } else {
                builder.append('1');
            }
            temp = temp.shiftRight(1);
        }
        builder.reverse();
        return builder.toString();
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.value1 != null) {
                referenceChain.markState();
                this.value1.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value2 != null) {
                referenceChain.markState();
                this.value2.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value1 != null) {
            this.value1.updateSyntax(reparser, false);
            reparser.updateLocation(this.value1.getLocation());
        }
        if (this.value2 != null) {
            this.value2.updateSyntax(reparser, false);
            reparser.updateLocation(this.value2.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value1 != null) {
            this.value1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value2 != null) {
            this.value2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value1 != null && !this.value1.accept(v)) {
            return false;
        }
        return this.value2 == null || this.value2.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value1 != null) {
            this.value1.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.value2 != null) {
            this.value2.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return this.value1.canGenerateSingleExpression() && this.value2.canGenerateSingleExpression();
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        IValue refdLast;
        aData.addCommonLibraryImport("AdditionalFunctions");
        expression.expression.append("AdditionalFunctions.int2bit(");
        if (this.value1.isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
            this.value1.generateCodeExpressionMandatory(aData, expression, false);
        } else {
            refdLast = this.value1.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
            refdLast.generateCodeExpression(aData, expression, false);
        }
        expression.expression.append(", ");
        if (this.value2.isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
            this.value2.generateCodeExpressionMandatory(aData, expression, false);
        } else {
            refdLast = this.value2.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
            refdLast.generateCodeExpression(aData, expression, false);
        }
        expression.expression.append(')');
    }
}

