/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.RangeListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SizeLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.StringPatternConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubtypeConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.TernaryBool;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.UCharLimit;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring;

public final class UStringValueConstraint
extends SubtypeConstraint {
    private final Set<UniversalCharstring> values;

    public UStringValueConstraint() {
        this.values = new TreeSet<UniversalCharstring>();
    }

    public UStringValueConstraint(UniversalCharstring str) {
        this.values = new TreeSet<UniversalCharstring>();
        this.values.add(str);
    }

    private UStringValueConstraint(Set<UniversalCharstring> values) {
        this.values = values;
    }

    @Override
    public SubtypeConstraint complement() {
        return null;
    }

    @Override
    public UStringValueConstraint except(SubtypeConstraint other) {
        UStringValueConstraint o = (UStringValueConstraint)other;
        TreeSet<UniversalCharstring> returnValue = new TreeSet<UniversalCharstring>();
        for (UniversalCharstring str : this.values) {
            if (o.values.contains(str)) continue;
            returnValue.add(str);
        }
        return new UStringValueConstraint(returnValue);
    }

    @Override
    public TernaryBool isSubset(SubtypeConstraint other) {
        return this.except(other).isEmpty();
    }

    public UStringValueConstraint setOperation(SubtypeConstraint other, boolean isUnion) {
        UStringValueConstraint o = (UStringValueConstraint)other;
        TreeSet<UniversalCharstring> returnValue = new TreeSet<UniversalCharstring>();
        if (isUnion) {
            returnValue.addAll(this.values);
            returnValue.addAll(o.values);
        } else {
            returnValue.addAll(this.values);
            returnValue.retainAll(o.values);
        }
        return new UStringValueConstraint(returnValue);
    }

    @Override
    public UStringValueConstraint intersection(SubtypeConstraint other) {
        return this.setOperation(other, false);
    }

    @Override
    public boolean isElement(Object o) {
        UniversalCharstring str = (UniversalCharstring)o;
        return this.values.contains(str);
    }

    @Override
    public TernaryBool isEmpty() {
        return TernaryBool.fromBool(this.values.isEmpty());
    }

    @Override
    public TernaryBool isEqual(SubtypeConstraint other) {
        UStringValueConstraint o = (UStringValueConstraint)other;
        return TernaryBool.fromBool(this.values.equals(o.values));
    }

    @Override
    public TernaryBool isFull() {
        return TernaryBool.TFALSE;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append('(');
        boolean needComma = false;
        for (UniversalCharstring str : this.values) {
            if (needComma) {
                sb.append(", ");
            }
            sb.append('\"').append(str.getStringRepresentation()).append('\"');
            needComma = true;
        }
        sb.append(')');
    }

    public UStringValueConstraint remove(RangeListConstraint rangeConstraint, boolean ifElement) {
        switch (rangeConstraint.getLimitType()) {
            case SIZE: {
                TreeSet<UniversalCharstring> returnValue = new TreeSet<UniversalCharstring>();
                for (UniversalCharstring str : this.values) {
                    if (rangeConstraint.isElement(new SizeLimit(str.length())) == ifElement) continue;
                    returnValue.add(str);
                }
                return new UStringValueConstraint(returnValue);
            }
            case UCHAR: {
                TreeSet<UniversalCharstring> returnValue = new TreeSet<UniversalCharstring>();
                for (UniversalCharstring str : this.values) {
                    boolean allCharsAreElements = true;
                    for (int charIndex = 0; charIndex < str.length(); ++charIndex) {
                        if (rangeConstraint.isElement(new UCharLimit(str.get(charIndex)))) continue;
                        allCharsAreElements = false;
                        break;
                    }
                    if (allCharsAreElements == ifElement) continue;
                    returnValue.add(str);
                }
                return new UStringValueConstraint(returnValue);
            }
        }
        return this;
    }

    public UStringValueConstraint remove(StringPatternConstraint patternConstraint, boolean ifElement) {
        return this;
    }

    @Override
    public UStringValueConstraint union(SubtypeConstraint other) {
        return this.setOperation(other, true);
    }
}

