/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.PropertyBody;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class Def_Property
extends Def_Var {
    private static final String CANNOTMODIFYPROPERTY = "Cannot modify property `{0}'' because it doesn't have a setter";
    private PropertyBody body;

    public Def_Property(Identifier identifier, Type type, Value initialValue, FormalParameter.parameterEvaluationType evaluationType, PropertyBody body) {
        super(identifier, type, initialValue, evaluationType);
        this.body = body;
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public String getAssignmentName() {
        return "property";
    }

    @Override
    public String getOutlineIcon() {
        return "variable.gif";
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        super.check(timestamp, refChain);
        if (this.body != null) {
            this.body.check(timestamp, this);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        return this.body == null || this.body.accept(v);
    }

    public void useAsLvalue(Location location) {
        if (this.body != null && this.body.getSetter() == null) {
            location.reportSemanticError(MessageFormat.format(CANNOTMODIFYPROPERTY, this.identifier.getDisplayName()));
        }
    }

    @Override
    public PropertyBody getPropertyBody() {
        return this.body;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract();
    }

    @Override
    public boolean isFinal() {
        return this.isFinal();
    }
}

