/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3DocCommentLexer;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3DocCommentParser;

public class DocumentComment
implements ILocateableNode {
    private static final String IDPATTERN = "^[A-Za-z][A-Za-z0-9_]*$";
    private String comment;
    private Token first;
    private Token last;
    private Location location;
    private final List<String> authors = new ArrayList<String>();
    private String config = null;
    private final List<String> descs = new ArrayList<String>();
    private final Map<String, String> exceptions = new LinkedHashMap<String, String>();
    private final Map<String, String> members = new LinkedHashMap<String, String>();
    private final Map<String, String> params = new LinkedHashMap<String, String>();
    private final Map<String, Location> paramLocations = new LinkedHashMap<String, Location>();
    private String priority = null;
    private String purpose = null;
    private String reference = null;
    private final List<String> remarks = new ArrayList<String>();
    private final List<String> requirements = new ArrayList<String>();
    private String return_ = null;
    private final List<String> sees = new ArrayList<String>();
    private String since = null;
    private String status = null;
    private final List<String> urls = new ArrayList<String>();
    private final Map<String, String> verdicts = new LinkedHashMap<String, String>();
    private String version = null;
    private boolean isDeprecated = false;
    private String category = null;

    public DocumentComment(String comment, Token first, Token last) {
        this.comment = comment;
        this.first = first;
        this.last = last;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public Token getFirstToken() {
        return this.first;
    }

    public Token getLastToken() {
        return this.last;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void addAuthor(String text, Location location) {
        if (text != null) {
            this.authors.add(text.trim());
        }
    }

    public void addAuthorsContent(Ttcn3HoverContent content) {
        if (this.authors.size() > 0) {
            content.addTag("Authors:");
            for (String author : this.authors) {
                content.addIndentedText(author, 2);
            }
        }
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public boolean hasAuthors() {
        return this.authors.size() > 0;
    }

    public void addConfig(String text, Location location) {
        if (this.config == null) {
            if (text != null) {
                this.config = text.trim();
            }
        } else {
            this.reportProblem("`@config' tag is specified more than once", location);
        }
    }

    public void addConfigContent(Ttcn3HoverContent content) {
        if (this.config == null || this.config.length() == 0) {
            return;
        }
        content.addTag("Configuration:");
        content.addIndentedText(this.config);
    }

    public String getConfig() {
        return this.config != null ? this.config : "";
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public void addDesc(String text, Location location) {
        if (text != null) {
            this.descs.add(text.trim());
        }
    }

    public void addDescsContent(Ttcn3HoverContent content) {
        if (this.descs.size() > 0) {
            content.addText("<br>");
            for (String desc : this.descs) {
                content.addText(desc).addText(" ");
            }
        }
    }

    public List<String> getDescs() {
        return this.descs;
    }

    public boolean hasDescs() {
        return this.descs.size() > 0;
    }

    public void addException(String id, String text, Location location) {
        if (id == null) {
            return;
        }
        String trimmedId = id.trim();
        String prev = this.exceptions.put(trimmedId, text != null ? text.trim() : "");
        if (prev != null) {
            this.reportProblem(MessageFormat.format("The exception `{0}'' is specified more than once, using the latest", trimmedId), location);
        }
    }

    public void addExceptionsContent(Ttcn3HoverContent content) {
        if (this.exceptions.size() > 0) {
            content.addTag("Exceptions");
            for (Map.Entry<String, String> exception : this.exceptions.entrySet()) {
                content.addIndentedText(exception.getKey(), exception.getValue());
            }
        }
    }

    public Map<String, String> getExceptions() {
        return this.exceptions;
    }

    public boolean hasExceptions() {
        return this.exceptions.size() > 0;
    }

    public void addMember(String id, String text, Location location) {
        if (id == null) {
            return;
        }
        String trimmedId = id.trim();
        String prev = this.members.put(trimmedId, text != null ? text.trim() : "");
        if (prev != null) {
            this.reportProblem(MessageFormat.format("The member `{0}'' is specified more than once, using the latest", trimmedId), location);
        }
    }

    public void addMembersContent(Ttcn3HoverContent content) {
        if (this.members.size() > 0) {
            content.addTag("Members");
            for (Map.Entry<String, String> member : this.members.entrySet()) {
                content.addIndentedText(member.getKey(), member.getValue());
            }
        }
    }

    public Map<String, String> getMembers() {
        return this.members;
    }

    public String getMember(String memberName) {
        return this.members.get(memberName);
    }

    public boolean hasMembers() {
        return this.members.size() > 0;
    }

    public void addParam(String id, String text, Location location) {
        if (id == null) {
            return;
        }
        String trimmedId = id.trim();
        this.paramLocations.put(trimmedId, location);
        String prev = this.params.put(trimmedId, text != null ? text.trim() : "");
        if (prev != null) {
            this.reportProblem(MessageFormat.format("The parameter `{0}'' is specified more than once, using the latest", trimmedId), location);
        }
    }

    public void addParamsContent(Ttcn3HoverContent content, FormalParameterList fpl) {
        if (this.params.size() > 0) {
            content.addTag("Parameters");
            String paramType = null;
            for (Map.Entry<String, String> param : this.params.entrySet()) {
                Location location = this.paramLocations.get(param.getKey());
                FormalParameter fp = null;
                if (fpl != null) {
                    fp = fpl.getParameterById(new Identifier(Identifier.Identifier_type.ID_TTCN, param.getKey()));
                }
                if (fp != null) {
                    paramType = fp.getFormalParamType();
                } else {
                    this.reportProblem(MessageFormat.format("The formal parameter `{0}'' in the comment is not part of the definition", param.getKey()), location);
                }
                StringBuilder sb = new StringBuilder(param.getKey());
                sb.append(" (").append(paramType != null ? paramType : "<?>").append(")");
                content.addIndentedText(sb.toString(), param.getValue());
            }
            if (fpl.getNofParameters() != this.params.size()) {
                this.reportProblem("The number of formal parameters in the comment is not the same as of the definition", this.location);
            }
        }
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public boolean hasParams() {
        return this.params.size() > 0;
    }

    public void addPriority(String text, Location location) {
        if (this.priority == null) {
            if (text != null) {
                this.priority = text.trim();
            }
        } else {
            this.reportProblem("`@priority' tag is specified more than once", location);
        }
    }

    public void addPriorityContent(Ttcn3HoverContent content) {
        if (this.priority == null || this.priority.length() == 0) {
            return;
        }
        content.addTagWithText("Priority:", this.priority);
    }

    public String getPriority() {
        return this.priority != null ? this.priority : "";
    }

    public boolean hasPriority() {
        return this.priority != null;
    }

    public void addPurpose(String text, Location location) {
        if (this.purpose == null) {
            if (text != null) {
                this.purpose = text.trim();
            }
        } else {
            this.reportProblem("`@purpose' tag is specified more than once", location);
        }
    }

    public void addPurposeContent(Ttcn3HoverContent content) {
        if (this.purpose == null || this.purpose.length() == 0) {
            return;
        }
        content.addTagWithText("Purpose:", this.purpose);
    }

    public String getPurpose() {
        return this.purpose != null ? this.purpose : "";
    }

    public boolean hasPurpose() {
        return this.purpose != null;
    }

    public void addReference(String text, Location location) {
        if (this.reference == null) {
            if (text != null) {
                this.reference = text.trim();
            }
        } else {
            this.reportProblem("`@reference' tag is specified more than once", location);
        }
    }

    public void addReferenceContent(Ttcn3HoverContent content) {
        if (this.reference == null || this.reference.length() == 0) {
            return;
        }
        content.addTagWithText("Reference:", this.reference);
    }

    public String getReference() {
        return this.reference != null ? this.reference : "";
    }

    public boolean hasReference() {
        return this.reference != null;
    }

    public void addRemark(String text, Location location) {
        if (text != null) {
            this.remarks.add(text.trim());
        }
    }

    public void addRemarksContent(Ttcn3HoverContent content) {
        if (this.remarks.size() > 0) {
            content.addTag("Remarks");
            for (String remark : this.remarks) {
                content.addText(remark);
            }
        }
    }

    public List<String> getRemarks() {
        return this.remarks;
    }

    public boolean hasRemarks() {
        return this.remarks.size() > 0;
    }

    public void addRequirement(String text, Location location) {
        if (text != null) {
            this.requirements.add(text.trim());
        }
    }

    public void addRequirementsContent(Ttcn3HoverContent content) {
        if (this.requirements.size() > 0) {
            content.addTag("Requirements");
            for (String requirement : this.requirements) {
                content.addIndentedText(requirement);
            }
        }
    }

    public List<String> getRequirements() {
        return this.requirements;
    }

    public boolean hasRequirements() {
        return this.requirements.size() > 0;
    }

    public void addReturn(String text, Location location) {
        if (this.return_ == null) {
            if (text != null) {
                this.return_ = text.trim();
            }
        } else {
            this.reportProblem("`@return' tag is specified more than once", location);
        }
    }

    public void addReturnContent(Ttcn3HoverContent content) {
        if (this.return_ == null || this.return_.length() == 0) {
            return;
        }
        content.addTag("Returns");
        content.addIndentedText(this.return_);
    }

    public String getReturn() {
        return this.return_ != null ? this.return_ : "";
    }

    public boolean hasReturn() {
        return this.return_ != null;
    }

    public void addSee(String text, Location location) {
        if (text != null) {
            this.sees.add(text.trim());
        }
    }

    public void addSeesContent(Ttcn3HoverContent content) {
        if (this.sees.size() > 0) {
            content.addTag("See:");
            for (String see : this.sees) {
                content.addIndentedText(see, 2);
            }
        }
    }

    public List<String> getSees() {
        return this.sees;
    }

    public boolean hasSees() {
        return this.sees.size() > 0;
    }

    public void addSince(String text, Location location) {
        if (this.since == null) {
            if (text != null) {
                this.since = text.trim();
            }
        } else {
            this.reportProblem("`@since' tag is specified more than once", location);
        }
    }

    public void addSinceContent(Ttcn3HoverContent content) {
        if (this.since == null || this.since.length() == 0) {
            return;
        }
        content.addTagWithText("Since:", this.since);
    }

    public String getSince() {
        return this.since != null ? this.since : "";
    }

    public boolean hasSince() {
        return this.since != null;
    }

    public void addStatus(String text, Location location) {
        if (this.status == null) {
            if (text != null) {
                this.status = text.trim();
                this.isDeprecated = this.status.toLowerCase().contains("deprecated");
            }
        } else {
            this.reportProblem("`@status' tag is specified more than once", location);
        }
    }

    public void addStatusContent(Ttcn3HoverContent content) {
        if (this.status == null || this.status.length() == 0) {
            return;
        }
        content.addTagWithText("Status:", this.status);
    }

    public String getStatus() {
        return this.status != null ? this.status : "";
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public void addUrl(String text, Location location) {
        if (text != null) {
            this.urls.add(text.trim());
        }
    }

    public void addUrlsContent(Ttcn3HoverContent content) {
        if (this.urls.size() > 0) {
            content.addTag("URL:");
            for (String url : this.urls) {
                content.addUrlAsLink(url, 2);
            }
        }
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public boolean hasUrls() {
        return this.urls.size() > 0;
    }

    public void addVerdict(String id, String text, Location location) {
        if (id == null) {
            return;
        }
        String trimmedId = id.trim().toLowerCase();
        if (!(trimmedId.equals("pass") || trimmedId.equals("fail") || trimmedId.equals("inconc"))) {
            this.reportProblem(MessageFormat.format("The verdict `{0}'' is not allowed.\nAllowed verdicts are: `pass', `fail', `inconc'", trimmedId), location);
            return;
        }
        String prev = this.verdicts.put(trimmedId, text != null ? text.trim() : "");
        if (prev != null) {
            this.reportProblem(MessageFormat.format("The verdict `{0}'' is specified more than once, using the latest", trimmedId), location);
        }
    }

    public void addVerdictsContent(Ttcn3HoverContent content) {
        if (this.verdicts.size() > 0) {
            content.addTag("Verdicts");
            for (Map.Entry<String, String> verdict : this.verdicts.entrySet()) {
                content.addIndentedText(verdict.getKey(), verdict.getValue());
            }
        }
    }

    public Map<String, String> getVerdicts() {
        return this.verdicts;
    }

    public boolean hasVerdicts() {
        return this.verdicts.size() > 0;
    }

    public void addVersion(String text, Location location) {
        if (this.version == null) {
            if (text != null) {
                this.version = text.trim();
            }
        } else {
            this.reportProblem("`@version' tag is specified more than once", location);
        }
    }

    public void addVersionContent(Ttcn3HoverContent content) {
        if (this.version == null || this.version.length() == 0) {
            return;
        }
        content.addTagWithText("Version:", this.version);
    }

    public String getVersion() {
        return this.version != null ? this.version : "";
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public void addCategory(String text, Location location) {
        if (this.category == null) {
            if (text != null) {
                this.category = text.trim();
            }
        } else {
            this.reportProblem("`@category' tag is specified more than once", location);
        }
    }

    public boolean hasCategory() {
        return this.category != null;
    }

    public String getCategory() {
        return this.category != null ? this.category : "";
    }

    public void clear() {
        this.authors.clear();
        this.config = null;
        this.descs.clear();
        this.exceptions.clear();
        this.members.clear();
        this.params.clear();
        this.priority = null;
        this.purpose = null;
        this.reference = null;
        this.remarks.clear();
        this.requirements.clear();
        this.return_ = null;
        this.sees.clear();
        this.since = null;
        this.status = null;
        this.urls.clear();
        this.verdicts.clear();
        this.version = null;
        this.category = null;
    }

    public void parseComment() {
        this.clear();
        StringReader reader = new StringReader(this.comment);
        UnbufferedCharStream charStream = new UnbufferedCharStream((Reader)reader);
        Ttcn3DocCommentLexer lexer = new Ttcn3DocCommentLexer((CharStream)charStream);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        IResource file = this.getLocation().getFile();
        if (file instanceof IFile) {
            lexer.setActualFile((IFile)file);
        }
        CommonTokenStream cts = new CommonTokenStream((TokenSource)lexer);
        Ttcn3DocCommentParser parser = new Ttcn3DocCommentParser((TokenStream)cts);
        parser.setFile((IFile)file);
        parser.setCommentLocation(this.location);
        parser.pr_DocComment(this);
    }

    private void reportProblem(String reason, Location location) {
        String option = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportDocCommentInconsistency", "warning", null);
        location.reportConfigurableSemanticProblem(option, reason);
    }
}

