/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import org.eclipse.swt.graphics.Color;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.ui.core.PortEventNode;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;

public class PortMapping
extends PortEventNode {
    public PortMapping(String sourcePort, String targetPort) {
        super(sourcePort, targetPort);
    }

    @Override
    public MSCNode.Type getType() {
        return MSCNode.Type.PORT_MAPPING;
    }

    @Override
    public void drawSymbol(IGC context, int x, int y, int direction) {
        context.setForeground((Color)Activator.getDefault().getCachedResource("COLOR_SOFT_BLUE"));
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_SOFT_BLUE"));
        context.fillPolygon(this.drawPolygon(x, y, direction));
        int tempX = x - this.getWidth();
        tempX = direction == 1 ? (tempX += 8) : (tempX -= 8);
        context.fillPolygon(this.drawPolygon(tempX, y, direction));
        this.setSymbolText(direction);
    }

    @Override
    public void drawSymbol(IGC context, int xLeft, int xRight, int yTop, int yBottom, int direction) {
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_SOFT_BLUE"));
        context.fillPolygon(this.drawPolygon(xLeft, yBottom, direction));
        context.fillPolygon(this.drawPolygon(xLeft, yTop, direction));
        this.setSymbolText(direction);
    }

    private void setSymbolText(int direction) {
        if (this.sourcePort.contentEquals(this.targetPort)) {
            this.setName(this.sourcePort);
        } else if (direction == 1) {
            this.setName(this.sourcePort + " -> " + this.targetPort);
        } else {
            this.setName(this.targetPort + " <- " + this.sourcePort);
        }
    }

    private int[] drawPolygon(int x, int y, int direction) {
        int[] points = new int[]{x - direction * 8 / 2, y - 4, x - direction * 8, y, x - direction * 8 / 2, y + 4, x, y};
        return points;
    }
}

