/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.titan.runtime.core.LoggerPluginManager;
import org.eclipse.titan.runtime.core.LoggingParam;
import org.eclipse.titan.runtime.core.TTCN_Communication;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanComponent;
import org.eclipse.titan.runtime.core.TitanLoggerApi;
import org.eclipse.titan.runtime.core.TitanPort;
import org.eclipse.titan.runtime.core.TitanVerdictType;

public final class TTCN_Logger {
    private static LoggerPluginManager plugins_;
    private static log_mask_struct console_log_mask;
    private static log_mask_struct file_log_mask;
    private static log_mask_struct emergency_log_mask;
    private static timestamp_format_t timestamp_format;
    private static source_info_format_t source_info_format;
    private static log_event_types_t log_event_types;
    private static final Calendar calendar;
    private static final String[] month_names;
    private static long start_time;
    private static String executable_name;
    private static log_event_types_t log_entity_name;
    private static data_log_format_t data_log_format;
    public static final Severity[] sev_categories;
    public static final String[] severity_category_names;
    public static final String[] severity_subcategory_names;
    public static final int majorVersion = 2;
    public static final int minorVersion = 2;
    static StringBuilder logMatchBuffer;
    static boolean logMatchPrinted;
    static matching_verbosity_t matching_verbosity;
    static emergency_logging_behaviour_t emergency_logging_behaviour;
    static boolean emergency_logging_for_fail_verdict;
    static int emergency_logging;
    private static long lastTimestamp;
    private static String lastPrintedTime;

    public static void set_matching_verbosity(matching_verbosity_t v) {
        matching_verbosity = v;
    }

    private static LoggerPluginManager get_logger_plugin_manager() {
        if (plugins_ == null) {
            plugins_ = new LoggerPluginManager();
        }
        return plugins_;
    }

    public static void mput_severity(StringBuilder str, Severity severity) {
        switch (severity) {
            case ACTION_UNQUALIFIED: {
                str.append("ACTION");
                break;
            }
            case DEFAULTOP_UNQUALIFIED: 
            case DEFAULTOP_ACTIVATE: 
            case DEFAULTOP_DEACTIVATE: 
            case DEFAULTOP_EXIT: {
                str.append("DEFAULTOP");
                break;
            }
            case ERROR_UNQUALIFIED: {
                str.append("ERROR");
                break;
            }
            case EXECUTOR_UNQUALIFIED: 
            case EXECUTOR_RUNTIME: 
            case EXECUTOR_CONFIGDATA: 
            case EXECUTOR_EXTCOMMAND: 
            case EXECUTOR_COMPONENT: 
            case EXECUTOR_LOGOPTIONS: {
                str.append("EXECUTOR");
                break;
            }
            case FUNCTION_UNQUALIFIED: 
            case FUNCTION_RND: {
                str.append("FUNCTION");
                break;
            }
            case PARALLEL_UNQUALIFIED: 
            case PARALLEL_PTC: 
            case PARALLEL_PORTCONN: 
            case PARALLEL_PORTMAP: {
                str.append("PARALLEL");
                break;
            }
            case TESTCASE_UNQUALIFIED: 
            case TESTCASE_START: 
            case TESTCASE_FINISH: {
                str.append("TESTCASE");
                break;
            }
            case PORTEVENT_UNQUALIFIED: 
            case PORTEVENT_PQUEUE: 
            case PORTEVENT_MQUEUE: 
            case PORTEVENT_STATE: 
            case PORTEVENT_PMIN: 
            case PORTEVENT_PMOUT: 
            case PORTEVENT_PCIN: 
            case PORTEVENT_PCOUT: 
            case PORTEVENT_MMRECV: 
            case PORTEVENT_MMSEND: 
            case PORTEVENT_MCRECV: 
            case PORTEVENT_MCSEND: 
            case PORTEVENT_DUALRECV: 
            case PORTEVENT_DUALSEND: 
            case PORTEVENT_SETSTATE: {
                str.append("PORTEVENT");
                break;
            }
            case STATISTICS_UNQUALIFIED: 
            case STATISTICS_VERDICT: {
                str.append("STATISTICS");
                break;
            }
            case TIMEROP_UNQUALIFIED: 
            case TIMEROP_READ: 
            case TIMEROP_START: 
            case TIMEROP_GUARD: 
            case TIMEROP_STOP: 
            case TIMEROP_TIMEOUT: {
                str.append("TIMEROP");
                break;
            }
            case USER_UNQUALIFIED: {
                str.append("USER");
                break;
            }
            case VERDICTOP_UNQUALIFIED: 
            case VERDICTOP_GETVERDICT: 
            case VERDICTOP_SETVERDICT: 
            case VERDICTOP_FINAL: {
                str.append("VERDICTOP");
                break;
            }
            case WARNING_UNQUALIFIED: {
                str.append("WARNING");
                break;
            }
            case MATCHING_UNQUALIFIED: 
            case MATCHING_DONE: 
            case MATCHING_TIMEOUT: 
            case MATCHING_PCSUCCESS: 
            case MATCHING_PCUNSUCC: 
            case MATCHING_PMSUCCESS: 
            case MATCHING_PMUNSUCC: 
            case MATCHING_MCSUCCESS: 
            case MATCHING_MCUNSUCC: 
            case MATCHING_MMSUCCESS: 
            case MATCHING_MMUNSUCC: 
            case MATCHING_PROBLEM: {
                str.append("MATCHING");
                break;
            }
            case DEBUG_UNQUALIFIED: 
            case DEBUG_ENCDEC: 
            case DEBUG_TESTPORT: 
            case DEBUG_USER: 
            case DEBUG_FRAMEWORK: {
                str.append("DEBUG");
                break;
            }
            case LOG_ALL_IMPORTANT: 
            case NUMBER_OF_LOGSEVERITIES: 
            case NOTHING_TO_LOG: {
                str.append("UNKNOWN");
            }
        }
    }

    public static void mputstr_timestamp(StringBuilder str, timestamp_format_t p_timestamp_format, long seconds, int microseconds) {
        switch (p_timestamp_format) {
            case TIMESTAMP_SECONDS: {
                long newSeconds = seconds;
                long startSeconds = start_time / 1000L;
                long startMicroSeconds = start_time % 1000L;
                if ((long)microseconds < startMicroSeconds) {
                    str.append(String.format("%d", newSeconds - startSeconds - 1L)).append('.').append(String.format("%03d", (long)microseconds + (1000L - startMicroSeconds)));
                    break;
                }
                str.append(String.format("%d", newSeconds - startSeconds)).append('.').append(String.format("%03d", (long)microseconds - startMicroSeconds)).append("000");
                break;
            }
            case TIMESTAMP_TIME: {
                long timestamp = seconds * 1000L + (long)(microseconds / 1000);
                if (timestamp != lastTimestamp) {
                    calendar.setTimeInMillis(timestamp);
                    StringBuilder temp = new StringBuilder();
                    temp.append(String.format("%02d", calendar.get(11))).append(':').append(String.format("%02d", calendar.get(12))).append(':').append(String.format("%02d", calendar.get(13))).append('.').append(String.format("%03d", microseconds));
                    lastPrintedTime = temp.toString();
                    lastTimestamp = timestamp;
                }
                str.append(lastPrintedTime);
                break;
            }
            case TIMESTAMP_DATETIME: {
                long timestamp = seconds * 1000L + (long)(microseconds / 1000);
                if (timestamp != lastTimestamp) {
                    calendar.setTimeInMillis(timestamp);
                    StringBuilder temp = new StringBuilder();
                    temp.append(String.format("%4d", calendar.get(1))).append('/').append(month_names[calendar.get(2)]).append('/').append(String.format("%02d", calendar.get(5)));
                    temp.append(' ');
                    temp.append(String.format("%02d", calendar.get(11))).append(':').append(String.format("%02d", calendar.get(12))).append(':').append(String.format("%02d", calendar.get(13))).append('.').append(String.format("%03d", microseconds));
                    lastPrintedTime = temp.toString();
                    lastTimestamp = timestamp;
                }
                str.append(lastPrintedTime);
                break;
            }
        }
    }

    public static void fatal_error(String msg) {
        System.err.print("Fatal error during logging: ");
        System.err.print(msg);
        System.err.println(" Exiting.");
        System.exit(-1);
    }

    public static void initialize_logger() {
        TTCN_Logger.console_log_mask.component_id.id_selector = component_id_selector_enum.COMPONENT_ID_ALL;
        TTCN_Logger.console_log_mask.component_id.id_compref = -1;
        TTCN_Logger.console_log_mask.mask = new Logging_Bits(Logging_Bits.default_console_mask);
        TTCN_Logger.file_log_mask.component_id.id_selector = component_id_selector_enum.COMPONENT_ID_ALL;
        TTCN_Logger.file_log_mask.component_id.id_compref = -2;
        TTCN_Logger.file_log_mask.mask = new Logging_Bits(Logging_Bits.log_all);
        TTCN_Logger.emergency_log_mask.component_id.id_selector = component_id_selector_enum.COMPONENT_ID_ALL;
        TTCN_Logger.emergency_log_mask.component_id.id_compref = -1;
        TTCN_Logger.emergency_log_mask.mask = new Logging_Bits(Logging_Bits.log_all);
    }

    public static void terminate_logger() {
        if (plugins_ != null) {
            plugins_.destructor();
        }
    }

    public static void log(Severity msg_severity, String formatString, Object ... args) {
        TTCN_Logger.log_va_list(msg_severity, formatString, args);
    }

    public static void send_event_as_error() {
        String error_msg = TTCN_Logger.get_logger_plugin_manager().get_current_event_str();
        if (error_msg == null) {
            return;
        }
        if (TTCN_Communication.is_mc_connected()) {
            TTCN_Communication.send_error(error_msg);
        } else {
            System.err.println(error_msg);
        }
    }

    public static void log_str(Severity msg_severity, String string) {
        if (!TTCN_Logger.log_this_event(msg_severity) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TTCN_Logger.get_logger_plugin_manager().log_unhandled_event(msg_severity, string == null ? "<NULL pointer>" : string);
        logMatchPrinted = false;
    }

    public static void log_va_list(Severity msg_severity, String formatString, Object ... args) {
        if (!TTCN_Logger.log_this_event(msg_severity) && TTCN_Logger.get_emergency_logging() <= 0) {
            return;
        }
        TTCN_Logger.get_logger_plugin_manager().log_unhandled_event(msg_severity, String.format(Locale.US, formatString, args));
        logMatchPrinted = false;
    }

    public static void begin_event(Severity msg_severity) {
        TTCN_Logger.get_logger_plugin_manager().begin_event(msg_severity);
    }

    public static void begin_event_log2str() {
        TTCN_Logger.get_logger_plugin_manager().begin_event_log2str();
    }

    public static void end_event() {
        TTCN_Logger.get_logger_plugin_manager().end_event();
        logMatchPrinted = false;
    }

    public static TitanCharString end_event_log2str() {
        TitanCharString returnValue = TTCN_Logger.get_logger_plugin_manager().end_event_log2str();
        logMatchPrinted = false;
        return returnValue;
    }

    public static void finish_event() {
        TTCN_Logger.get_logger_plugin_manager().finish_event();
    }

    public static void log_event(String formatString, Object ... args) {
        TTCN_Logger.log_event_va_list(formatString, args);
    }

    public static void log_event_str(String string) {
        TTCN_Logger.get_logger_plugin_manager().log_event_str(string);
        logMatchPrinted = false;
    }

    public static void log_event_va_list(String formatString, Object ... args) {
        TTCN_Logger.get_logger_plugin_manager().log_event_va_list(formatString, args);
        logMatchPrinted = false;
    }

    public static void log_char(char c) {
        TTCN_Logger.get_logger_plugin_manager().log_char(c);
        logMatchPrinted = false;
    }

    public static void log_event_uninitialized() {
        switch (data_log_format) {
            case LF_LEGACY: {
                TTCN_Logger.log_event_str("<uninitialized template>");
                break;
            }
            case LF_TTCN: {
                TTCN_Logger.log_char('-');
                break;
            }
            default: {
                TTCN_Logger.log_event_str("<unknown>");
            }
        }
    }

    public static void log_event_enum(String enum_name_str, int enum_value) {
        switch (data_log_format) {
            case LF_LEGACY: {
                TTCN_Logger.log_event("%s (%d)", enum_name_str, enum_value);
                break;
            }
            case LF_TTCN: {
                TTCN_Logger.log_event_str(enum_name_str);
                break;
            }
            default: {
                TTCN_Logger.log_event_str("<unknown>");
            }
        }
    }

    public static boolean is_printable(char c) {
        if (c >= ' ' && c <= '~') {
            return true;
        }
        switch (c) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': {
                return true;
            }
        }
        return false;
    }

    public static void log_char_escaped(char c, StringBuilder p_buffer) {
        switch (c) {
            case '\n': {
                p_buffer.append("\\n");
                break;
            }
            case '\t': {
                p_buffer.append("\\t");
                break;
            }
            case '\b': {
                p_buffer.append("\\b");
                break;
            }
            case '\r': {
                p_buffer.append("\\r");
                break;
            }
            case '\f': {
                p_buffer.append("\\f");
                break;
            }
            case '\\': {
                p_buffer.append("\\\\");
                break;
            }
            case '\"': {
                p_buffer.append("\\\"");
                break;
            }
            default: {
                if (TTCN_Logger.is_printable(c)) {
                    p_buffer.append(c);
                    break;
                }
                TTCN_Logger.log_event("\\%03o", Character.valueOf(c));
            }
        }
    }

    public static void log_char_escaped(char c) {
        switch (c) {
            case '\n': {
                TTCN_Logger.log_event_str("\\n");
                break;
            }
            case '\t': {
                TTCN_Logger.log_event_str("\\t");
                break;
            }
            case '\b': {
                TTCN_Logger.log_event_str("\\b");
                break;
            }
            case '\r': {
                TTCN_Logger.log_event_str("\\r");
                break;
            }
            case '\f': {
                TTCN_Logger.log_event_str("\\f");
                break;
            }
            case '\\': {
                TTCN_Logger.log_event_str("\\\\");
                break;
            }
            case '\"': {
                TTCN_Logger.log_event_str("\\\"");
                break;
            }
            default: {
                if (TTCN_Logger.is_printable(c)) {
                    TTCN_Logger.log_char(c);
                    break;
                }
                TTCN_Logger.log_event("\\%03o", Character.valueOf(c));
            }
        }
    }

    public static void log_hex(byte aHexDigit) {
        if (aHexDigit < 16) {
            TTCN_Logger.log_char("0123456789ABCDEF?*".charAt(aHexDigit));
        } else {
            TTCN_Logger.log_event_str("<unknown>");
        }
    }

    public static void log_event_unbound() {
        switch (data_log_format) {
            case LF_LEGACY: {
                TTCN_Logger.log_event_str("<unbound>");
                break;
            }
            case LF_TTCN: {
                TTCN_Logger.log_char('-');
                break;
            }
            default: {
                TTCN_Logger.log_event_str("<unknown>");
            }
        }
    }

    public static void log_octet(byte aOctet) {
        TTCN_Logger.log_char("0123456789ABCDEF?*".charAt((aOctet & 0xF0) >> 4));
        TTCN_Logger.log_char("0123456789ABCDEF?*".charAt(aOctet & 0xF));
    }

    public static void ring_buffer_dump(boolean do_close_file) {
        TTCN_Logger.get_logger_plugin_manager().ring_buffer_dump(do_close_file);
    }

    public static matching_verbosity_t get_matching_verbosity() {
        return matching_verbosity;
    }

    public static boolean log_this_event(Severity event_severity) {
        if (TTCN_Logger.should_log_to_file(event_severity)) {
            return true;
        }
        if (TTCN_Logger.should_log_to_console(event_severity)) {
            return true;
        }
        return TTCN_Logger.should_log_to_emergency(event_severity) && TTCN_Logger.get_emergency_logging() > 0;
    }

    static String get_logger_settings_str() {
        StringBuilder new_log_message = new StringBuilder();
        String[] timestamp_format_names = new String[]{"Time", "DateTime", "Seconds"};
        String[] logeventtype_names = new String[]{"No", "Yes", "Subcategories"};
        String[] source_info_format_names = new String[]{"None", "Single", "Stack"};
        String filemask_origin = TTCN_Logger.component_string(TTCN_Logger.file_log_mask.component_id);
        String consolemask_origin = TTCN_Logger.component_string(TTCN_Logger.console_log_mask.component_id);
        String filemask_description = TTCN_Logger.file_log_mask.mask.describe();
        String consolemask_description = TTCN_Logger.console_log_mask.mask.describe();
        new_log_message.append(MessageFormat.format("TTCN Logger v{0}.{1} options: ", 2, 2));
        new_log_message.append(MessageFormat.format("TimeStampFormat:={0}; LogEntityName:={1}; LogEventTypes:={2};", timestamp_format_names[timestamp_format.ordinal()], logeventtype_names[log_entity_name.ordinal()], logeventtype_names[log_event_types.ordinal()]));
        new_log_message.append(MessageFormat.format("SourceInfoFormat:={0}; {1}.FileMask:={2}; {3}.ConsoleMask:={4};", source_info_format_names[source_info_format.ordinal()], filemask_origin, filemask_description, consolemask_origin, consolemask_description));
        return new_log_message.toString();
    }

    public static void write_logger_settings() {
        String new_log_message = TTCN_Logger.get_logger_settings_str();
        TTCN_Logger.get_logger_plugin_manager().log_log_options(new_log_message);
    }

    public static boolean should_log_to_file(Severity sev) {
        return TTCN_Logger.file_log_mask.mask.bits[sev.ordinal()];
    }

    public static boolean should_log_to_console(Severity sev) {
        if (sev == Severity.EXECUTOR_EXTCOMMAND) {
            return true;
        }
        return TTCN_Logger.console_log_mask.mask.bits[sev.ordinal()];
    }

    public static boolean should_log_to_emergency(Severity sev) {
        return TTCN_Logger.emergency_log_mask.mask.bits[sev.ordinal()];
    }

    public static void set_timestamp_format(timestamp_format_t new_timestamp_format) {
        timestamp_format = new_timestamp_format;
    }

    public static timestamp_format_t get_timestamp_format() {
        return timestamp_format;
    }

    public static void set_source_info_format(source_info_format_t new_source_info_format) {
        source_info_format = new_source_info_format;
    }

    public static source_info_format_t get_source_info_format() {
        return source_info_format;
    }

    public static void set_log_event_types(log_event_types_t new_log_event_types) {
        log_event_types = new_log_event_types;
    }

    public static log_event_types_t get_log_event_types() {
        return log_event_types;
    }

    public static void set_log_entity_name(log_event_types_t new_log_entity_name) {
        log_entity_name = new_log_entity_name;
    }

    public static log_event_types_t get_log_entity_name() {
        return log_entity_name;
    }

    public static data_log_format_t get_log_format() {
        return data_log_format;
    }

    public static void set_log_format(data_log_format_t p_data_log_format) {
        data_log_format = p_data_log_format;
    }

    public static void print_logmatch_buffer() {
        if (logMatchPrinted) {
            TTCN_Logger.log_event_str(" , ");
        } else {
            logMatchPrinted = true;
        }
        if (logMatchBuffer.length() > 0) {
            TTCN_Logger.log_event_str(logMatchBuffer.toString());
        }
    }

    public static void log_logmatch_info(String formatString, Object ... args) {
        if (formatString == null) {
            logMatchBuffer.append("<NULL format string>");
        } else {
            logMatchBuffer.append(String.format(Locale.US, formatString, args));
        }
    }

    public static void set_logmatch_buffer_len(int previous_size) {
        logMatchBuffer.setLength(previous_size);
    }

    public static int get_logmatch_buffer_len() {
        return logMatchBuffer.length();
    }

    public static void log_unhandled_event(Severity severity, String message) {
        TTCN_Logger.get_logger_plugin_manager().log_unhandled_event(severity, message);
    }

    public static void log_timer_read(String timer_name, double timeout_val) {
        TTCN_Logger.get_logger_plugin_manager().log_timer_read(timer_name, timeout_val);
    }

    public static void log_timer_start(String timer_name, double start_val) {
        TTCN_Logger.get_logger_plugin_manager().log_timer_start(timer_name, start_val);
    }

    public static void log_timer_guard(double start_val) {
        TTCN_Logger.get_logger_plugin_manager().log_timer_guard(start_val);
    }

    public static void log_timer_stop(String timer_name, double stop_val) {
        TTCN_Logger.get_logger_plugin_manager().log_timer_stop(timer_name, stop_val);
    }

    public static void log_timer_timeout(String timer_name, double timeout_val) {
        TTCN_Logger.get_logger_plugin_manager().log_timer_timeout(timer_name, timeout_val);
    }

    public static void log_timer_any_timeout() {
        TTCN_Logger.get_logger_plugin_manager().log_timer_any_timeout();
    }

    public static void log_timer_unqualified(String message) {
        TTCN_Logger.get_logger_plugin_manager().log_timer_unqualified(message);
    }

    public static void log_matching_timeout(String timer_name) {
        TTCN_Logger.get_logger_plugin_manager().log_matching_timeout(timer_name);
    }

    public static void log_port_queue(TitanLoggerApi.Port__Queue_operation.enum_type operation, String port_name, int componentReference, int id, TitanCharString address, TitanCharString parameter) {
        TTCN_Logger.get_logger_plugin_manager().log_port_queue(operation, port_name, componentReference, id, address, parameter);
    }

    public static boolean add_parameter(LoggingParam.logging_setting_t logging_param) {
        return TTCN_Logger.get_logger_plugin_manager().add_parameter(logging_param);
    }

    public static void set_plugin_parameters(TitanComponent component_reference, String component_name) {
        TTCN_Logger.get_logger_plugin_manager().set_parameters(component_reference, component_name);
    }

    public static void set_file_name(String new_filename_skeleton, boolean from_config) {
        TTCN_Logger.get_logger_plugin_manager().set_file_name(new_filename_skeleton, from_config);
    }

    public static void set_start_time() {
        start_time = System.currentTimeMillis();
    }

    public static void set_file_mask(component_id_t cmpt, Logging_Bits new_file_mask) {
        if (TTCN_Logger.file_log_mask.component_id.id_selector == component_id_selector_enum.COMPONENT_ID_COMPREF && cmpt.id_selector == component_id_selector_enum.COMPONENT_ID_ALL) {
            return;
        }
        TTCN_Logger.file_log_mask.mask = new_file_mask;
        if (cmpt.id_selector == component_id_selector_enum.COMPONENT_ID_NAME) {
            TTCN_Logger.file_log_mask.component_id.id_selector = component_id_selector_enum.COMPONENT_ID_NAME;
            TTCN_Logger.file_log_mask.component_id.id_name = cmpt.id_name;
        } else {
            TTCN_Logger.file_log_mask.component_id = cmpt;
        }
    }

    public static void set_console_mask(component_id_t cmpt, Logging_Bits new_console_mask) {
        if (TTCN_Logger.console_log_mask.component_id.id_selector == component_id_selector_enum.COMPONENT_ID_COMPREF && cmpt.id_selector == component_id_selector_enum.COMPONENT_ID_ALL) {
            return;
        }
        TTCN_Logger.console_log_mask.mask = new_console_mask;
        if (cmpt.id_selector == component_id_selector_enum.COMPONENT_ID_NAME) {
            TTCN_Logger.console_log_mask.component_id.id_selector = component_id_selector_enum.COMPONENT_ID_NAME;
            TTCN_Logger.console_log_mask.component_id.id_name = cmpt.id_name;
        } else {
            TTCN_Logger.console_log_mask.component_id = cmpt;
        }
    }

    public static void set_emergency_logging_mask(component_id_t cmpt, Logging_Bits new_logging_mask) {
        if (TTCN_Logger.emergency_log_mask.component_id.id_selector == component_id_selector_enum.COMPONENT_ID_COMPREF && cmpt.id_selector == component_id_selector_enum.COMPONENT_ID_ALL) {
            return;
        }
        TTCN_Logger.emergency_log_mask.mask = new_logging_mask;
        if (cmpt.id_selector == component_id_selector_enum.COMPONENT_ID_NAME) {
            TTCN_Logger.emergency_log_mask.component_id.id_selector = component_id_selector_enum.COMPONENT_ID_NAME;
            TTCN_Logger.emergency_log_mask.component_id.id_name = cmpt.id_name;
        } else {
            TTCN_Logger.emergency_log_mask.component_id = cmpt;
        }
    }

    public static void set_append_file(boolean new_append_file) {
        TTCN_Logger.get_logger_plugin_manager().set_append_file(new_append_file);
    }

    public static boolean set_file_size(int p_size) {
        return TTCN_Logger.get_logger_plugin_manager().set_file_size(p_size);
    }

    public static boolean set_file_number(int p_number) {
        return TTCN_Logger.get_logger_plugin_manager().set_file_number(p_number);
    }

    public static boolean set_disk_full_action(disk_full_action_type_t p_disk_full_action_type) {
        return TTCN_Logger.set_disk_full_action(p_disk_full_action_type, 0);
    }

    public static boolean set_disk_full_action(disk_full_action_type_t p_disk_full_action_type, int p_retry_interval) {
        disk_full_action_t disk_full_action = new disk_full_action_t(p_disk_full_action_type, p_retry_interval);
        return TTCN_Logger.get_logger_plugin_manager().set_disk_full_action(disk_full_action);
    }

    public static void reset_configuration() {
        TTCN_Logger.file_log_mask.mask = Logging_Bits.log_all;
        TTCN_Logger.console_log_mask.mask = Logging_Bits.default_console_mask;
        TTCN_Logger.emergency_log_mask.mask = Logging_Bits.log_all;
        timestamp_format = timestamp_format_t.TIMESTAMP_TIME;
        source_info_format = source_info_format_t.SINFO_NONE;
        log_event_types = log_event_types_t.LOGEVENTTYPES_NO;
        log_entity_name = log_event_types_t.LOGEVENTTYPES_NO;
        TTCN_Logger.get_logger_plugin_manager().reset();
    }

    public static void set_executable_name(String name) {
        executable_name = name;
    }

    public static String get_executable_name() {
        return executable_name;
    }

    public static void open_file() {
        TTCN_Logger.get_logger_plugin_manager().open_file();
    }

    public static void close_file() {
        TTCN_Logger.get_logger_plugin_manager().close_file();
    }

    public static void set_emergency_logging_behaviour(emergency_logging_behaviour_t behaviour) {
        emergency_logging_behaviour = behaviour;
    }

    public static emergency_logging_behaviour_t get_emergency_logging_behaviour() {
        return emergency_logging_behaviour;
    }

    public static int get_emergency_logging() {
        return emergency_logging;
    }

    public static void set_emergency_logging(int size) {
        emergency_logging = size;
    }

    public static boolean get_emergency_logging_for_fail_verdict() {
        return emergency_logging_for_fail_verdict;
    }

    public static void set_emergency_logging_for_fail_verdict(boolean b) {
        emergency_logging_for_fail_verdict = b;
    }

    public static void log_port_state(TitanLoggerApi.Port__State_operation.enum_type operation, String portname) {
        TTCN_Logger.get_logger_plugin_manager().log_port_state(operation, portname);
    }

    public static void log_procport_send(String portname, TitanLoggerApi.Port__oper.enum_type operation, int componentReference, TitanCharString system, TitanCharString parameter) {
        TTCN_Logger.get_logger_plugin_manager().log_procport_send(portname, operation, componentReference, system, parameter);
    }

    public static void log_procport_recv(String portname, TitanLoggerApi.Port__oper.enum_type operation, int componentReference, boolean check, TitanCharString parameter, int id) {
        TTCN_Logger.get_logger_plugin_manager().log_procport_recv(portname, operation, componentReference, check, parameter, id);
    }

    public static void log_msgport_send(String portname, int componentReference, TitanCharString parameter) {
        TTCN_Logger.get_logger_plugin_manager().log_msgport_send(portname, componentReference, parameter);
    }

    public static void log_msgport_recv(String portname, TitanLoggerApi.Msg__port__recv_operation.enum_type operation, int componentReference, TitanCharString system, TitanCharString parameter, int id) {
        TTCN_Logger.get_logger_plugin_manager().log_msgport_recv(portname, operation, componentReference, system, parameter, id);
    }

    public static void log_dualport_map(boolean incoming, String target_type, TitanCharString value, int id) {
        TTCN_Logger.get_logger_plugin_manager().log_dualport_map(incoming, target_type, value, id);
    }

    public static void log_dualport_discard(boolean incoming, String target_type, TitanCharString port_name, boolean unhandled) {
        TTCN_Logger.get_logger_plugin_manager().log_dualport_discard(incoming, target_type, port_name, unhandled);
    }

    public static void log_dualport_discard(boolean incoming, String target_type, String port_name, boolean unhandled) {
        TTCN_Logger.get_logger_plugin_manager().log_dualport_discard(incoming, target_type, port_name, unhandled);
    }

    public static void log_setstate(String port_name, TitanPort.translation_port_state state, TitanCharString info) {
        TTCN_Logger.get_logger_plugin_manager().log_setstate(port_name, state, info);
    }

    public static void log_setverdict(TitanVerdictType.VerdictTypeEnum newVerdict, TitanVerdictType.VerdictTypeEnum oldVerdict, TitanVerdictType.VerdictTypeEnum localVerdict, String oldReason, String newReason) {
        TTCN_Logger.get_logger_plugin_manager().log_setverdict(newVerdict, oldVerdict, localVerdict, oldReason, newReason);
    }

    public static void log_getverdict(TitanVerdictType.VerdictTypeEnum verdict) {
        TTCN_Logger.get_logger_plugin_manager().log_getverdict(verdict);
    }

    public static void log_testcase_started(String module_name, String definition_name) {
        TTCN_Logger.get_logger_plugin_manager().log_testcase_started(module_name, definition_name);
    }

    public static void log_testcase_finished(String module_name, String definition_name, TitanVerdictType.VerdictTypeEnum verdict, String reason) {
        TTCN_Logger.get_logger_plugin_manager().log_testcase_finished(module_name, definition_name, verdict, reason);
    }

    public static void log_final_verdict(boolean is_ptc, TitanVerdictType.VerdictTypeEnum ptc_verditc, TitanVerdictType.VerdictTypeEnum local_verdict, TitanVerdictType.VerdictTypeEnum new_verdict, String verdict_reason, int notification, int ptc_compref, String ptc_name) {
        TTCN_Logger.get_logger_plugin_manager().log_final_verdict(is_ptc, ptc_verditc, local_verdict, new_verdict, verdict_reason, notification, ptc_compref, ptc_name);
    }

    public static void log_controlpart_start_stop(String moduleName, boolean finished) {
        TTCN_Logger.get_logger_plugin_manager().log_controlpart_start_stop(moduleName, finished);
    }

    public static void log_controlpart_errors(int error_count) {
        TTCN_Logger.get_logger_plugin_manager().log_controlpart_errors(error_count);
    }

    public static void log_verdict_statistics(int none_count, double none_percent, int pass_count, double pass_percent, int inconc_count, double inconc_percent, int fail_count, double fail_percent, int error_count, double error_percent) {
        TTCN_Logger.get_logger_plugin_manager().log_verdict_statistics(none_count, none_percent, pass_count, pass_percent, inconc_count, inconc_percent, fail_count, fail_percent, error_count, error_percent);
    }

    public static void log_defaultop_activate(String name, int id) {
        TTCN_Logger.get_logger_plugin_manager().log_defaultop_activate(name, id);
    }

    public static void log_defaultop_deactivate(String name, int id) {
        TTCN_Logger.get_logger_plugin_manager().log_defaultop_deactivate(name, id);
    }

    public static void log_defaultop_exit(String name, int id, int x) {
        TTCN_Logger.get_logger_plugin_manager().log_defaultop_exit(name, id, x);
    }

    public static void log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type reason) {
        TTCN_Logger.get_logger_plugin_manager().log_executor_runtime(reason);
    }

    public static void log_hc_start(String host) {
        TTCN_Logger.get_logger_plugin_manager().log_hc_start(host);
    }

    public static void log_testcase_exec(String testcase, String module) {
        TTCN_Logger.get_logger_plugin_manager().log_testcase_exec(testcase, module);
    }

    public static void log_module_init(String module, boolean finish) {
        TTCN_Logger.get_logger_plugin_manager().log_module_init(module, finish);
    }

    public static void log_mtc_created(long pid) {
        TTCN_Logger.get_logger_plugin_manager().log_mtc_created(pid);
    }

    public static void log_configdata(TitanLoggerApi.ExecutorConfigdata_reason.enum_type reason, String str) {
        TTCN_Logger.get_logger_plugin_manager().log_configdata(reason, str);
    }

    public static void log_executor_component(TitanLoggerApi.ExecutorComponent_reason.enum_type reason) {
        TTCN_Logger.get_logger_plugin_manager().log_executor_component(reason);
    }

    public static void log_executor_misc(TitanLoggerApi.ExecutorUnqualified_reason.enum_type reason, String name, String address, int port) {
        TTCN_Logger.get_logger_plugin_manager().log_executor_misc(reason, name, address, port);
    }

    public static void log_extcommand(extcommand_t action, String cmd) {
        TTCN_Logger.get_logger_plugin_manager().log_extcommand(action, cmd);
    }

    public static void log_matching_done(String type, int ptc, String return_type, TitanLoggerApi.MatchingDoneType_reason.enum_type reason) {
        TTCN_Logger.get_logger_plugin_manager().log_matching_done(reason, type, ptc, return_type);
    }

    public static void log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type reason, TitanLoggerApi.MatchingProblemType_operation.enum_type operation, boolean check, boolean anyport, String port_name) {
        TTCN_Logger.get_logger_plugin_manager().log_matching_problem(reason, operation, check, anyport, port_name);
    }

    public static void log_random(TitanLoggerApi.RandomAction.enum_type rndAction, double value, long seed) {
        TTCN_Logger.get_logger_plugin_manager().log_random(rndAction, value, seed);
    }

    public static void log_matching_failure(TitanLoggerApi.PortType.enum_type port_type, String port_name, int compref, TitanLoggerApi.MatchingFailureType_reason.enum_type reason, TitanCharString info) {
        TTCN_Logger.get_logger_plugin_manager().log_matching_failure(port_type, port_name, compref, reason, info);
    }

    public static void log_matching_success(TitanLoggerApi.PortType.enum_type port_type, String port_name, int compref, TitanCharString info) {
        TTCN_Logger.get_logger_plugin_manager().log_matching_success(port_type, port_name, compref, info);
    }

    public static void log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type reason, String port_name, int remote_component, String remote_port, String ip_address, int tcp_port, int new_size) {
        TTCN_Logger.get_logger_plugin_manager().log_port_misc(reason, port_name, remote_component, remote_port, ip_address, tcp_port, new_size);
    }

    public static void log_portconnmap(TitanLoggerApi.ParPort_operation.enum_type operation, int src_compref, String src_port, int dst_compref, String dst_port) {
        TTCN_Logger.get_logger_plugin_manager().log_portconnmap(operation, src_compref, src_port, dst_compref, dst_port);
    }

    public static void log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type reason, String module, String name, int compref, String compname, String tc_loc, int alive_pid, int status) {
        TTCN_Logger.get_logger_plugin_manager().log_parptc(reason, module, name, compref, compname, tc_loc, alive_pid, status);
    }

    public static String component_string(component_id_t comp_id) {
        switch (comp_id.id_selector) {
            case COMPONENT_ID_NAME: {
                return comp_id.id_name;
            }
            case COMPONENT_ID_COMPREF: {
                return Integer.toString(comp_id.id_compref);
            }
            case COMPONENT_ID_ALL: {
                return "*";
            }
            case COMPONENT_ID_SYSTEM: {
                return "<System>";
            }
        }
        return "Unknown component type !";
    }

    static {
        console_log_mask = new log_mask_struct();
        file_log_mask = new log_mask_struct();
        emergency_log_mask = new log_mask_struct();
        timestamp_format = timestamp_format_t.TIMESTAMP_TIME;
        source_info_format = source_info_format_t.SINFO_SINGLE;
        log_event_types = log_event_types_t.LOGEVENTTYPES_NO;
        calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
        month_names = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        log_entity_name = log_event_types_t.LOGEVENTTYPES_NO;
        data_log_format = data_log_format_t.LF_LEGACY;
        sev_categories = new Severity[]{Severity.NOTHING_TO_LOG, Severity.ACTION_UNQUALIFIED, Severity.DEFAULTOP_UNQUALIFIED, Severity.ERROR_UNQUALIFIED, Severity.EXECUTOR_UNQUALIFIED, Severity.FUNCTION_UNQUALIFIED, Severity.PARALLEL_UNQUALIFIED, Severity.TESTCASE_UNQUALIFIED, Severity.PORTEVENT_UNQUALIFIED, Severity.STATISTICS_UNQUALIFIED, Severity.TIMEROP_UNQUALIFIED, Severity.USER_UNQUALIFIED, Severity.VERDICTOP_UNQUALIFIED, Severity.WARNING_UNQUALIFIED, Severity.MATCHING_UNQUALIFIED, Severity.DEBUG_UNQUALIFIED};
        severity_category_names = new String[]{"NULL", "ACTION", "DEFAULTOP", "ERROR", "EXECUTOR", "FUNCTION", "PARALLEL", "TESTCASE", "PORTEVENT", "STATISTICS", "TIMEROP", "USER", "VERDICTOP", "WARNING", "MATCHING", "DEBUG"};
        severity_subcategory_names = new String[]{"", "UNQUALIFIED", "ACTIVATE", "DEACTIVATE", "EXIT", "UNQUALIFIED", "UNQUALIFIED", "RUNTIME", "CONFIGDATA", "EXTCOMMAND", "COMPONENT", "LOGOPTIONS", "UNQUALIFIED", "RND", "UNQUALIFIED", "PTC", "PORTCONN", "PORTMAP", "UNQUALIFIED", "START", "FINISH", "UNQUALIFIED", "PQUEUE", "MQUEUE", "STATE", "PMIN", "PMOUT", "PCIN", "PCOUT", "MMRECV", "MMSEND", "MCRECV", "MCSEND", "DUALRECV", "DUALSEND", "UNQUALIFIED", "SETSTATE", "VERDICT", "UNQUALIFIED", "READ", "START", "GUARD", "STOP", "TIMEOUT", "UNQUALIFIED", "UNQUALIFIED", "GETVERDICT", "SETVERDICT", "FINAL", "UNQUALIFIED", "UNQUALIFIED", "DONE", "TIMEOUT", "PCSUCCESS", "PCUNSUCC", "PMSUCCESS", "PMUNSUCC", "MCSUCCESS", "MCUNSUCC", "MMSUCCESS", "MMUNSUCC", "PROBLEM", "UNQUALIFIED", "ENCDEC", "TESTPORT", "USER", "FRAMEWORK", "UNQUALIFIED"};
        logMatchBuffer = new StringBuilder();
        logMatchPrinted = false;
        matching_verbosity = matching_verbosity_t.VERBOSITY_COMPACT;
        emergency_logging_behaviour = emergency_logging_behaviour_t.BUFFER_MASKED;
        emergency_logging_for_fail_verdict = false;
        emergency_logging = 0;
        lastTimestamp = 0L;
    }

    public static class TTCN_Location {
        String file_name;
        int line_number;
        entity_type_t entity_type;
        String entity_name;
        static final ThreadLocal<ArrayList<TTCN_Location>> locations = new ThreadLocal<ArrayList<TTCN_Location>>(){

            @Override
            protected ArrayList<TTCN_Location> initialValue() {
                return new ArrayList<TTCN_Location>();
            }
        };
        static ThreadLocal<Integer> actualSize = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };

        private TTCN_Location() {
        }

        public static StringBuilder print_location(boolean print_outers, boolean print_innermost, log_event_types_t print_entity_name) {
            StringBuilder builder = new StringBuilder();
            int localSize = actualSize.get();
            ArrayList<TTCN_Location> localLocations = locations.get();
            if (print_outers) {
                for (int i = 0; i < localSize - 1; ++i) {
                    TTCN_Location temp = localLocations.get(i);
                    temp.append_contents(builder, print_entity_name);
                }
            }
            if (print_innermost && localSize > 0) {
                localLocations.get(localSize - 1).append_contents(builder, print_entity_name);
            }
            return builder;
        }

        protected void append_contents(StringBuilder builder, log_event_types_t print_entity_name) {
            if (builder.length() > 0) {
                builder.append("->");
            }
            builder.append(this.file_name).append(':').append(this.line_number);
            switch (this.entity_type) {
                case LOCATION_CONTROLPART: {
                    builder.append(MessageFormat.format("(controlpart:{0})", this.entity_name));
                    break;
                }
                case LOCATION_TESTCASE: {
                    builder.append(MessageFormat.format("(testcase:{0})", this.entity_name));
                    break;
                }
                case LOCATION_ALTSTEP: {
                    builder.append(MessageFormat.format("(altstep:{0})", this.entity_name));
                    break;
                }
                case LOCATION_FUNCTION: {
                    builder.append(MessageFormat.format("(function:{0})", this.entity_name));
                    break;
                }
                case LOCATION_EXTERNALFUNCTION: {
                    builder.append(MessageFormat.format("(externalfunction:{0})", this.entity_name));
                    break;
                }
                case LOCATION_TEMPLATE: {
                    builder.append(MessageFormat.format("(template:{0})", this.entity_name));
                    break;
                }
            }
        }

        public static TTCN_Location enter(String file_name, int line_number, entity_type_t entity_type, String entity_name) {
            TTCN_Location temp;
            if (locations.get().size() > actualSize.get()) {
                temp = locations.get().get(actualSize.get());
            } else {
                temp = new TTCN_Location();
                locations.get().add(temp);
            }
            actualSize.set(actualSize.get() + 1);
            temp.file_name = file_name == null ? "<unknown file>" : file_name;
            temp.line_number = line_number;
            temp.entity_type = entity_type;
            temp.entity_name = entity_name == null ? "<unknown>" : entity_name;
            return temp;
        }

        public void update_lineno(int new_lineno) {
            this.line_number = new_lineno;
        }

        public void leave() {
            actualSize.set(actualSize.get() - 1);
        }

        public static enum entity_type_t {
            LOCATION_UNKNOWN,
            LOCATION_CONTROLPART,
            LOCATION_TESTCASE,
            LOCATION_ALTSTEP,
            LOCATION_FUNCTION,
            LOCATION_EXTERNALFUNCTION,
            LOCATION_TEMPLATE;

        }
    }

    public static enum Severity {
        NOTHING_TO_LOG,
        ACTION_UNQUALIFIED,
        DEFAULTOP_ACTIVATE,
        DEFAULTOP_DEACTIVATE,
        DEFAULTOP_EXIT,
        DEFAULTOP_UNQUALIFIED,
        ERROR_UNQUALIFIED,
        EXECUTOR_RUNTIME,
        EXECUTOR_CONFIGDATA,
        EXECUTOR_EXTCOMMAND,
        EXECUTOR_COMPONENT,
        EXECUTOR_LOGOPTIONS,
        EXECUTOR_UNQUALIFIED,
        FUNCTION_RND,
        FUNCTION_UNQUALIFIED,
        PARALLEL_PTC,
        PARALLEL_PORTCONN,
        PARALLEL_PORTMAP,
        PARALLEL_UNQUALIFIED,
        TESTCASE_START,
        TESTCASE_FINISH,
        TESTCASE_UNQUALIFIED,
        PORTEVENT_PQUEUE,
        PORTEVENT_MQUEUE,
        PORTEVENT_STATE,
        PORTEVENT_PMIN,
        PORTEVENT_PMOUT,
        PORTEVENT_PCIN,
        PORTEVENT_PCOUT,
        PORTEVENT_MMRECV,
        PORTEVENT_MMSEND,
        PORTEVENT_MCRECV,
        PORTEVENT_MCSEND,
        PORTEVENT_DUALRECV,
        PORTEVENT_DUALSEND,
        PORTEVENT_UNQUALIFIED,
        PORTEVENT_SETSTATE,
        STATISTICS_VERDICT,
        STATISTICS_UNQUALIFIED,
        TIMEROP_READ,
        TIMEROP_START,
        TIMEROP_GUARD,
        TIMEROP_STOP,
        TIMEROP_TIMEOUT,
        TIMEROP_UNQUALIFIED,
        USER_UNQUALIFIED,
        VERDICTOP_GETVERDICT,
        VERDICTOP_SETVERDICT,
        VERDICTOP_FINAL,
        VERDICTOP_UNQUALIFIED,
        WARNING_UNQUALIFIED,
        MATCHING_DONE,
        MATCHING_TIMEOUT,
        MATCHING_PCSUCCESS,
        MATCHING_PCUNSUCC,
        MATCHING_PMSUCCESS,
        MATCHING_PMUNSUCC,
        MATCHING_MCSUCCESS,
        MATCHING_MCUNSUCC,
        MATCHING_MMSUCCESS,
        MATCHING_MMUNSUCC,
        MATCHING_PROBLEM,
        MATCHING_UNQUALIFIED,
        DEBUG_ENCDEC,
        DEBUG_TESTPORT,
        DEBUG_USER,
        DEBUG_FRAMEWORK,
        DEBUG_UNQUALIFIED,
        NUMBER_OF_LOGSEVERITIES,
        LOG_ALL_IMPORTANT;

    }

    public static enum data_log_format_t {
        LF_LEGACY,
        LF_TTCN;

    }

    public static enum extcommand_t {
        EXTCOMMAND_START,
        EXTCOMMAND_SUCCESS;

    }

    public static enum matching_verbosity_t {
        VERBOSITY_COMPACT,
        VERBOSITY_FULL;

    }

    public static enum emergency_logging_behaviour_t {
        BUFFER_ALL,
        BUFFER_MASKED;

    }

    public static enum log_event_types_t {
        LOGEVENTTYPES_NO,
        LOGEVENTTYPES_YES,
        LOGEVENTTYPES_SUBCATEGORIES;

    }

    public static enum source_info_format_t {
        SINFO_NONE,
        SINFO_SINGLE,
        SINFO_STACK;

    }

    public static enum timestamp_format_t {
        TIMESTAMP_TIME,
        TIMESTAMP_DATETIME,
        TIMESTAMP_SECONDS;

    }

    public static enum disk_full_action_type_t {
        DISKFULL_ERROR,
        DISKFULL_STOP,
        DISKFULL_RETRY,
        DISKFULL_DELETE;

    }

    public static class disk_full_action_t {
        disk_full_action_type_t type;
        int retry_interval;

        public disk_full_action_t(disk_full_action_type_t disk_type, int retry) {
            this.type = disk_type;
            this.retry_interval = retry;
        }
    }

    public static class log_mask_struct {
        component_id_t component_id = new component_id_t();
        Logging_Bits mask = new Logging_Bits();
    }

    public static class component_id_t {
        public component_id_selector_enum id_selector = component_id_selector_enum.COMPONENT_ID_ALL;
        public int id_compref;
        public String id_name;
    }

    public static enum component_id_selector_enum {
        COMPONENT_ID_NAME,
        COMPONENT_ID_COMPREF,
        COMPONENT_ID_ALL,
        COMPONENT_ID_SYSTEM;

    }

    public static class Logging_Bits {
        public static final Logging_Bits log_nothing = new Logging_Bits();
        public static final Logging_Bits log_all = new Logging_Bits();
        public static final Logging_Bits log_everything = new Logging_Bits();
        public static final Logging_Bits default_console_mask = new Logging_Bits();
        public final boolean[] bits = new boolean[Severity.values().length];

        public Logging_Bits() {
        }

        public Logging_Bits(Logging_Bits other) {
            System.arraycopy(other.bits, 0, this.bits, 0, other.bits.length);
        }

        private void addBit(Severity loggingBit) {
            this.bits[loggingBit.ordinal()] = true;
        }

        public void addBitmask(Logging_Bits loggingBitmask) {
            for (int i = 0; i < Severity.NUMBER_OF_LOGSEVERITIES.ordinal(); ++i) {
                if (!loggingBitmask.bits[i]) continue;
                this.bits[i] = true;
            }
        }

        public void add(Severity loggingBit) {
            this.addBit(loggingBit);
            switch (loggingBit) {
                case ACTION_UNQUALIFIED: {
                    this.addBit(Severity.ACTION_UNQUALIFIED);
                    break;
                }
                case DEFAULTOP_UNQUALIFIED: {
                    this.addBit(Severity.DEFAULTOP_ACTIVATE);
                    this.addBit(Severity.DEFAULTOP_DEACTIVATE);
                    this.addBit(Severity.DEFAULTOP_EXIT);
                    this.addBit(Severity.DEFAULTOP_UNQUALIFIED);
                    break;
                }
                case ERROR_UNQUALIFIED: {
                    this.addBit(Severity.ERROR_UNQUALIFIED);
                    break;
                }
                case EXECUTOR_UNQUALIFIED: {
                    this.addBit(Severity.EXECUTOR_RUNTIME);
                    this.addBit(Severity.EXECUTOR_CONFIGDATA);
                    this.addBit(Severity.EXECUTOR_EXTCOMMAND);
                    this.addBit(Severity.EXECUTOR_COMPONENT);
                    this.addBit(Severity.EXECUTOR_LOGOPTIONS);
                    this.addBit(Severity.EXECUTOR_UNQUALIFIED);
                    break;
                }
                case FUNCTION_UNQUALIFIED: {
                    this.addBit(Severity.FUNCTION_RND);
                    this.addBit(Severity.FUNCTION_UNQUALIFIED);
                    break;
                }
                case PARALLEL_UNQUALIFIED: {
                    this.addBit(Severity.PARALLEL_PTC);
                    this.addBit(Severity.PARALLEL_PORTCONN);
                    this.addBit(Severity.PARALLEL_PORTMAP);
                    this.addBit(Severity.PARALLEL_UNQUALIFIED);
                    break;
                }
                case PORTEVENT_UNQUALIFIED: {
                    this.addBit(Severity.PORTEVENT_PQUEUE);
                    this.addBit(Severity.PORTEVENT_MQUEUE);
                    this.addBit(Severity.PORTEVENT_STATE);
                    this.addBit(Severity.PORTEVENT_PMIN);
                    this.addBit(Severity.PORTEVENT_PMOUT);
                    this.addBit(Severity.PORTEVENT_PCIN);
                    this.addBit(Severity.PORTEVENT_PCOUT);
                    this.addBit(Severity.PORTEVENT_MMRECV);
                    this.addBit(Severity.PORTEVENT_MMSEND);
                    this.addBit(Severity.PORTEVENT_MCRECV);
                    this.addBit(Severity.PORTEVENT_MCSEND);
                    this.addBit(Severity.PORTEVENT_DUALRECV);
                    this.addBit(Severity.PORTEVENT_DUALSEND);
                    this.addBit(Severity.PORTEVENT_UNQUALIFIED);
                    this.addBit(Severity.PORTEVENT_SETSTATE);
                    break;
                }
                case TESTCASE_UNQUALIFIED: {
                    this.addBit(Severity.TESTCASE_START);
                    this.addBit(Severity.TESTCASE_FINISH);
                    this.addBit(Severity.TESTCASE_UNQUALIFIED);
                    break;
                }
                case TIMEROP_UNQUALIFIED: {
                    this.addBit(Severity.TIMEROP_READ);
                    this.addBit(Severity.TIMEROP_START);
                    this.addBit(Severity.TIMEROP_GUARD);
                    this.addBit(Severity.TIMEROP_STOP);
                    this.addBit(Severity.TIMEROP_TIMEOUT);
                    this.addBit(Severity.TIMEROP_UNQUALIFIED);
                    break;
                }
                case USER_UNQUALIFIED: {
                    this.addBit(Severity.USER_UNQUALIFIED);
                    break;
                }
                case STATISTICS_UNQUALIFIED: {
                    this.addBit(Severity.STATISTICS_VERDICT);
                    this.addBit(Severity.STATISTICS_UNQUALIFIED);
                    break;
                }
                case VERDICTOP_UNQUALIFIED: {
                    this.addBit(Severity.VERDICTOP_GETVERDICT);
                    this.addBit(Severity.VERDICTOP_SETVERDICT);
                    this.addBit(Severity.VERDICTOP_FINAL);
                    this.addBit(Severity.VERDICTOP_UNQUALIFIED);
                    break;
                }
                case WARNING_UNQUALIFIED: {
                    this.addBit(Severity.WARNING_UNQUALIFIED);
                    break;
                }
                case MATCHING_UNQUALIFIED: {
                    this.addBit(Severity.MATCHING_DONE);
                    this.addBit(Severity.MATCHING_TIMEOUT);
                    this.addBit(Severity.MATCHING_PCSUCCESS);
                    this.addBit(Severity.MATCHING_PCUNSUCC);
                    this.addBit(Severity.MATCHING_PMSUCCESS);
                    this.addBit(Severity.MATCHING_PMUNSUCC);
                    this.addBit(Severity.MATCHING_MCSUCCESS);
                    this.addBit(Severity.MATCHING_MCUNSUCC);
                    this.addBit(Severity.MATCHING_MMSUCCESS);
                    this.addBit(Severity.MATCHING_MMUNSUCC);
                    this.addBit(Severity.MATCHING_PROBLEM);
                    this.addBit(Severity.MATCHING_UNQUALIFIED);
                    break;
                }
                case DEBUG_UNQUALIFIED: {
                    this.addBit(Severity.DEBUG_ENCDEC);
                    this.addBit(Severity.DEBUG_TESTPORT);
                    this.addBit(Severity.DEBUG_USER);
                    this.addBit(Severity.DEBUG_FRAMEWORK);
                    this.addBit(Severity.DEBUG_UNQUALIFIED);
                    break;
                }
                case LOG_ALL_IMPORTANT: {
                    this.addBitmask(log_all);
                    break;
                }
            }
        }

        public String describe() {
            StringBuilder result = new StringBuilder();
            int categ = 1;
            boolean logAll = true;
            for (int i = 1; logAll && i < Severity.WARNING_UNQUALIFIED.ordinal(); ++i) {
                logAll = this.bits[i] == Logging_Bits.log_all.bits[i];
            }
            if (logAll) {
                result.append("LOG_ALL");
                categ = sev_categories.length - 2;
            }
            while (categ < sev_categories.length) {
                int low_inc = sev_categories[categ - 1].ordinal() + 1;
                int high_inc = sev_categories[categ].ordinal();
                boolean allTrue = true;
                for (int j = low_inc; allTrue && j <= high_inc; ++j) {
                    allTrue = this.bits[j];
                }
                if (allTrue) {
                    if (result.length() != 0) {
                        result.append(" | ");
                    }
                    result.append(severity_category_names[categ]);
                } else {
                    for (int subcat = low_inc; subcat <= high_inc; ++subcat) {
                        if (!this.bits[subcat]) continue;
                        if (result.length() != 0) {
                            result.append(" | ");
                        }
                        result.append(severity_category_names[categ]);
                        result.append('_');
                        result.append(severity_subcategory_names[subcat]);
                    }
                }
                ++categ;
            }
            if (result.length() == 0) {
                return "LOG_NOTHING";
            }
            return result.toString();
        }

        static {
            Logging_Bits.default_console_mask.bits[Severity.ACTION_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.default_console_mask.bits[Severity.ERROR_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.default_console_mask.bits[Severity.TESTCASE_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.default_console_mask.bits[Severity.TESTCASE_START.ordinal()] = true;
            Logging_Bits.default_console_mask.bits[Severity.TESTCASE_FINISH.ordinal()] = true;
            Logging_Bits.default_console_mask.bits[Severity.STATISTICS_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.default_console_mask.bits[Severity.STATISTICS_VERDICT.ordinal()] = true;
            Logging_Bits.default_console_mask.bits[Severity.WARNING_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.default_console_mask.bits[Severity.USER_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.ACTION_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.DEFAULTOP_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.DEFAULTOP_ACTIVATE.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.DEFAULTOP_DEACTIVATE.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.DEFAULTOP_EXIT.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.ERROR_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.EXECUTOR_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.EXECUTOR_COMPONENT.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.EXECUTOR_CONFIGDATA.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.EXECUTOR_EXTCOMMAND.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.EXECUTOR_LOGOPTIONS.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.EXECUTOR_RUNTIME.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.FUNCTION_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.FUNCTION_RND.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PARALLEL_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PARALLEL_PORTCONN.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PARALLEL_PORTMAP.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PARALLEL_PTC.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.TESTCASE_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.TESTCASE_START.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.TESTCASE_FINISH.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_DUALRECV.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_DUALSEND.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_MCRECV.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_MCSEND.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_MMRECV.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_MMSEND.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_MQUEUE.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_PCIN.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_PCOUT.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_PMIN.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_PMOUT.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_PQUEUE.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_SETSTATE.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.PORTEVENT_STATE.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.STATISTICS_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.STATISTICS_VERDICT.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.TIMEROP_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.TIMEROP_GUARD.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.TIMEROP_READ.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.TIMEROP_START.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.TIMEROP_STOP.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.TIMEROP_TIMEOUT.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.USER_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.VERDICTOP_UNQUALIFIED.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.VERDICTOP_FINAL.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.VERDICTOP_GETVERDICT.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.VERDICTOP_SETVERDICT.ordinal()] = true;
            Logging_Bits.log_all.bits[Severity.WARNING_UNQUALIFIED.ordinal()] = true;
            for (int i = 1; i < Severity.NUMBER_OF_LOGSEVERITIES.ordinal(); ++i) {
                Logging_Bits.log_everything.bits[i] = true;
            }
        }
    }
}

