/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.spelling;

import org.eclipse.cdt.internal.ui.text.spelling.CSpellingEngine;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.ISpellingEngine;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class CSpellingService
extends SpellingService {
    private static CSpellingService fInstance;
    private IPreferenceStore fPreferences;
    private ISpellingEngine fEngine;

    public static CSpellingService getInstance() {
        if (fInstance == null) {
            fInstance = new CSpellingService(EditorsUI.getPreferenceStore());
        }
        return fInstance;
    }

    public void check(final IDocument document, final IRegion[] regions, final SpellingContext context, final ISpellingProblemCollector collector, final IProgressMonitor monitor) {
        try {
            collector.beginCollecting();
            if (this.fPreferences.getBoolean("spellingEnabled") && this.fEngine == null) {
                this.fEngine = new CSpellingEngine();
            }
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    CSpellingService.this.fEngine.check(document, regions, context, collector, monitor);
                }

                public void handleException(Throwable x) {
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
        finally {
            collector.endCollecting();
        }
    }

    private CSpellingService(IPreferenceStore preferences) {
        super(preferences);
        this.fPreferences = preferences;
    }
}

