/**
 * /**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Ortung.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.toolboxmodel.Ortung.util.OrtungAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class OrtungItemProviderAdapterFactory extends OrtungAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrtungItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.Bettungswiderstand_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bettungswiderstand_TypeClassItemProvider bettungswiderstand_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.Bettungswiderstand_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBettungswiderstand_TypeClassAdapter() {
		if (bettungswiderstand_TypeClassItemProvider == null) {
			bettungswiderstand_TypeClassItemProvider = new Bettungswiderstand_TypeClassItemProvider(this);
		}

		return bettungswiderstand_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.Bezeichnung_Kennbuchstabe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Kennbuchstabe_TypeClassItemProvider bezeichnung_Kennbuchstabe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.Bezeichnung_Kennbuchstabe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Kennbuchstabe_TypeClassAdapter() {
		if (bezeichnung_Kennbuchstabe_TypeClassItemProvider == null) {
			bezeichnung_Kennbuchstabe_TypeClassItemProvider = new Bezeichnung_Kennbuchstabe_TypeClassItemProvider(this);
		}

		return bezeichnung_Kennbuchstabe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_AnlageItemProvider fmA_AnlageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_AnlageAdapter() {
		if (fmA_AnlageItemProvider == null) {
			fmA_AnlageItemProvider = new FMA_AnlageItemProvider(this);
		}

		return fmA_AnlageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Anlage_Allg_AttributeGroupItemProvider fmA_Anlage_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Anlage_Allg_AttributeGroupAdapter() {
		if (fmA_Anlage_Allg_AttributeGroupItemProvider == null) {
			fmA_Anlage_Allg_AttributeGroupItemProvider = new FMA_Anlage_Allg_AttributeGroupItemProvider(this);
		}

		return fmA_Anlage_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Anlage_Bezeichnung_AttributeGroupItemProvider fmA_Anlage_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Anlage_Bezeichnung_AttributeGroupAdapter() {
		if (fmA_Anlage_Bezeichnung_AttributeGroupItemProvider == null) {
			fmA_Anlage_Bezeichnung_AttributeGroupItemProvider = new FMA_Anlage_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return fmA_Anlage_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage_Elektr_Merkmale_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Anlage_Elektr_Merkmale_AttributeGroupItemProvider fmA_Anlage_Elektr_Merkmale_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage_Elektr_Merkmale_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Anlage_Elektr_Merkmale_AttributeGroupAdapter() {
		if (fmA_Anlage_Elektr_Merkmale_AttributeGroupItemProvider == null) {
			fmA_Anlage_Elektr_Merkmale_AttributeGroupItemProvider = new FMA_Anlage_Elektr_Merkmale_AttributeGroupItemProvider(this);
		}

		return fmA_Anlage_Elektr_Merkmale_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage_Kaskade_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Anlage_Kaskade_AttributeGroupItemProvider fmA_Anlage_Kaskade_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage_Kaskade_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Anlage_Kaskade_AttributeGroupAdapter() {
		if (fmA_Anlage_Kaskade_AttributeGroupItemProvider == null) {
			fmA_Anlage_Kaskade_AttributeGroupItemProvider = new FMA_Anlage_Kaskade_AttributeGroupItemProvider(this);
		}

		return fmA_Anlage_Kaskade_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage_Uebertragung_FMinfo_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Anlage_Uebertragung_FMinfo_AttributeGroupItemProvider fmA_Anlage_Uebertragung_FMinfo_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage_Uebertragung_FMinfo_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Anlage_Uebertragung_FMinfo_AttributeGroupAdapter() {
		if (fmA_Anlage_Uebertragung_FMinfo_AttributeGroupItemProvider == null) {
			fmA_Anlage_Uebertragung_FMinfo_AttributeGroupItemProvider = new FMA_Anlage_Uebertragung_FMinfo_AttributeGroupItemProvider(this);
		}

		return fmA_Anlage_Uebertragung_FMinfo_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anschluss_Bezeichnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Anschluss_Bezeichnung_TypeClassItemProvider fmA_Anschluss_Bezeichnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anschluss_Bezeichnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Anschluss_Bezeichnung_TypeClassAdapter() {
		if (fmA_Anschluss_Bezeichnung_TypeClassItemProvider == null) {
			fmA_Anschluss_Bezeichnung_TypeClassItemProvider = new FMA_Anschluss_Bezeichnung_TypeClassItemProvider(this);
		}

		return fmA_Anschluss_Bezeichnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anschluss_Speiserichtung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Anschluss_Speiserichtung_TypeClassItemProvider fmA_Anschluss_Speiserichtung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Anschluss_Speiserichtung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Anschluss_Speiserichtung_TypeClassAdapter() {
		if (fmA_Anschluss_Speiserichtung_TypeClassItemProvider == null) {
			fmA_Anschluss_Speiserichtung_TypeClassItemProvider = new FMA_Anschluss_Speiserichtung_TypeClassItemProvider(this);
		}

		return fmA_Anschluss_Speiserichtung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Art_TypeClassItemProvider fmA_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Art_TypeClassAdapter() {
		if (fmA_Art_TypeClassItemProvider == null) {
			fmA_Art_TypeClassItemProvider = new FMA_Art_TypeClassItemProvider(this);
		}

		return fmA_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Element} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_ElementItemProvider fmA_ElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Element}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_ElementAdapter() {
		if (fmA_ElementItemProvider == null) {
			fmA_ElementItemProvider = new FMA_ElementItemProvider(this);
		}

		return fmA_ElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Element_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Element_Allg_AttributeGroupItemProvider fmA_Element_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Element_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Element_Allg_AttributeGroupAdapter() {
		if (fmA_Element_Allg_AttributeGroupItemProvider == null) {
			fmA_Element_Allg_AttributeGroupItemProvider = new FMA_Element_Allg_AttributeGroupItemProvider(this);
		}

		return fmA_Element_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Element_Anschluss_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Element_Anschluss_AttributeGroupItemProvider fmA_Element_Anschluss_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Element_Anschluss_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Element_Anschluss_AttributeGroupAdapter() {
		if (fmA_Element_Anschluss_AttributeGroupItemProvider == null) {
			fmA_Element_Anschluss_AttributeGroupItemProvider = new FMA_Element_Anschluss_AttributeGroupItemProvider(this);
		}

		return fmA_Element_Anschluss_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Element_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Element_Art_TypeClassItemProvider fmA_Element_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Element_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Element_Art_TypeClassAdapter() {
		if (fmA_Element_Art_TypeClassItemProvider == null) {
			fmA_Element_Art_TypeClassItemProvider = new FMA_Element_Art_TypeClassItemProvider(this);
		}

		return fmA_Element_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Element_Seilanzahl_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Element_Seilanzahl_TypeClassItemProvider fmA_Element_Seilanzahl_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Element_Seilanzahl_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Element_Seilanzahl_TypeClassAdapter() {
		if (fmA_Element_Seilanzahl_TypeClassItemProvider == null) {
			fmA_Element_Seilanzahl_TypeClassItemProvider = new FMA_Element_Seilanzahl_TypeClassItemProvider(this);
		}

		return fmA_Element_Seilanzahl_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Element_Seiltyp_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Element_Seiltyp_TypeClassItemProvider fmA_Element_Seiltyp_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Element_Seiltyp_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Element_Seiltyp_TypeClassAdapter() {
		if (fmA_Element_Seiltyp_TypeClassItemProvider == null) {
			fmA_Element_Seiltyp_TypeClassItemProvider = new FMA_Element_Seiltyp_TypeClassItemProvider(this);
		}

		return fmA_Element_Seiltyp_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Hilffreimeldung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Hilffreimeldung_TypeClassItemProvider fmA_Hilffreimeldung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Hilffreimeldung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Hilffreimeldung_TypeClassAdapter() {
		if (fmA_Hilffreimeldung_TypeClassItemProvider == null) {
			fmA_Hilffreimeldung_TypeClassItemProvider = new FMA_Hilffreimeldung_TypeClassItemProvider(this);
		}

		return fmA_Hilffreimeldung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Isolierung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Isolierung_TypeClassItemProvider fmA_Isolierung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Isolierung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Isolierung_TypeClassAdapter() {
		if (fmA_Isolierung_TypeClassItemProvider == null) {
			fmA_Isolierung_TypeClassItemProvider = new FMA_Isolierung_TypeClassItemProvider(this);
		}

		return fmA_Isolierung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Kaskade_Bezeichnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Kaskade_Bezeichnung_TypeClassItemProvider fmA_Kaskade_Bezeichnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Kaskade_Bezeichnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Kaskade_Bezeichnung_TypeClassAdapter() {
		if (fmA_Kaskade_Bezeichnung_TypeClassItemProvider == null) {
			fmA_Kaskade_Bezeichnung_TypeClassItemProvider = new FMA_Kaskade_Bezeichnung_TypeClassItemProvider(this);
		}

		return fmA_Kaskade_Bezeichnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Kaskade_Einzelauswertung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Kaskade_Einzelauswertung_TypeClassItemProvider fmA_Kaskade_Einzelauswertung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Kaskade_Einzelauswertung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Kaskade_Einzelauswertung_TypeClassAdapter() {
		if (fmA_Kaskade_Einzelauswertung_TypeClassItemProvider == null) {
			fmA_Kaskade_Einzelauswertung_TypeClassItemProvider = new FMA_Kaskade_Einzelauswertung_TypeClassItemProvider(this);
		}

		return fmA_Kaskade_Einzelauswertung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_KomponenteItemProvider fmA_KomponenteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_KomponenteAdapter() {
		if (fmA_KomponenteItemProvider == null) {
			fmA_KomponenteItemProvider = new FMA_KomponenteItemProvider(this);
		}

		return fmA_KomponenteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente_Achszaehlpunkt_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Komponente_Achszaehlpunkt_AttributeGroupItemProvider fmA_Komponente_Achszaehlpunkt_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente_Achszaehlpunkt_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Komponente_Achszaehlpunkt_AttributeGroupAdapter() {
		if (fmA_Komponente_Achszaehlpunkt_AttributeGroupItemProvider == null) {
			fmA_Komponente_Achszaehlpunkt_AttributeGroupItemProvider = new FMA_Komponente_Achszaehlpunkt_AttributeGroupItemProvider(this);
		}

		return fmA_Komponente_Achszaehlpunkt_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Komponente_Art_TypeClassItemProvider fmA_Komponente_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Komponente_Art_TypeClassAdapter() {
		if (fmA_Komponente_Art_TypeClassItemProvider == null) {
			fmA_Komponente_Art_TypeClassItemProvider = new FMA_Komponente_Art_TypeClassItemProvider(this);
		}

		return fmA_Komponente_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente_Schienenprofil_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Komponente_Schienenprofil_TypeClassItemProvider fmA_Komponente_Schienenprofil_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente_Schienenprofil_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Komponente_Schienenprofil_TypeClassAdapter() {
		if (fmA_Komponente_Schienenprofil_TypeClassItemProvider == null) {
			fmA_Komponente_Schienenprofil_TypeClassItemProvider = new FMA_Komponente_Schienenprofil_TypeClassItemProvider(this);
		}

		return fmA_Komponente_Schienenprofil_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente_Stromversorgung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Komponente_Stromversorgung_TypeClassItemProvider fmA_Komponente_Stromversorgung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente_Stromversorgung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Komponente_Stromversorgung_TypeClassAdapter() {
		if (fmA_Komponente_Stromversorgung_TypeClassItemProvider == null) {
			fmA_Komponente_Stromversorgung_TypeClassItemProvider = new FMA_Komponente_Stromversorgung_TypeClassItemProvider(this);
		}

		return fmA_Komponente_Stromversorgung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente_Typ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Komponente_Typ_TypeClassItemProvider fmA_Komponente_Typ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente_Typ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Komponente_Typ_TypeClassAdapter() {
		if (fmA_Komponente_Typ_TypeClassItemProvider == null) {
			fmA_Komponente_Typ_TypeClassItemProvider = new FMA_Komponente_Typ_TypeClassItemProvider(this);
		}

		return fmA_Komponente_Typ_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Laenge_Beeinflusst_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Laenge_Beeinflusst_TypeClassItemProvider fmA_Laenge_Beeinflusst_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Laenge_Beeinflusst_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Laenge_Beeinflusst_TypeClassAdapter() {
		if (fmA_Laenge_Beeinflusst_TypeClassItemProvider == null) {
			fmA_Laenge_Beeinflusst_TypeClassItemProvider = new FMA_Laenge_Beeinflusst_TypeClassItemProvider(this);
		}

		return fmA_Laenge_Beeinflusst_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Laenge_E1_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Laenge_E1_TypeClassItemProvider fmA_Laenge_E1_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Laenge_E1_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Laenge_E1_TypeClassAdapter() {
		if (fmA_Laenge_E1_TypeClassItemProvider == null) {
			fmA_Laenge_E1_TypeClassItemProvider = new FMA_Laenge_E1_TypeClassItemProvider(this);
		}

		return fmA_Laenge_E1_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Laenge_E2_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Laenge_E2_TypeClassItemProvider fmA_Laenge_E2_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Laenge_E2_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Laenge_E2_TypeClassAdapter() {
		if (fmA_Laenge_E2_TypeClassItemProvider == null) {
			fmA_Laenge_E2_TypeClassItemProvider = new FMA_Laenge_E2_TypeClassItemProvider(this);
		}

		return fmA_Laenge_E2_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Laenge_E3_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Laenge_E3_TypeClassItemProvider fmA_Laenge_E3_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Laenge_E3_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Laenge_E3_TypeClassAdapter() {
		if (fmA_Laenge_E3_TypeClassItemProvider == null) {
			fmA_Laenge_E3_TypeClassItemProvider = new FMA_Laenge_E3_TypeClassItemProvider(this);
		}

		return fmA_Laenge_E3_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Laenge_S_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Laenge_S_TypeClassItemProvider fmA_Laenge_S_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Laenge_S_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Laenge_S_TypeClassAdapter() {
		if (fmA_Laenge_S_TypeClassItemProvider == null) {
			fmA_Laenge_S_TypeClassItemProvider = new FMA_Laenge_S_TypeClassItemProvider(this);
		}

		return fmA_Laenge_S_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Laenge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Laenge_TypeClassItemProvider fmA_Laenge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Laenge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Laenge_TypeClassAdapter() {
		if (fmA_Laenge_TypeClassItemProvider == null) {
			fmA_Laenge_TypeClassItemProvider = new FMA_Laenge_TypeClassItemProvider(this);
		}

		return fmA_Laenge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Typ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FMA_Typ_TypeClassItemProvider fmA_Typ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.FMA_Typ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFMA_Typ_TypeClassAdapter() {
		if (fmA_Typ_TypeClassItemProvider == null) {
			fmA_Typ_TypeClassItemProvider = new FMA_Typ_TypeClassItemProvider(this);
		}

		return fmA_Typ_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.Schaltmittel_Funktion_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schaltmittel_Funktion_TypeClassItemProvider schaltmittel_Funktion_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.Schaltmittel_Funktion_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchaltmittel_Funktion_TypeClassAdapter() {
		if (schaltmittel_Funktion_TypeClassItemProvider == null) {
			schaltmittel_Funktion_TypeClassItemProvider = new Schaltmittel_Funktion_TypeClassItemProvider(this);
		}

		return schaltmittel_Funktion_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.Schaltmittel_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schaltmittel_ZuordnungItemProvider schaltmittel_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.Schaltmittel_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchaltmittel_ZuordnungAdapter() {
		if (schaltmittel_ZuordnungItemProvider == null) {
			schaltmittel_ZuordnungItemProvider = new Schaltmittel_ZuordnungItemProvider(this);
		}

		return schaltmittel_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.Uebertragung_FMinfo_Richtung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Uebertragung_FMinfo_Richtung_TypeClassItemProvider uebertragung_FMinfo_Richtung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.Uebertragung_FMinfo_Richtung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUebertragung_FMinfo_Richtung_TypeClassAdapter() {
		if (uebertragung_FMinfo_Richtung_TypeClassItemProvider == null) {
			uebertragung_FMinfo_Richtung_TypeClassItemProvider = new Uebertragung_FMinfo_Richtung_TypeClassItemProvider(this);
		}

		return uebertragung_FMinfo_Richtung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.Uebertragung_FMinfo_Typ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Uebertragung_FMinfo_Typ_TypeClassItemProvider uebertragung_FMinfo_Typ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.Uebertragung_FMinfo_Typ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUebertragung_FMinfo_Typ_TypeClassAdapter() {
		if (uebertragung_FMinfo_Typ_TypeClassItemProvider == null) {
			uebertragung_FMinfo_Typ_TypeClassItemProvider = new Uebertragung_FMinfo_Typ_TypeClassItemProvider(this);
		}

		return uebertragung_FMinfo_Typ_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.Zugeinwirkung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ZugeinwirkungItemProvider zugeinwirkungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.Zugeinwirkung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZugeinwirkungAdapter() {
		if (zugeinwirkungItemProvider == null) {
			zugeinwirkungItemProvider = new ZugeinwirkungItemProvider(this);
		}

		return zugeinwirkungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.Zugeinwirkung_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zugeinwirkung_Allg_AttributeGroupItemProvider zugeinwirkung_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.Zugeinwirkung_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZugeinwirkung_Allg_AttributeGroupAdapter() {
		if (zugeinwirkung_Allg_AttributeGroupItemProvider == null) {
			zugeinwirkung_Allg_AttributeGroupItemProvider = new Zugeinwirkung_Allg_AttributeGroupItemProvider(this);
		}

		return zugeinwirkung_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.Zugeinwirkung_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zugeinwirkung_Art_TypeClassItemProvider zugeinwirkung_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.Zugeinwirkung_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZugeinwirkung_Art_TypeClassAdapter() {
		if (zugeinwirkung_Art_TypeClassItemProvider == null) {
			zugeinwirkung_Art_TypeClassItemProvider = new Zugeinwirkung_Art_TypeClassItemProvider(this);
		}

		return zugeinwirkung_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Ortung.Zugeinwirkung_Typ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zugeinwirkung_Typ_TypeClassItemProvider zugeinwirkung_Typ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Ortung.Zugeinwirkung_Typ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZugeinwirkung_Typ_TypeClassAdapter() {
		if (zugeinwirkung_Typ_TypeClassItemProvider == null) {
			zugeinwirkung_Typ_TypeClassItemProvider = new Zugeinwirkung_Typ_TypeClassItemProvider(this);
		}

		return zugeinwirkung_Typ_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (bettungswiderstand_TypeClassItemProvider != null) bettungswiderstand_TypeClassItemProvider.dispose();
		if (bezeichnung_Kennbuchstabe_TypeClassItemProvider != null) bezeichnung_Kennbuchstabe_TypeClassItemProvider.dispose();
		if (fmA_AnlageItemProvider != null) fmA_AnlageItemProvider.dispose();
		if (fmA_Anlage_Allg_AttributeGroupItemProvider != null) fmA_Anlage_Allg_AttributeGroupItemProvider.dispose();
		if (fmA_Anlage_Bezeichnung_AttributeGroupItemProvider != null) fmA_Anlage_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (fmA_Anlage_Elektr_Merkmale_AttributeGroupItemProvider != null) fmA_Anlage_Elektr_Merkmale_AttributeGroupItemProvider.dispose();
		if (fmA_Anlage_Kaskade_AttributeGroupItemProvider != null) fmA_Anlage_Kaskade_AttributeGroupItemProvider.dispose();
		if (fmA_Anlage_Uebertragung_FMinfo_AttributeGroupItemProvider != null) fmA_Anlage_Uebertragung_FMinfo_AttributeGroupItemProvider.dispose();
		if (fmA_Anschluss_Bezeichnung_TypeClassItemProvider != null) fmA_Anschluss_Bezeichnung_TypeClassItemProvider.dispose();
		if (fmA_Anschluss_Speiserichtung_TypeClassItemProvider != null) fmA_Anschluss_Speiserichtung_TypeClassItemProvider.dispose();
		if (fmA_Art_TypeClassItemProvider != null) fmA_Art_TypeClassItemProvider.dispose();
		if (fmA_ElementItemProvider != null) fmA_ElementItemProvider.dispose();
		if (fmA_Element_Allg_AttributeGroupItemProvider != null) fmA_Element_Allg_AttributeGroupItemProvider.dispose();
		if (fmA_Element_Anschluss_AttributeGroupItemProvider != null) fmA_Element_Anschluss_AttributeGroupItemProvider.dispose();
		if (fmA_Element_Art_TypeClassItemProvider != null) fmA_Element_Art_TypeClassItemProvider.dispose();
		if (fmA_Element_Seilanzahl_TypeClassItemProvider != null) fmA_Element_Seilanzahl_TypeClassItemProvider.dispose();
		if (fmA_Element_Seiltyp_TypeClassItemProvider != null) fmA_Element_Seiltyp_TypeClassItemProvider.dispose();
		if (fmA_Hilffreimeldung_TypeClassItemProvider != null) fmA_Hilffreimeldung_TypeClassItemProvider.dispose();
		if (fmA_Isolierung_TypeClassItemProvider != null) fmA_Isolierung_TypeClassItemProvider.dispose();
		if (fmA_Kaskade_Bezeichnung_TypeClassItemProvider != null) fmA_Kaskade_Bezeichnung_TypeClassItemProvider.dispose();
		if (fmA_Kaskade_Einzelauswertung_TypeClassItemProvider != null) fmA_Kaskade_Einzelauswertung_TypeClassItemProvider.dispose();
		if (fmA_KomponenteItemProvider != null) fmA_KomponenteItemProvider.dispose();
		if (fmA_Komponente_Achszaehlpunkt_AttributeGroupItemProvider != null) fmA_Komponente_Achszaehlpunkt_AttributeGroupItemProvider.dispose();
		if (fmA_Komponente_Art_TypeClassItemProvider != null) fmA_Komponente_Art_TypeClassItemProvider.dispose();
		if (fmA_Komponente_Schienenprofil_TypeClassItemProvider != null) fmA_Komponente_Schienenprofil_TypeClassItemProvider.dispose();
		if (fmA_Komponente_Stromversorgung_TypeClassItemProvider != null) fmA_Komponente_Stromversorgung_TypeClassItemProvider.dispose();
		if (fmA_Komponente_Typ_TypeClassItemProvider != null) fmA_Komponente_Typ_TypeClassItemProvider.dispose();
		if (fmA_Laenge_Beeinflusst_TypeClassItemProvider != null) fmA_Laenge_Beeinflusst_TypeClassItemProvider.dispose();
		if (fmA_Laenge_E1_TypeClassItemProvider != null) fmA_Laenge_E1_TypeClassItemProvider.dispose();
		if (fmA_Laenge_E2_TypeClassItemProvider != null) fmA_Laenge_E2_TypeClassItemProvider.dispose();
		if (fmA_Laenge_E3_TypeClassItemProvider != null) fmA_Laenge_E3_TypeClassItemProvider.dispose();
		if (fmA_Laenge_S_TypeClassItemProvider != null) fmA_Laenge_S_TypeClassItemProvider.dispose();
		if (fmA_Laenge_TypeClassItemProvider != null) fmA_Laenge_TypeClassItemProvider.dispose();
		if (fmA_Typ_TypeClassItemProvider != null) fmA_Typ_TypeClassItemProvider.dispose();
		if (schaltmittel_Funktion_TypeClassItemProvider != null) schaltmittel_Funktion_TypeClassItemProvider.dispose();
		if (schaltmittel_ZuordnungItemProvider != null) schaltmittel_ZuordnungItemProvider.dispose();
		if (uebertragung_FMinfo_Richtung_TypeClassItemProvider != null) uebertragung_FMinfo_Richtung_TypeClassItemProvider.dispose();
		if (uebertragung_FMinfo_Typ_TypeClassItemProvider != null) uebertragung_FMinfo_Typ_TypeClassItemProvider.dispose();
		if (zugeinwirkungItemProvider != null) zugeinwirkungItemProvider.dispose();
		if (zugeinwirkung_Allg_AttributeGroupItemProvider != null) zugeinwirkung_Allg_AttributeGroupItemProvider.dispose();
		if (zugeinwirkung_Art_TypeClassItemProvider != null) zugeinwirkung_Art_TypeClassItemProvider.dispose();
		if (zugeinwirkung_Typ_TypeClassItemProvider != null) zugeinwirkung_Typ_TypeClassItemProvider.dispose();
	}

}
