/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.ha.ClusterDeployer;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.deploy.FileChangeListener;
import org.apache.catalina.ha.deploy.FileMessage;
import org.apache.catalina.ha.deploy.FileMessageFactory;
import org.apache.catalina.ha.deploy.UndeployMessage;
import org.apache.catalina.ha.deploy.WarWatcher;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.util.ContextName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class FarmWarDeployer
extends ClusterListener
implements ClusterDeployer,
FileChangeListener {
    private static final Log log = LogFactory.getLog(FarmWarDeployer.class);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.ha.deploy");
    private static final String info = "FarmWarDeployer/1.2";
    protected boolean started = false;
    protected HashMap<String, FileMessageFactory> fileFactories = new HashMap();
    protected String deployDir;
    protected String tempDir;
    protected String watchDir;
    protected boolean watchEnabled = false;
    protected WarWatcher watcher = null;
    private int count = 0;
    protected int processDeployFrequency = 2;
    protected File configBase = null;
    protected Host host = null;
    protected File appBase = null;
    protected MBeanServer mBeanServer = null;
    protected ObjectName oname = null;

    public String getInfo() {
        return info;
    }

    @Override
    public void start() throws Exception {
        if (this.started) {
            return;
        }
        Container hcontainer = this.getCluster().getContainer();
        if (!(hcontainer instanceof Host)) {
            log.error(sm.getString("farmWarDeployer.hostOnly"));
            return;
        }
        this.host = (Host)hcontainer;
        Container econtainer = this.host.getParent();
        if (!(econtainer instanceof Engine)) {
            log.error(sm.getString("farmWarDeployer.hostParentEngine", this.host.getName()));
            return;
        }
        Engine engine = (Engine)econtainer;
        String hostname = null;
        hostname = this.host.getName();
        try {
            this.oname = new ObjectName(String.valueOf(engine.getName()) + ":type=Deployer,host=" + hostname);
        }
        catch (Exception e) {
            log.error(sm.getString("farmWarDeployer.mbeanNameFail", engine.getName(), hostname), e);
            return;
        }
        if (this.watchEnabled) {
            this.watcher = new WarWatcher(this, new File(this.getWatchDir()));
            if (log.isInfoEnabled()) {
                log.info(sm.getString("farmWarDeployer.watchDir", this.getWatchDir()));
            }
        }
        this.configBase = new File(System.getProperty("catalina.base"), "conf");
        this.configBase = new File(this.configBase, engine.getName());
        this.configBase = new File(this.configBase, hostname);
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
        this.started = true;
        this.count = 0;
        this.getCluster().addClusterListener(this);
        if (log.isInfoEnabled()) {
            log.info(sm.getString("farmWarDeployer.started"));
        }
    }

    @Override
    public void stop() throws LifecycleException {
        this.started = false;
        this.getCluster().removeClusterListener(this);
        this.count = 0;
        if (this.watcher != null) {
            this.watcher.clear();
            this.watcher = null;
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("farmWarDeployer.stopped"));
        }
    }

    public void cleanDeployDir() {
        throw new UnsupportedOperationException(sm.getString("farmWarDeployer.notImplemented", "cleanDeployDir()"));
    }

    @Override
    public void messageReceived(ClusterMessage msg) {
        block24: {
            try {
                if (msg instanceof FileMessage) {
                    FileMessageFactory factory;
                    FileMessage fmsg = (FileMessage)msg;
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("farmWarDeployer.msgRxDeploy", fmsg.getContextName(), fmsg.getFileName()));
                    }
                    if (!(factory = this.getFactory(fmsg)).writeMessage(fmsg)) break block24;
                    String name = factory.getFile().getName();
                    if (!name.endsWith(".war")) {
                        name = String.valueOf(name) + ".war";
                    }
                    File deployable = new File(this.getDeployDir(), name);
                    try {
                        try {
                            String contextName = fmsg.getContextName();
                            if (!this.isServiced(contextName)) {
                                this.addServiced(contextName);
                                try {
                                    this.remove(contextName);
                                    if (!factory.getFile().renameTo(deployable)) {
                                        log.error(sm.getString("farmWarDeployer.renameFail", factory.getFile(), deployable));
                                    }
                                    this.check(contextName);
                                }
                                finally {
                                    this.removeServiced(contextName);
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug(sm.getString("farmWarDeployer.deployEnd", contextName));
                                }
                                break block24;
                            }
                            log.error(sm.getString("farmWarDeployer.servicingDeploy", contextName, name));
                        }
                        catch (Exception ex) {
                            log.error(ex);
                            this.removeFactory(fmsg);
                        }
                        break block24;
                    }
                    finally {
                        this.removeFactory(fmsg);
                    }
                }
                if (!(msg instanceof UndeployMessage)) break block24;
                try {
                    UndeployMessage umsg = (UndeployMessage)msg;
                    String contextName = umsg.getContextName();
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("farmWarDeployer.msgRxUndeploy", contextName));
                    }
                    if (!this.isServiced(contextName)) {
                        this.addServiced(contextName);
                        try {
                            this.remove(contextName);
                        }
                        finally {
                            this.removeServiced(contextName);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug(sm.getString("farmWarDeployer.undeployEnd", contextName));
                        }
                        break block24;
                    }
                    log.error(sm.getString("farmWarDeployer.servicingUneploy", contextName));
                }
                catch (Exception ex) {
                    log.error(ex);
                }
            }
            catch (IOException x) {
                log.error(sm.getString("farmWarDeployer.msgIoe"), x);
            }
        }
    }

    public synchronized FileMessageFactory getFactory(FileMessage msg) throws FileNotFoundException, IOException {
        File writeToFile = new File(this.getTempDir(), msg.getFileName());
        FileMessageFactory factory = this.fileFactories.get(msg.getFileName());
        if (factory == null) {
            factory = FileMessageFactory.getInstance(writeToFile, true);
            this.fileFactories.put(msg.getFileName(), factory);
        }
        return factory;
    }

    public void removeFactory(FileMessage msg) {
        this.fileFactories.remove(msg.getFileName());
    }

    @Override
    public boolean accept(ClusterMessage msg) {
        return msg instanceof FileMessage || msg instanceof UndeployMessage;
    }

    @Override
    public void install(String contextName, File webapp) throws IOException {
        Member[] members = this.getCluster().getMembers();
        Member localMember = this.getCluster().getLocalMember();
        FileMessageFactory factory = FileMessageFactory.getInstance(webapp, false);
        FileMessage msg = new FileMessage(localMember, webapp.getName(), contextName);
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("farmWarDeployer.sendStart", contextName, webapp));
        }
        msg = factory.readMessage(msg);
        while (msg != null) {
            int i = 0;
            while (i < members.length) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("farmWarDeployer.sendFragment", contextName, webapp, members[i]));
                }
                this.getCluster().send(msg, members[i]);
                ++i;
            }
            msg = factory.readMessage(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("farmWarDeployer.sendEnd", contextName, webapp));
        }
    }

    @Override
    public void remove(String contextName, boolean undeploy) throws IOException {
        block9: {
            if (log.isInfoEnabled()) {
                log.info(sm.getString("farmWarDeployer.removeStart", contextName));
            }
            Member localMember = this.getCluster().getLocalMember();
            UndeployMessage msg = new UndeployMessage(localMember, System.currentTimeMillis(), "Undeploy:" + contextName + ":" + System.currentTimeMillis(), contextName, undeploy);
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("farmWarDeployer.removeTxMsg", contextName));
            }
            this.cluster.send(msg);
            if (undeploy) {
                try {
                    if (!this.isServiced(contextName)) {
                        this.addServiced(contextName);
                        try {
                            this.remove(contextName);
                            break block9;
                        }
                        finally {
                            this.removeServiced(contextName);
                        }
                    }
                    log.error(sm.getString("farmWarDeployer.removeFailRemote", contextName));
                }
                catch (Exception ex) {
                    log.error(sm.getString("farmWarDeployer.removeFailLocal", contextName), ex);
                }
            }
        }
    }

    @Override
    public void fileModified(File newWar) {
        try {
            File deployWar = new File(this.getDeployDir(), newWar.getName());
            this.copy(newWar, deployWar);
            ContextName cn = new ContextName(deployWar.getName());
            if (log.isInfoEnabled()) {
                log.info(sm.getString("farmWarDeployer.modInstall", cn.getName(), deployWar.getAbsolutePath()));
            }
            try {
                this.remove(cn.getName(), false);
            }
            catch (Exception x) {
                log.error(sm.getString("farmWarDeployer.modRemoveFail"), x);
            }
            this.install(cn.getName(), deployWar);
        }
        catch (Exception x) {
            log.error(sm.getString("farmWarDeployer.modInstallFail"), x);
        }
    }

    @Override
    public void fileRemoved(File removeWar) {
        try {
            ContextName cn = new ContextName(removeWar.getName());
            if (log.isInfoEnabled()) {
                log.info(sm.getString("farmWarDeployer.removeLocal", cn.getName()));
            }
            this.remove(cn.getName(), true);
        }
        catch (Exception x) {
            log.error(sm.getString("farmWarDeployer.removeLocalFail"), x);
        }
    }

    protected File getAppBase() {
        if (this.appBase != null) {
            return this.appBase;
        }
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        try {
            this.appBase = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            this.appBase = file;
        }
        return this.appBase;
    }

    protected void remove(String contextName) throws Exception {
        Context context = (Context)this.host.findChild(contextName);
        if (context != null) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("farmWarDeployer.undeployLocal", contextName));
            }
            context.stop();
            String baseName = context.getBaseName();
            File war = new File(this.getAppBase(), String.valueOf(baseName) + ".war");
            File dir = new File(this.getAppBase(), baseName);
            File xml = new File(this.configBase, String.valueOf(baseName) + ".xml");
            if (war.exists()) {
                if (!war.delete()) {
                    log.error(sm.getString("farmWarDeployer.deleteFail", war));
                }
            } else if (dir.exists()) {
                this.undeployDir(dir);
            } else if (!xml.delete()) {
                log.error(sm.getString("farmWarDeployer.deleteFail", xml));
            }
            this.check(contextName);
        }
    }

    protected void undeployDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        int i = 0;
        while (i < files.length) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                this.undeployDir(file);
            } else if (!file.delete()) {
                log.error(sm.getString("farmWarDeployer.deleteFail", file));
            }
            ++i;
        }
        if (!dir.delete()) {
            log.error(sm.getString("farmWarDeployer.deleteFail", dir));
        }
    }

    @Override
    public void backgroundProcess() {
        if (this.started) {
            this.count = (this.count + 1) % this.processDeployFrequency;
            if (this.count == 0 && this.watchEnabled) {
                this.watcher.check();
            }
        }
    }

    protected void check(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "check", params, signature);
    }

    protected boolean isServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        Boolean result = (Boolean)this.mBeanServer.invoke(this.oname, "isServiced", params, signature);
        return result;
    }

    protected void addServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "addServiced", params, signature);
    }

    protected void removeServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "removeServiced", params, signature);
    }

    @Override
    public boolean equals(Object listener) {
        return super.equals(listener);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String getDeployDir() {
        return this.deployDir;
    }

    public void setDeployDir(String deployDir) {
        this.deployDir = deployDir;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public String getWatchDir() {
        return this.watchDir;
    }

    public void setWatchDir(String watchDir) {
        this.watchDir = watchDir;
    }

    public boolean isWatchEnabled() {
        return this.watchEnabled;
    }

    public boolean getWatchEnabled() {
        return this.watchEnabled;
    }

    public void setWatchEnabled(boolean watchEnabled) {
        this.watchEnabled = watchEnabled;
    }

    public int getProcessDeployFrequency() {
        return this.processDeployFrequency;
    }

    public void setProcessDeployFrequency(int processExpiresFrequency) {
        if (processExpiresFrequency <= 0) {
            return;
        }
        this.processDeployFrequency = processExpiresFrequency;
    }

    protected boolean copy(File from, File to) {
        block4: {
            if (to.exists() || to.createNewFile()) break block4;
            log.error(sm.getString("fileNewFail", to));
            return false;
        }
        try {
            int len;
            FileInputStream is = new FileInputStream(from);
            FileOutputStream os = new FileOutputStream(to, false);
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            log.error(sm.getString("farmWarDeployer.fileCopyFail", from, to), e);
            return false;
        }
        return true;
    }
}

