/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CLabelTab
extends ExampleTab {
    private CLabel left;
    private CLabel center;
    private CLabel right;
    private boolean showBgGradient;
    private final String markup;
    private boolean markupEnabled = true;
    private static final String IMAGE2 = "resources/newfile_wiz.gif";
    private static final String IMAGE1 = "resources/button-image.gif";

    public CLabelTab() {
        super("CLabel");
        this.markup = "<big><i>Some</i></big> <b>Other</b> <small>Text With Markup</small> - 2<sup>16</sup>";
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createStyleButton("LEFT", 16384);
        this.createStyleButton("RIGHT", 131072);
        this.createStyleButton("CENTER", 0x1000000);
        this.createStyleButton("SHADOW_IN", 4);
        this.createStyleButton("SHADOW_OUT", 8);
        this.createStyleButton("SHADOW_NONE", 32);
        this.createMarkupButton();
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createBgGradientButton();
        this.createFontChooser();
        this.createCursorCombo();
        this.createChangeTextControl(parent);
    }

    @Override
    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        int style = this.getStyle();
        this.left = new CLabel(parent, style);
        this.left.setText("Some Text");
        Image image1 = Util.loadImage(parent.getDisplay(), IMAGE1);
        this.left.setImage(image1);
        this.center = new CLabel(parent, style);
        this.center.setText("First Line\nSecond Line\n");
        this.right = new CLabel(parent, style);
        this.right.setData("org.eclipse.rap.rwt.markupEnabled", (Object)(this.markupEnabled ? Boolean.TRUE : null));
        this.right.setText(this.markup);
        Image image2 = Util.loadImage(parent.getDisplay(), IMAGE2);
        this.right.setImage(image2);
        this.registerControl((Control)this.left);
        this.registerControl((Control)this.center);
        this.registerControl((Control)this.right);
    }

    private Button createMarkupButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Enable Markup");
        button.setSelection(this.markupEnabled);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CLabelTab.this.markupEnabled = button.getSelection();
                CLabelTab.this.createNew();
            }
        });
        return button;
    }

    private void createChangeTextControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("Change text");
        final Text text = new Text(composite, 2048);
        Button button = new Button(composite, 8);
        button.setText("Change");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CLabelTab.this.right.setText(text.getText());
                text.setText("");
                CLabelTab.this.right.pack();
            }
        });
    }

    @Override
    protected Button createBgGradientButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Background Gradient");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CLabelTab.this.showBgGradient = button.getSelection();
                CLabelTab.this.updateBgGradient();
            }
        });
        return button;
    }

    private void updateBgGradient() {
        if (this.showBgGradient) {
            int[] percents = new int[]{25, 50, 75, 100};
            this.left.setBackground(this.gradientColors, percents);
            this.center.setBackground(this.gradientColors, percents, true);
            this.right.setBackground(this.gradientColors, percents);
        } else {
            this.left.setBackground(null, null);
            this.center.setBackground(null, null);
            this.right.setBackground(null, null);
        }
    }
}

