/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.fileupload;

import org.eclipse.rap.fileupload.FileUploadListener;
import org.eclipse.rap.fileupload.FileUploadReceiver;
import org.eclipse.rap.fileupload.internal.FileUploadHandlerStore;
import org.eclipse.rap.fileupload.internal.FileUploadListenerList;
import org.eclipse.rap.fileupload.internal.FileUploadServiceHandler;

public class FileUploadHandler {
    private final String token;
    private final FileUploadReceiver receiver;
    private final FileUploadListenerList listeners;
    private long maxFileSize = -1L;
    private long uploadTimeLimit = -1L;

    public FileUploadHandler(FileUploadReceiver receiver) {
        if (receiver == null) {
            throw new NullPointerException("receiver is null");
        }
        this.receiver = receiver;
        this.token = FileUploadHandlerStore.createToken();
        this.listeners = new FileUploadListenerList();
        FileUploadHandlerStore.getInstance().registerHandler(this.token, this);
    }

    public String getUploadUrl() {
        return FileUploadServiceHandler.getUrl(this.token);
    }

    public FileUploadReceiver getReceiver() {
        return this.receiver;
    }

    public void addUploadListener(FileUploadListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.listeners.addUploadListener(listener);
    }

    public void removeUploadListener(FileUploadListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.listeners.removeUploadListener(listener);
    }

    public void dispose() {
        FileUploadHandlerStore.getInstance().deregisterHandler(this.token);
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public long getUploadTimeLimit() {
        return this.uploadTimeLimit;
    }

    public void setUploadTimeLimit(long timeLimit) {
        this.uploadTimeLimit = timeLimit;
    }

    FileUploadListenerList getListeners() {
        return this.listeners;
    }

    String getToken() {
        return this.token;
    }
}

