/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCDelegate;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class DeviceGC
extends GCDelegate {
    private final Device device;
    private Color background;
    private Color foreground;
    private Font font;
    private int alpha;
    private int lineWidth;
    private int lineCap;
    private int lineJoin;
    private Rectangle clippingRect;

    DeviceGC(Device device) {
        this.device = device;
        this.background = device.getSystemColor(1);
        this.foreground = device.getSystemColor(2);
        this.font = device.getSystemFont();
        this.alpha = 255;
        this.lineWidth = 0;
        this.lineCap = 1;
        this.lineJoin = 1;
    }

    @Override
    void setBackground(Color color) {
        this.background = color;
    }

    @Override
    Color getBackground() {
        return this.background;
    }

    @Override
    void setForeground(Color color) {
        this.foreground = color;
    }

    @Override
    Color getForeground() {
        return this.foreground;
    }

    @Override
    void setFont(Font font) {
        this.font = font;
    }

    @Override
    Font getFont() {
        return this.font;
    }

    @Override
    Font getDefaultFont() {
        return this.device.getSystemFont();
    }

    @Override
    void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    @Override
    int getAlpha() {
        return this.alpha;
    }

    @Override
    void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Override
    int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    void setLineCap(int lineCap) {
        this.lineCap = lineCap;
    }

    @Override
    int getLineCap() {
        return this.lineCap;
    }

    @Override
    void setLineJoin(int lineJoin) {
        this.lineJoin = lineJoin;
    }

    @Override
    int getLineJoin() {
        return this.lineJoin;
    }

    @Override
    void setClipping(Rectangle rectangle) {
        this.clippingRect = rectangle;
    }

    @Override
    void setClipping(Path path) {
        this.clippingRect = this.getClippingRectangle(path);
    }

    @Override
    Rectangle getClipping() {
        if (this.clippingRect == null) {
            return this.device.getBounds();
        }
        return new Rectangle(this.clippingRect.x, this.clippingRect.y, this.clippingRect.width, this.clippingRect.height);
    }

    @Override
    Point stringExtent(String string) {
        return TextSizeUtil.stringExtent(this.font, string);
    }

    @Override
    Point textExtent(String string, int wrapWidth) {
        return TextSizeUtil.textExtent(this.font, string, wrapWidth);
    }

    @Override
    void drawPoint(int x, int y) {
    }

    @Override
    void drawLine(int x1, int y1, int x2, int y2) {
    }

    @Override
    void drawPolyline(int[] pointArray, boolean close, boolean fill) {
    }

    @Override
    void drawRectangle(Rectangle bounds, boolean fill) {
    }

    @Override
    void drawRoundRectangle(Rectangle bounds, int arcWidth, int arcHeight, boolean fill) {
    }

    @Override
    void fillGradientRectangle(Rectangle bounds, boolean vertical) {
    }

    @Override
    void drawArc(Rectangle boundsx, int startAngle, int arcAngle, boolean fill) {
    }

    @Override
    void drawImage(Image image, Rectangle src, Rectangle dest, boolean simple) {
    }

    @Override
    void drawText(String string, int x, int y, int flags) {
    }

    @Override
    void drawPath(Path path, boolean fill) {
    }
}

